/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.lang.reflect.Method;
import nz.co.gregs.dbvolution.datatypes.DBTypeAdaptor;
import nz.co.gregs.dbvolution.exceptions.DBThrownByEndUserCodeException;
import nz.co.gregs.dbvolution.internal.properties.InterfaceInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SafeOneWaySimpleTypeAdaptor {
    private static final Log log = LogFactory.getLog(SafeOneWaySimpleTypeAdaptor.class);
    private static final Method toExternalMethod;
    private static final Method toInternalMethod;
    private static final SimpleCast[] SIMPLE_CASTS;
    private String propertyName;
    private Direction direction;
    private Class<?> sourceType;
    private SimpleCast sourceCast = null;
    private DBTypeAdaptor<Object, Object> typeAdaptor;
    private SimpleCast targetCast = null;
    private Class<?> targetType;

    public SafeOneWaySimpleTypeAdaptor(String propertyName, DBTypeAdaptor<?, ?> typeAdaptor, Direction direction, Class<?> sourceType, Class<?> targetType) {
        this.propertyName = propertyName;
        this.direction = direction;
        this.typeAdaptor = typeAdaptor;
        try {
            SimpleCast cast;
            boolean matched;
            InterfaceInfo interfaceInfo = new InterfaceInfo(DBTypeAdaptor.class, typeAdaptor);
            InterfaceInfo.ParameterBounds[] parameterBounds = interfaceInfo.getInterfaceParameterValueBounds();
            InterfaceInfo.ParameterBounds sourceBounds = null;
            InterfaceInfo.ParameterBounds targetBounds = null;
            if (direction == Direction.TO_EXTERNAL) {
                sourceBounds = parameterBounds[1];
                targetBounds = parameterBounds[0];
            } else {
                sourceBounds = parameterBounds[0];
                targetBounds = parameterBounds[1];
            }
            if (sourceType != null && sourceBounds != null) {
                matched = false;
                for (Class<?> sourceBoundType : sourceBounds.upperClasses()) {
                    cast = SafeOneWaySimpleTypeAdaptor.getSimpleCastFor(sourceType, sourceBoundType);
                    if (cast == null && !sourceBoundType.isAssignableFrom(sourceType)) continue;
                    matched = true;
                    this.sourceType = sourceType;
                    this.sourceCast = cast;
                    break;
                }
                if (!matched) {
                    throw new IllegalArgumentException("TypeAdaptor " + typeAdaptor.getClass().getSimpleName() + " cannot be used with " + sourceType.getSimpleName() + " values");
                }
            } else if (sourceBounds != null && !sourceBounds.isUpperMulti()) {
                this.sourceType = sourceBounds.upperClass();
            }
            if (targetType != null && targetBounds != null) {
                matched = false;
                for (Class<?> targetBoundType : targetBounds.upperClasses()) {
                    cast = SafeOneWaySimpleTypeAdaptor.getSimpleCastFor(targetBoundType, targetType);
                    if (cast == null && !targetType.isAssignableFrom(targetBoundType)) continue;
                    matched = true;
                    this.targetCast = cast;
                    this.targetType = targetType;
                    break;
                }
                if (!matched) {
                    throw new IllegalArgumentException("TypeAdaptor " + typeAdaptor.getClass().getSimpleName() + " cannot be used with " + targetType.getSimpleName() + " values");
                }
            } else if (targetBounds != null && !targetBounds.isUpperMulti()) {
                this.targetType = targetBounds.upperClass();
            }
        }
        catch (InterfaceInfo.UnsupportedType dropped) {
        }
        catch (UnsupportedOperationException dropped) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.sourceType == null ? "unknown" : this.sourceType.getSimpleName());
        buf.append("-->");
        if (this.sourceCast != null) {
            buf.append("(");
            buf.append(this.sourceCast.getClass().getSimpleName());
            buf.append(")");
            buf.append("-->");
        }
        buf.append(this.typeAdaptor.getClass().getSimpleName());
        buf.append("-->");
        if (this.targetCast != null) {
            buf.append("(");
            buf.append(this.targetCast.getClass().getSimpleName());
            buf.append(")");
            buf.append("-->");
        }
        buf.append(this.targetType == null ? "unknown" : this.targetType.getSimpleName());
        return buf.toString();
    }

    public Class<?> getSourceType() {
        return this.sourceType;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public Object convert(Object value) {
        String valStr = value == null ? "null" : value.getClass().getSimpleName() + "[" + value + "]";
        try {
            Object result = this.convertInternal(value);
            String resultStr = result == null ? "null" : result.getClass().getSimpleName() + "[" + result + "]";
            log.debug((Object)(this + " converting " + valStr + " ==> " + resultStr));
            return result;
        }
        catch (RuntimeException e) {
            log.debug((Object)(this + " converting " + valStr + " ==> " + e.getClass().getSimpleName()));
            throw e;
        }
    }

    private Object convertInternal(Object value) {
        Object result;
        if (this.sourceCast != null && value != null ? !this.sourceCast.acceptsSource(value) : this.sourceType != null && value != null && !this.sourceType.isInstance(value)) {
            throw new ClassCastException("Cannot pass " + value.getClass().getSimpleName() + " to " + this.methodName() + ", on property " + this.propertyName);
        }
        if (this.sourceCast != null) {
            value = this.sourceCast.cast(value);
        }
        if (this.direction == Direction.TO_EXTERNAL) {
            try {
                result = this.typeAdaptor.fromDatabaseValue(value);
            }
            catch (NullPointerException e) {
                String msg = e.getLocalizedMessage() == null ? "" : ": " + e.getLocalizedMessage();
                throw new DBThrownByEndUserCodeException("Type adaptor " + this.typeAdaptor.getClass().getSimpleName() + " threw " + e.getClass().getSimpleName() + " when getting property " + this.propertyName + msg + ": Please ensure that the fromDatabaseValue method handles database NULLs as well as normal values.", e);
            }
            catch (RuntimeException e) {
                String msg = e.getLocalizedMessage() == null ? "" : ": " + e.getLocalizedMessage();
                throw new DBThrownByEndUserCodeException("Type adaptor threw " + e.getClass().getSimpleName() + " when getting property " + this.propertyName + msg, e);
            }
        }
        try {
            result = this.typeAdaptor.toDatabaseValue(value);
        }
        catch (NullPointerException e) {
            String msg = e.getLocalizedMessage() == null ? "" : ": " + e.getLocalizedMessage();
            throw new DBThrownByEndUserCodeException("Type adaptor " + this.typeAdaptor.getClass().getSimpleName() + " threw " + e.getClass().getSimpleName() + " when setting property " + this.propertyName + msg + ": Please ensure that the toDatabaseValue method handles database NULLs as well as normal values.", e);
        }
        catch (RuntimeException e) {
            String msg = e.getLocalizedMessage() == null ? "" : ": " + e.getLocalizedMessage();
            throw new DBThrownByEndUserCodeException("Type adaptor threw " + e.getClass().getSimpleName() + " when setting property " + this.propertyName + msg, e);
        }
        if (this.targetCast != null) {
            result = this.targetCast.cast(result);
        }
        if (this.targetType != null && result != null && !this.targetType.isInstance(result)) {
            throw new ClassCastException("Cannot cast " + result.getClass().getSimpleName() + " to " + this.targetType.getSimpleName() + ", on property " + this.propertyName);
        }
        return result;
    }

    private String methodName() {
        if (this.direction == Direction.TO_EXTERNAL) {
            return this.typeAdaptor.getClass().getSimpleName() + "." + toExternalMethod.getName() + "()";
        }
        return this.typeAdaptor.getClass().getSimpleName() + "." + toInternalMethod.getName() + "()";
    }

    static SimpleCast getSimpleCastFor(Class<?> sourceType, Class<?> targetType) {
        if (sourceType == null && targetType == null) {
            throw new NullPointerException("at least one of sourceType or targetType must be specified");
        }
        for (SimpleCast cast : SIMPLE_CASTS) {
            if (sourceType != null && !cast.sourceType().isAssignableFrom(sourceType) || targetType != null && !targetType.isAssignableFrom(cast.targetType())) continue;
            return cast;
        }
        return null;
    }

    static {
        SIMPLE_CASTS = new SimpleCast[]{new NumberToShortCast(), new NumberToIntegerCast(), new NumberToLongCast(), new NumberToFloatCast(), new NumberToDoubleCast()};
        try {
            toExternalMethod = DBTypeAdaptor.class.getMethod("fromDatabaseValue", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(DBTypeAdaptor.class.getSimpleName() + " does not have a 'fromDatabaseValue' method", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        try {
            toInternalMethod = DBTypeAdaptor.class.getMethod("toDatabaseValue", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(DBTypeAdaptor.class.getSimpleName() + " does not have a 'toDatabaseValue' method", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    static class NumberToDoubleCast
    extends BaseSimpleCast<Number, Double> {
        NumberToDoubleCast() {
        }

        @Override
        protected Double safeNonNullCast(Number value) {
            return value.doubleValue();
        }
    }

    static class NumberToFloatCast
    extends BaseSimpleCast<Number, Float> {
        NumberToFloatCast() {
        }

        @Override
        protected Float safeNonNullCast(Number value) {
            return Float.valueOf(value.floatValue());
        }
    }

    static class NumberToLongCast
    extends BaseSimpleCast<Number, Long> {
        NumberToLongCast() {
        }

        @Override
        protected Long safeNonNullCast(Number value) {
            return value.longValue();
        }
    }

    static class NumberToIntegerCast
    extends BaseSimpleCast<Number, Integer> {
        NumberToIntegerCast() {
        }

        @Override
        protected Integer safeNonNullCast(Number value) {
            return value.intValue();
        }
    }

    static class NumberToShortCast
    extends BaseSimpleCast<Number, Short> {
        NumberToShortCast() {
        }

        @Override
        protected Short safeNonNullCast(Number value) {
            return value.shortValue();
        }
    }

    private static abstract class BaseSimpleCast<S, T>
    implements SimpleCast {
        private Class<?> sourceType;
        private Class<?> targetType;

        public BaseSimpleCast() {
            InterfaceInfo interfaceInfo = new InterfaceInfo(BaseSimpleCast.class, this);
            InterfaceInfo.ParameterBounds[] parameterBounds = interfaceInfo.getInterfaceParameterValueBounds();
            try {
                this.sourceType = parameterBounds[0].upperClass();
                this.targetType = parameterBounds[1].upperClass();
            }
            catch (InterfaceInfo.UnsupportedType unexpected) {
                throw new RuntimeException(unexpected);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        @Override
        public Class<?> sourceType() {
            return this.sourceType;
        }

        @Override
        public Class<?> targetType() {
            return this.targetType;
        }

        @Override
        public boolean acceptsSource(Object value) {
            if (value == null) {
                return true;
            }
            return this.acceptsSource(value.getClass());
        }

        @Override
        public boolean acceptsSource(Class<?> type) {
            return this.sourceType.isAssignableFrom(type);
        }

        @Override
        public final Object cast(Object value) {
            if (value == null) {
                return null;
            }
            if (!this.sourceType().isInstance(value)) {
                throw new ClassCastException("Cannot cast " + value.getClass().getSimpleName() + " to " + this.sourceType().getSimpleName());
            }
            T result = this.safeNonNullCast(value);
            if (!this.targetType().isInstance(result)) {
                throw new ClassCastException("Cannot cast " + result.getClass().getSimpleName() + " to " + this.targetType().getSimpleName());
            }
            return result;
        }

        protected abstract T safeNonNullCast(S var1);
    }

    static interface SimpleCast {
        public boolean acceptsSource(Object var1);

        public boolean acceptsSource(Class<?> var1);

        public Object cast(Object var1);

        public Class<?> sourceType();

        public Class<?> targetType();
    }

    public static enum Direction {
        TO_INTERNAL,
        TO_EXTERNAL;

    }
}

