/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapperDefinition;
import nz.co.gregs.dbvolution.internal.properties.RowDefinitionClassWrapper;
import nz.co.gregs.dbvolution.query.RowDefinition;

public class RowDefinitionInstanceWrapper {
    private final RowDefinitionClassWrapper classWrapper;
    private final RowDefinition rowDefinition;
    private final List<PropertyWrapper> allProperties;
    private final List<PropertyWrapper> foreignKeyProperties;

    RowDefinitionInstanceWrapper(RowDefinitionClassWrapper classWrapper, RowDefinition rowDefinition) {
        if (rowDefinition == null) {
            throw new DBRuntimeException("Target object is null");
        }
        if (!classWrapper.adapteeClass().isInstance(rowDefinition)) {
            throw new DBRuntimeException("Target object's type (" + rowDefinition.getClass().getName() + ") is not compatible with given class adaptor for type " + classWrapper.adapteeClass().getName() + " (this is probably a bug in DBvolution)");
        }
        this.rowDefinition = rowDefinition;
        this.classWrapper = classWrapper;
        this.allProperties = new ArrayList<PropertyWrapper>();
        for (PropertyWrapperDefinition propertyDefinition : classWrapper.getPropertyDefinitions()) {
            this.allProperties.add(new PropertyWrapper(this, propertyDefinition, rowDefinition));
        }
        this.foreignKeyProperties = new ArrayList<PropertyWrapper>();
        for (PropertyWrapperDefinition propertyDefinition : classWrapper.getForeignKeyPropertyDefinitions()) {
            this.foreignKeyProperties.add(new PropertyWrapper(this, propertyDefinition, rowDefinition));
        }
    }

    public String toString() {
        if (this.isTable()) {
            return this.getClass().getSimpleName() + "<" + this.tableName() + ":" + this.classWrapper.adapteeClass().getName() + ">";
        }
        return this.getClass().getSimpleName() + "<no-table:" + this.classWrapper.adapteeClass().getName() + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowDefinitionInstanceWrapper)) {
            return false;
        }
        RowDefinitionInstanceWrapper other = (RowDefinitionInstanceWrapper)obj;
        if (this.classWrapper == null ? other.classWrapper != null : !this.classWrapper.equals(other.classWrapper)) {
            return false;
        }
        return !(this.rowDefinition == null ? other.rowDefinition != null : !this.rowDefinition.equals(other.rowDefinition));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classWrapper == null ? 0 : this.classWrapper.hashCode());
        result = 31 * result + (this.rowDefinition == null ? 0 : this.rowDefinition.hashCode());
        return result;
    }

    public RowDefinitionClassWrapper getClassWrapper() {
        return this.classWrapper;
    }

    public Class<?> adapteeRowDefinitionClass() {
        return this.classWrapper.adapteeClass();
    }

    public RowDefinition adapteeRowDefinition() {
        return this.rowDefinition;
    }

    public String javaName() {
        return this.classWrapper.javaName();
    }

    public String qualifiedJavaName() {
        return this.classWrapper.qualifiedJavaName();
    }

    public boolean isTable() {
        return this.classWrapper.isTable();
    }

    public String tableName() {
        return this.classWrapper.tableName();
    }

    public PropertyWrapper primaryKey() {
        if (this.classWrapper.primaryKeyDefinition() != null) {
            return new PropertyWrapper(this, this.classWrapper.primaryKeyDefinition(), this.rowDefinition);
        }
        return null;
    }

    public PropertyWrapper getPropertyByColumn(DBDatabase database, String columnName) {
        PropertyWrapperDefinition classProperty = this.classWrapper.getPropertyDefinitionByColumn(database, columnName);
        return classProperty == null ? null : new PropertyWrapper(this, classProperty, this.rowDefinition);
    }

    public PropertyWrapper getPropertyByName(String propertyName) {
        PropertyWrapperDefinition classProperty = this.classWrapper.getPropertyDefinitionByName(propertyName);
        return classProperty == null ? null : new PropertyWrapper(this, classProperty, this.rowDefinition);
    }

    public List<PropertyWrapper> getPropertyWrappers() {
        return this.allProperties;
    }

    public List<PropertyWrapper> getForeignKeyPropertyWrappers() {
        return this.foreignKeyProperties;
    }

    public List<PropertyWrapperDefinition> getForeignKeyPropertyWrapperDefinitions() {
        return this.classWrapper.getForeignKeyPropertyDefinitions();
    }

    public List<PropertyWrapperDefinition> getPropertyDefinitions() {
        return this.classWrapper.getPropertyDefinitions();
    }
}

