/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.exceptions.DBPebkacException;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.internal.properties.ColumnHandler;
import nz.co.gregs.dbvolution.internal.properties.JavaProperty;
import nz.co.gregs.dbvolution.internal.properties.JavaPropertyFilter;
import nz.co.gregs.dbvolution.internal.properties.JavaPropertyFinder;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapperDefinition;
import nz.co.gregs.dbvolution.internal.properties.RowDefinitionInstanceWrapper;
import nz.co.gregs.dbvolution.internal.properties.TableHandler;
import nz.co.gregs.dbvolution.query.RowDefinition;

public class RowDefinitionClassWrapper {
    private final Class<?> adapteeClass;
    private final boolean identityOnly;
    private final TableHandler tableHandler;
    private final PropertyWrapperDefinition primaryKeyProperty;
    private final List<PropertyWrapperDefinition> properties;
    private final Map<String, PropertyWrapperDefinition> propertiesByCaseSensitiveColumnName;
    private final Map<String, PropertyWrapperDefinition> propertiesByUpperCaseColumnName;
    private final Map<String, List<PropertyWrapperDefinition>> duplicatedPropertiesByUpperCaseColumnName;
    private final Map<String, PropertyWrapperDefinition> propertiesByPropertyName;

    public RowDefinitionClassWrapper(Class<?> clazz) {
        this(clazz, false);
    }

    RowDefinitionClassWrapper(Class<?> clazz, boolean processIdentityOnly) {
        PropertyWrapperDefinition property;
        this.adapteeClass = clazz;
        this.identityOnly = processIdentityOnly;
        this.tableHandler = new TableHandler(clazz);
        this.properties = new ArrayList<PropertyWrapperDefinition>();
        if (processIdentityOnly) {
            JavaPropertyFinder propertyFinder = RowDefinitionClassWrapper.getJavaPropertyFinder();
            for (JavaProperty javaProperty : propertyFinder.getPropertiesOf(clazz)) {
                ColumnHandler column = new ColumnHandler(javaProperty);
                if (!column.isColumn() || !column.isPrimaryKey()) continue;
                property = new PropertyWrapperDefinition(this, javaProperty, processIdentityOnly);
                this.properties.add(property);
            }
        } else {
            int columnIndex = 0;
            JavaPropertyFinder propertyFinder = RowDefinitionClassWrapper.getJavaPropertyFinder();
            for (JavaProperty javaProperty : propertyFinder.getPropertiesOf(clazz)) {
                property = new PropertyWrapperDefinition(this, javaProperty, processIdentityOnly);
                if (!property.isColumn()) continue;
                property.setColumnIndex(++columnIndex);
                this.properties.add(property);
            }
        }
        ArrayList<PropertyWrapperDefinition> primaryKeyProperties = new ArrayList<PropertyWrapperDefinition>();
        for (PropertyWrapperDefinition property2 : this.properties) {
            if (!property2.isPrimaryKey()) continue;
            primaryKeyProperties.add(property2);
        }
        if (primaryKeyProperties.size() > 1) {
            throw new UnsupportedOperationException("Multi-Column Primary Keys are not yet supported: Please remove the excess @PrimaryKey statements from " + clazz.getSimpleName());
        }
        this.primaryKeyProperty = primaryKeyProperties.isEmpty() ? null : (PropertyWrapperDefinition)primaryKeyProperties.get(0);
        this.propertiesByCaseSensitiveColumnName = new HashMap<String, PropertyWrapperDefinition>();
        this.propertiesByUpperCaseColumnName = new HashMap<String, PropertyWrapperDefinition>();
        this.propertiesByPropertyName = new HashMap<String, PropertyWrapperDefinition>();
        this.duplicatedPropertiesByUpperCaseColumnName = new HashMap<String, List<PropertyWrapperDefinition>>();
        for (PropertyWrapperDefinition property2 : this.properties) {
            this.propertiesByPropertyName.put(property2.javaName(), property2);
            if (this.propertiesByCaseSensitiveColumnName.containsKey(property2.getColumnName())) {
                if (!processIdentityOnly) {
                    throw new DBPebkacException("Class " + clazz.getName() + " has multiple properties for column " + property2.getColumnName());
                }
            } else {
                this.propertiesByCaseSensitiveColumnName.put(property2.getColumnName(), property2);
            }
            if (this.propertiesByUpperCaseColumnName.containsKey(property2.getColumnName().toUpperCase())) {
                if (processIdentityOnly) continue;
                List<PropertyWrapperDefinition> list = this.duplicatedPropertiesByUpperCaseColumnName.get(property2.getColumnName().toUpperCase());
                if (list == null) {
                    list = new ArrayList<PropertyWrapperDefinition>();
                    list.add(this.propertiesByUpperCaseColumnName.get(property2.getColumnName().toUpperCase()));
                }
                list.add(property2);
                this.duplicatedPropertiesByUpperCaseColumnName.put(property2.getColumnName().toUpperCase(), list);
                continue;
            }
            this.propertiesByUpperCaseColumnName.put(property2.getColumnName().toUpperCase(), property2);
        }
    }

    private static JavaPropertyFinder getJavaPropertyFinder() {
        return new JavaPropertyFinder(JavaPropertyFinder.Visibility.PRIVATE, JavaPropertyFinder.Visibility.PUBLIC, JavaPropertyFilter.COLUMN_PROPERTY_FILTER, JavaPropertyFinder.PropertyType.FIELD, JavaPropertyFinder.PropertyType.BEAN_PROPERTY);
    }

    private void checkForRemainingErrorsOnAcccess(DBDatabase database) {
        if (database.getDefinition().isColumnNamesCaseSensitive() && !this.duplicatedPropertiesByUpperCaseColumnName.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (List<PropertyWrapperDefinition> props : this.duplicatedPropertiesByUpperCaseColumnName.values()) {
                for (PropertyWrapperDefinition property : props) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(property.getColumnName());
                }
            }
            throw new DBRuntimeException("The following columns are referenced multiple times on case-insensitive databases: " + buf.toString());
        }
    }

    public RowDefinitionInstanceWrapper instanceWrapperFor(RowDefinition target) {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only DBRow class wrapper");
        }
        return new RowDefinitionInstanceWrapper(this, target);
    }

    public String toString() {
        if (this.isTable()) {
            return this.getClass().getSimpleName() + "<" + this.tableName() + ":" + this.adapteeClass.getName() + ">";
        }
        return this.getClass().getSimpleName() + "<no-table:" + this.adapteeClass.getName() + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowDefinitionClassWrapper)) {
            return false;
        }
        RowDefinitionClassWrapper other = (RowDefinitionClassWrapper)obj;
        return !(this.adapteeClass == null ? other.adapteeClass != null : !this.adapteeClass.equals(other.adapteeClass));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adapteeClass == null ? 0 : this.adapteeClass.hashCode());
        return result;
    }

    public Class<?> adapteeClass() {
        return this.adapteeClass;
    }

    public String javaName() {
        return this.adapteeClass.getSimpleName();
    }

    public String qualifiedJavaName() {
        return this.adapteeClass.getName();
    }

    public boolean isTable() {
        return this.tableHandler.isTable();
    }

    public String tableName() {
        return this.tableHandler.getTableName();
    }

    public PropertyWrapperDefinition primaryKeyDefinition() {
        return this.primaryKeyProperty;
    }

    public PropertyWrapperDefinition getPropertyDefinitionByColumn(DBDatabase database, String columnName) {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only DBRow class wrapper");
        }
        this.checkForRemainingErrorsOnAcccess(database);
        if (database.getDefinition().isColumnNamesCaseSensitive()) {
            return this.propertiesByUpperCaseColumnName.get(columnName.toUpperCase());
        }
        return this.propertiesByCaseSensitiveColumnName.get(columnName);
    }

    List<PropertyWrapperDefinition> getPropertyDefinitionIdentitiesByColumnNameCaseInsensitive(String columnName) {
        ArrayList<PropertyWrapperDefinition> list = new ArrayList<PropertyWrapperDefinition>();
        JavaPropertyFinder propertyFinder = RowDefinitionClassWrapper.getJavaPropertyFinder();
        for (JavaProperty javaProperty : propertyFinder.getPropertiesOf(this.adapteeClass)) {
            ColumnHandler column = new ColumnHandler(javaProperty);
            if (!column.isColumn() || !column.getColumnName().equalsIgnoreCase(columnName)) continue;
            PropertyWrapperDefinition property = new PropertyWrapperDefinition(this, javaProperty, true);
            list.add(property);
        }
        return list;
    }

    public PropertyWrapperDefinition getPropertyDefinitionByName(String propertyName) {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only DBRow class wrapper");
        }
        return this.propertiesByPropertyName.get(propertyName);
    }

    public List<PropertyWrapperDefinition> getPropertyDefinitions() {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only DBRow class wrapper");
        }
        return this.properties;
    }

    public List<PropertyWrapperDefinition> getForeignKeyPropertyDefinitions() {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only DBRow class wrapper");
        }
        ArrayList<PropertyWrapperDefinition> list = new ArrayList<PropertyWrapperDefinition>();
        for (PropertyWrapperDefinition property : this.properties) {
            if (!property.isColumn() || !property.isForeignKey()) continue;
            list.add(property);
        }
        return list;
    }
}

