/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.InternalQueryableDatatypeProxy;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.internal.properties.ColumnHandler;
import nz.co.gregs.dbvolution.internal.properties.EnumTypeHandler;
import nz.co.gregs.dbvolution.internal.properties.ForeignKeyHandler;
import nz.co.gregs.dbvolution.internal.properties.JavaProperty;
import nz.co.gregs.dbvolution.internal.properties.PropertyTypeHandler;
import nz.co.gregs.dbvolution.internal.properties.RowDefinitionClassWrapper;
import nz.co.gregs.dbvolution.query.RowDefinition;

public class PropertyWrapperDefinition {
    private final RowDefinitionClassWrapper classWrapper;
    private final JavaProperty javaProperty;
    private final ColumnHandler columnHandler;
    private final PropertyTypeHandler typeHandler;
    private final ForeignKeyHandler foreignKeyHandler;
    private final EnumTypeHandler enumTypeHandler;
    private boolean checkedForColumnExpression = false;
    private Integer columnIndex = null;

    PropertyWrapperDefinition(RowDefinitionClassWrapper classWrapper, JavaProperty javaProperty, boolean processIdentityOnly) {
        this.classWrapper = classWrapper;
        this.javaProperty = javaProperty;
        this.columnHandler = new ColumnHandler(javaProperty);
        this.typeHandler = new PropertyTypeHandler(javaProperty, processIdentityOnly);
        this.foreignKeyHandler = new ForeignKeyHandler(javaProperty, processIdentityOnly);
        this.enumTypeHandler = new EnumTypeHandler(javaProperty, this.columnHandler);
    }

    JavaProperty getRawJavaProperty() {
        return this.javaProperty;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type().getSimpleName());
        buf.append(" ");
        buf.append(this.qualifiedJavaName());
        if (!this.javaName().equalsIgnoreCase(this.getColumnName())) {
            buf.append("<").append(this.getColumnName()).append(">");
        }
        if (this.isTypeAdapted()) {
            buf.append(" (");
            buf.append(this.getRawJavaType().getSimpleName());
            buf.append(")");
        }
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.javaProperty == null ? 0 : ((Object)this.javaProperty).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyWrapperDefinition)) {
            return false;
        }
        PropertyWrapperDefinition other = (PropertyWrapperDefinition)obj;
        return !(this.javaProperty == null ? other.javaProperty != null : !((Object)this.javaProperty).equals(other.javaProperty));
    }

    public String javaName() {
        return this.javaProperty.name();
    }

    public String shortQualifiedJavaName() {
        return this.javaProperty.shortQualifiedName();
    }

    public String qualifiedJavaName() {
        return this.javaProperty.qualifiedName();
    }

    public Class<? extends QueryableDatatype> type() {
        return this.typeHandler.getType();
    }

    public boolean isInstanceOf(Class<? extends QueryableDatatype> refType) {
        return refType.isAssignableFrom(this.type());
    }

    public String tableName() {
        return this.classWrapper.tableName();
    }

    public String getColumnName() {
        return this.columnHandler.getColumnName();
    }

    public boolean isColumn() {
        return this.columnHandler.isColumn();
    }

    public boolean isPrimaryKey() {
        return this.columnHandler.isPrimaryKey();
    }

    public boolean isForeignKey() {
        return this.foreignKeyHandler.isForeignKey();
    }

    public Class<? extends DBRow> referencedClass() {
        return this.foreignKeyHandler.getReferencedClass();
    }

    public String referencedTableName() {
        return this.foreignKeyHandler.getReferencedTableName();
    }

    public String referencedColumnName() {
        return this.foreignKeyHandler.getReferencedColumnName();
    }

    public PropertyWrapperDefinition referencedPropertyDefinitionIdentity() {
        return this.foreignKeyHandler.getReferencedPropertyDefinitionIdentity();
    }

    public Class<? extends Enum<?>> getEnumType() {
        return this.enumTypeHandler.getEnumType();
    }

    public Class<?> getEnumCodeType() {
        return this.enumTypeHandler.getEnumLiteralValueType();
    }

    public boolean isReadable() {
        return this.javaProperty.isReadable();
    }

    public boolean isWritable() {
        return this.javaProperty.isWritable();
    }

    public boolean isTypeAdapted() {
        return this.typeHandler.isTypeAdapted();
    }

    public QueryableDatatype getQueryableDatatype(Object target) {
        QueryableDatatype qdt = this.typeHandler.getJavaPropertyAsQueryableDatatype(target);
        new InternalQueryableDatatypeProxy(qdt).setPropertyWrapper(this);
        return qdt;
    }

    public void setQueryableDatatype(Object target, QueryableDatatype value) {
        new InternalQueryableDatatypeProxy(value).setPropertyWrapper(this);
        this.typeHandler.setJavaPropertyAsQueryableDatatype(target, value);
    }

    public Object rawJavaValue(Object target) {
        return this.javaProperty.get(target);
    }

    public void setRawJavaValue(Object target, Object value) {
        this.javaProperty.set(target, value);
    }

    public Class<?> getRawJavaType() {
        return this.javaProperty.type();
    }

    public RowDefinitionClassWrapper getRowDefinitionClassWrapper() {
        return this.classWrapper;
    }

    public void setColumnExpression(DBExpression expression) {
        this.columnHandler.setColumnExpression(expression);
    }

    protected DBExpression getColumnExpression() {
        return this.columnHandler.getColumnExpression();
    }

    protected boolean hasColumnExpression() {
        return this.columnHandler.getColumnExpression() != null;
    }

    protected String getSelectableName(DBDatabase db, RowDefinition actualRow) {
        DBDefinition defn = db.getDefinition();
        this.checkForColumnAlias(actualRow);
        if (this.hasColumnExpression()) {
            return this.getColumnExpression().toSQLString(db);
        }
        return defn.formatTableAliasAndColumnName(actualRow, this.getColumnName());
    }

    protected String getColumnAlias(DBDatabase db, RowDefinition actualRow) {
        DBDefinition defn = db.getDefinition();
        this.checkForColumnAlias(actualRow);
        if (this.hasColumnExpression()) {
            return defn.formatForColumnAlias(String.valueOf(this.getColumnExpression().hashCode()));
        }
        return defn.formatColumnNameForDBQueryResultSet(actualRow, this.getColumnName());
    }

    void checkForColumnAlias(RowDefinition actualRow) {
        if (!this.checkedForColumnExpression && !this.hasColumnExpression()) {
            QueryableDatatype qdt;
            Object value = this.getRawJavaProperty().get(actualRow);
            if (value != null && QueryableDatatype.class.isAssignableFrom(value.getClass()) && (qdt = (QueryableDatatype)value).hasColumnExpression()) {
                this.setColumnExpression(qdt.getColumnExpression());
            }
            this.checkedForColumnExpression = true;
        }
    }

    boolean isForeignKeyTo(DBRow table) {
        return this.foreignKeyHandler.isForeignKeyTo(table.getClass());
    }

    void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public Integer getColumnIndex() {
        return this.columnIndex;
    }

    boolean isAutoIncrementColumn() {
        return this.columnHandler.isAutoIncrement();
    }
}

