/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapperDefinition;
import nz.co.gregs.dbvolution.internal.properties.RowDefinitionInstanceWrapper;
import nz.co.gregs.dbvolution.query.RowDefinition;

public class PropertyWrapper {
    private final RowDefinitionInstanceWrapper dbRowInstanceWrapper;
    private final PropertyWrapperDefinition propertyDefinition;
    private final Object target;

    public PropertyWrapper(RowDefinitionInstanceWrapper instanceWrapper, PropertyWrapperDefinition classProperty, Object target) {
        this.dbRowInstanceWrapper = instanceWrapper;
        this.propertyDefinition = classProperty;
        this.target = target;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.type().getSimpleName());
        buf.append(" ");
        buf.append(this.qualifiedJavaName());
        if (!this.javaName().equalsIgnoreCase(this.columnName())) {
            buf.append("<").append(this.columnName()).append(">");
        }
        if (this.isReadable()) {
            buf.append(" = [");
            try {
                buf.append(this.getQueryableDatatype());
            }
            catch (Exception e) {
                buf.append("<exception occurred>");
            }
            buf.append("]");
        }
        if (this.isTypeAdapted()) {
            buf.append(" (");
            buf.append(this.getRawJavaType().getSimpleName());
            if (this.isReadable()) {
                buf.append(" = [");
                try {
                    buf.append(this.rawJavaValue());
                }
                catch (Exception e) {
                    buf.append("<exception occurred>");
                }
                buf.append("]");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyDefinition == null ? 0 : this.propertyDefinition.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyWrapper)) {
            return false;
        }
        PropertyWrapper other = (PropertyWrapper)obj;
        if (this.propertyDefinition == null ? other.propertyDefinition != null : !this.propertyDefinition.equals(other.propertyDefinition)) {
            return false;
        }
        return this.target == other.target;
    }

    public String javaName() {
        return this.propertyDefinition.javaName();
    }

    public String shortQualifiedJavaName() {
        return this.propertyDefinition.shortQualifiedJavaName();
    }

    public String qualifiedJavaName() {
        return this.propertyDefinition.qualifiedJavaName();
    }

    public Class<? extends QueryableDatatype> type() {
        return this.propertyDefinition.type();
    }

    public boolean isInstanceOf(Class<? extends QueryableDatatype> refType) {
        return this.propertyDefinition.isInstanceOf(refType);
    }

    public String tableName() {
        return this.propertyDefinition.tableName();
    }

    public String columnName() {
        return this.propertyDefinition.getColumnName();
    }

    public boolean isColumn() {
        return this.propertyDefinition.isColumn();
    }

    public boolean isPrimaryKey() {
        return this.propertyDefinition.isPrimaryKey();
    }

    public boolean isForeignKey() {
        return this.propertyDefinition.isForeignKey();
    }

    public Class<? extends DBRow> referencedClass() {
        return this.propertyDefinition.referencedClass();
    }

    public String referencedTableName() {
        return this.propertyDefinition.referencedTableName();
    }

    public String referencedColumnName() {
        return this.propertyDefinition.referencedColumnName();
    }

    public PropertyWrapperDefinition referencedPropertyDefinitionIdentity() {
        return this.propertyDefinition.referencedPropertyDefinitionIdentity();
    }

    public Class<? extends Enum<?>> getEnumType() {
        return this.propertyDefinition.getEnumType();
    }

    public Class<?> getEnumCodeType() {
        return this.propertyDefinition.getEnumCodeType();
    }

    public boolean isReadable() {
        return this.propertyDefinition.isReadable();
    }

    public boolean isWritable() {
        return this.propertyDefinition.isWritable();
    }

    public boolean isTypeAdapted() {
        return this.propertyDefinition.isTypeAdapted();
    }

    public <A extends QueryableDatatype> A getQueryableDatatype() {
        return (A)this.propertyDefinition.getQueryableDatatype(this.target);
    }

    public void setQueryableDatatype(QueryableDatatype value) {
        this.propertyDefinition.setQueryableDatatype(this.target, value);
    }

    public Object rawJavaValue() {
        return this.propertyDefinition.rawJavaValue(this.target);
    }

    public void setRawJavaValue(Object value) {
        this.propertyDefinition.setRawJavaValue(this.target, value);
    }

    public Class<?> getRawJavaType() {
        return this.propertyDefinition.getRawJavaType();
    }

    public PropertyWrapperDefinition getDefinition() {
        return this.propertyDefinition;
    }

    public RowDefinitionInstanceWrapper getRowDefinitionInstanceWrapper() {
        return this.dbRowInstanceWrapper;
    }

    public boolean hasColumnExpression() {
        return this.getDefinition().hasColumnExpression();
    }

    public DBExpression getColumnExpression() throws ClassCastException {
        return this.getDefinition().getColumnExpression();
    }

    public String getSelectableName(DBDatabase db) {
        RowDefinition adapteeRowProvider = this.getRowDefinitionInstanceWrapper().adapteeRowDefinition();
        return this.getDefinition().getSelectableName(db, adapteeRowProvider);
    }

    public String getColumnAlias(DBDatabase db) {
        RowDefinition actualRow = this.getRowDefinitionInstanceWrapper().adapteeRowDefinition();
        return this.propertyDefinition.getColumnAlias(db, actualRow);
    }

    public boolean isForeignKeyTo(DBRow table) {
        return this.propertyDefinition.isForeignKeyTo(table);
    }

    public boolean isAutoIncrement() {
        return this.propertyDefinition.isAutoIncrementColumn();
    }
}

