/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Date;
import nz.co.gregs.dbvolution.annotations.DBAdaptType;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBInteger;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.datatypes.DBTypeAdaptor;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.datatypes.SimpleValueQueryableDatatypeSyncer;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.exceptions.DBThrownByEndUserCodeException;
import nz.co.gregs.dbvolution.exceptions.InvalidDeclaredTypeException;
import nz.co.gregs.dbvolution.internal.properties.InterfaceInfo;
import nz.co.gregs.dbvolution.internal.properties.JavaProperty;
import nz.co.gregs.dbvolution.internal.properties.SafeOneWaySimpleTypeAdaptor;

class PropertyTypeHandler {
    private final JavaProperty javaProperty;
    private final Class<? extends QueryableDatatype> dbvPropertyType;
    private final DBTypeAdaptor<Object, Object> typeAdaptor;
    private final QueryableDatatypeSyncer internalQdtSyncer;
    private final boolean identityOnly;
    private final DBAdaptType annotation;

    public PropertyTypeHandler(JavaProperty javaProperty, boolean processIdentityOnly) {
        Class<? extends QueryableDatatype> type;
        Class<? extends QueryableDatatype> inferredQDTType;
        Class<? extends QueryableDatatype> inferredQDTType2;
        Class<QueryableDatatype> explicitQDTType;
        this.javaProperty = javaProperty;
        this.identityOnly = processIdentityOnly;
        this.annotation = javaProperty.getAnnotation(DBAdaptType.class);
        Class<DBTypeAdaptor<?, ?>> typeAdaptorClass = null;
        if (this.annotation != null) {
            typeAdaptorClass = this.annotation.value();
        }
        Class<?> typeAdaptorInternalType = null;
        Class<?> typeAdaptorExternalType = null;
        if (!QueryableDatatype.class.isAssignableFrom(javaProperty.type()) && this.annotation == null) {
            throw new InvalidDeclaredTypeException(javaProperty.type().getName() + " is not a supported type on " + javaProperty + ". " + "Use one of the standard DB types, or use the @" + DBAdaptType.class.getSimpleName() + " annotation " + "to adapt from a non-standard type.");
        }
        if (typeAdaptorClass != null && !DBTypeAdaptor.class.isAssignableFrom(typeAdaptorClass)) {
            throw new InvalidDeclaredTypeException("Type adaptor " + typeAdaptorClass.getName() + " must implement " + DBTypeAdaptor.class.getSimpleName() + ", on " + javaProperty);
        }
        if (typeAdaptorClass != null) {
            if (typeAdaptorClass.isInterface()) {
                throw new InvalidDeclaredTypeException("Type adaptor " + typeAdaptorClass.getName() + " must not be an interface, on " + javaProperty);
            }
            if (Modifier.isAbstract(typeAdaptorClass.getModifiers())) {
                throw new InvalidDeclaredTypeException("Type adaptor " + typeAdaptorClass.getName() + " must not be abstract, on " + javaProperty);
            }
        }
        if (typeAdaptorClass != null) {
            InterfaceInfo.ParameterBounds[] parameterBounds = null;
            try {
                InterfaceInfo interfaceInfo = new InterfaceInfo(DBTypeAdaptor.class, typeAdaptorClass);
                parameterBounds = interfaceInfo.getInterfaceParameterValueBounds();
            }
            catch (UnsupportedOperationException dropped) {
                // empty catch block
            }
            if (parameterBounds != null && parameterBounds.length == 2) {
                if (parameterBounds[0].isUpperMulti()) {
                    throw new InvalidDeclaredTypeException("Type adaptor " + typeAdaptorClass.getName() + " must not be" + " declared with multiple super types for type variables" + ", on " + javaProperty);
                }
                if (parameterBounds[1].isUpperMulti()) {
                    throw new InvalidDeclaredTypeException("Type adaptor " + typeAdaptorClass.getName() + " must not be" + " declared with multiple super types for type variables" + ", on " + javaProperty);
                }
                try {
                    typeAdaptorExternalType = parameterBounds[0].upperClass();
                }
                catch (InterfaceInfo.UnsupportedType e) {
                    // empty catch block
                }
                try {
                    typeAdaptorInternalType = parameterBounds[1].upperClass();
                }
                catch (InterfaceInfo.UnsupportedType e) {
                    // empty catch block
                }
            }
        }
        if (typeAdaptorExternalType != null && QueryableDatatype.class.isAssignableFrom(typeAdaptorExternalType)) {
            throw new InvalidDeclaredTypeException("Type adaptor's external type must not be a " + QueryableDatatype.class.getSimpleName() + ", on " + javaProperty);
        }
        if (typeAdaptorInternalType != null && QueryableDatatype.class.isAssignableFrom(typeAdaptorInternalType)) {
            throw new InvalidDeclaredTypeException("Type adaptor's internal type must not be a " + QueryableDatatype.class.getSimpleName() + ", on " + javaProperty);
        }
        if (this.annotation != null && PropertyTypeHandler.explicitTypeOrNullOf(this.annotation) != null) {
            explicitQDTType = PropertyTypeHandler.explicitTypeOrNullOf(this.annotation);
            if (!QueryableDatatype.class.isAssignableFrom(explicitQDTType)) {
                throw new InvalidDeclaredTypeException("@DB" + DBAdaptType.class.getSimpleName() + "(type) on " + javaProperty + " is not a supported type. " + "Use one of the standard DB types.");
            }
            if (Modifier.isAbstract(explicitQDTType.getModifiers()) || Modifier.isInterface(explicitQDTType.getModifiers())) {
                throw new InvalidDeclaredTypeException("@DB" + DBAdaptType.class.getSimpleName() + "(type) must be a concrete type" + ", on " + javaProperty);
            }
        }
        if (typeAdaptorExternalType != null && !QueryableDatatype.class.isAssignableFrom(javaProperty.type()) && !javaProperty.type().equals(typeAdaptorExternalType) && SafeOneWaySimpleTypeAdaptor.getSimpleCastFor(javaProperty.type(), typeAdaptorExternalType) == null) {
            throw new InvalidDeclaredTypeException("Type adaptor's external " + typeAdaptorExternalType.getSimpleName() + " type is not compatible with the property type, on " + javaProperty);
        }
        if (typeAdaptorExternalType != null && QueryableDatatype.class.isAssignableFrom(javaProperty.type())) {
            explicitQDTType = javaProperty.type();
            inferredQDTType2 = PropertyTypeHandler.inferredQDTTypeForSimpleType(typeAdaptorExternalType);
            if (inferredQDTType2 == null) {
                throw new InvalidDeclaredTypeException("Type adaptor's external " + typeAdaptorExternalType.getSimpleName() + " type is not a supported simple type, on " + javaProperty);
            }
            if (!PropertyTypeHandler.isSimpleTypeSupportedByQDT(typeAdaptorExternalType, explicitQDTType)) {
                throw new InvalidDeclaredTypeException("Type adaptor's external " + typeAdaptorExternalType.getSimpleName() + " type is not compatible with a " + explicitQDTType.getSimpleName() + " property, on " + javaProperty);
            }
        }
        if (typeAdaptorInternalType != null && PropertyTypeHandler.explicitTypeOrNullOf(this.annotation) == null && (inferredQDTType = PropertyTypeHandler.inferredQDTTypeForSimpleType(typeAdaptorInternalType)) == null) {
            throw new InvalidDeclaredTypeException("Type adaptor's internal " + typeAdaptorInternalType.getSimpleName() + " type is not a supported simple type, on " + javaProperty);
        }
        if (typeAdaptorInternalType != null && PropertyTypeHandler.explicitTypeOrNullOf(this.annotation) != null) {
            explicitQDTType = PropertyTypeHandler.explicitTypeOrNullOf(this.annotation);
            inferredQDTType2 = PropertyTypeHandler.inferredQDTTypeForSimpleType(typeAdaptorInternalType);
            if (inferredQDTType2 == null) {
                throw new InvalidDeclaredTypeException("Type adaptor's internal " + typeAdaptorInternalType.getSimpleName() + " type is not a supported simple type, on " + javaProperty);
            }
            if (!PropertyTypeHandler.isSimpleTypeSupportedByQDT(typeAdaptorInternalType, explicitQDTType)) {
                throw new InvalidDeclaredTypeException("Type adaptor's internal " + typeAdaptorInternalType.getSimpleName() + " type is not compatible with " + explicitQDTType.getSimpleName() + ", on " + javaProperty);
            }
        }
        if (this.annotation == null) {
            this.typeAdaptor = null;
            this.dbvPropertyType = javaProperty.type();
            this.internalQdtSyncer = null;
        } else if (this.identityOnly) {
            type = PropertyTypeHandler.explicitTypeOrNullOf(this.annotation);
            if (type == null && typeAdaptorInternalType != null) {
                type = PropertyTypeHandler.inferredQDTTypeForSimpleType(typeAdaptorInternalType);
            }
            if (type == null) {
                throw new NullPointerException("null dbvPropertyType, this is an internal bug");
            }
            this.dbvPropertyType = type;
            this.typeAdaptor = null;
            this.internalQdtSyncer = null;
        } else {
            this.typeAdaptor = PropertyTypeHandler.newTypeAdaptorInstanceGiven(javaProperty, this.annotation);
            type = PropertyTypeHandler.explicitTypeOrNullOf(this.annotation);
            if (type == null && typeAdaptorInternalType != null) {
                type = PropertyTypeHandler.inferredQDTTypeForSimpleType(typeAdaptorInternalType);
            }
            if (type == null) {
                throw new NullPointerException("null dbvPropertyType, this is an internal bug");
            }
            this.dbvPropertyType = type;
            Class<?> internalLiteralType = PropertyTypeHandler.literalTypeOf(type);
            Class<?> externalLiteralType = QueryableDatatype.class.isAssignableFrom(javaProperty.type()) ? PropertyTypeHandler.literalTypeOf(javaProperty.type()) : javaProperty.type();
            this.internalQdtSyncer = QueryableDatatype.class.isAssignableFrom(javaProperty.type()) ? new QueryableDatatypeSyncer(javaProperty.qualifiedName(), this.dbvPropertyType, internalLiteralType, externalLiteralType, this.typeAdaptor) : new SimpleValueQueryableDatatypeSyncer(javaProperty.qualifiedName(), this.dbvPropertyType, internalLiteralType, externalLiteralType, this.typeAdaptor);
        }
    }

    private static Class<? extends QueryableDatatype> inferredQDTTypeForSimpleType(Class<?> simpleType) {
        if (simpleType.equals(String.class)) {
            return DBString.class;
        }
        if (Number.class.isAssignableFrom(simpleType)) {
            if (Integer.class.isAssignableFrom(simpleType) || Long.class.isAssignableFrom(simpleType)) {
                return DBInteger.class;
            }
            if (Float.class.isAssignableFrom(simpleType) || Double.class.isAssignableFrom(simpleType)) {
                return DBNumber.class;
            }
            return DBNumber.class;
        }
        if (Date.class.isAssignableFrom(simpleType)) {
            return DBDate.class;
        }
        if (Boolean.class.isAssignableFrom(simpleType)) {
            return DBBoolean.class;
        }
        return null;
    }

    private static Class<?> literalTypeOf(Class<? extends QueryableDatatype> qdtType) {
        if (qdtType.equals(DBString.class)) {
            return String.class;
        }
        if (qdtType.equals(DBNumber.class)) {
            return Double.class;
        }
        if (qdtType.equals(DBInteger.class)) {
            return Long.class;
        }
        if (qdtType.equals(DBDate.class)) {
            return Date.class;
        }
        if (qdtType.equals(DBBoolean.class)) {
            return Boolean.class;
        }
        throw new RuntimeException("Unrecognised QDT-type " + qdtType.getSimpleName());
    }

    private static boolean isSimpleTypeSupportedByQDT(Class<?> simpleType, Class<? extends QueryableDatatype> qdtType) {
        Class<? extends QueryableDatatype> inferredQDTType = PropertyTypeHandler.inferredQDTTypeForSimpleType(simpleType);
        return inferredQDTType != null && (qdtType.isAssignableFrom(inferredQDTType) || inferredQDTType.isAssignableFrom(qdtType));
    }

    private static Class<? extends QueryableDatatype> explicitTypeOrNullOf(DBAdaptType annotation) {
        if (annotation == null) {
            return null;
        }
        if (annotation.type().equals(DBAdaptType.Implicit.class)) {
            return null;
        }
        return annotation.type();
    }

    public Class<? extends QueryableDatatype> getType() {
        return this.dbvPropertyType;
    }

    public boolean isTypeAdapted() {
        return this.annotation != null;
    }

    public QueryableDatatype getJavaPropertyAsQueryableDatatype(Object target) {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to read value from identity-only property");
        }
        if (this.typeAdaptor != null && this.internalQdtSyncer instanceof SimpleValueQueryableDatatypeSyncer) {
            SimpleValueQueryableDatatypeSyncer syncer = (SimpleValueQueryableDatatypeSyncer)this.internalQdtSyncer;
            Object externalValue = this.javaProperty.get(target);
            return syncer.setInternalQDTFromExternalSimpleValue(externalValue);
        }
        if (this.typeAdaptor != null) {
            Object externalValue = this.javaProperty.get(target);
            QueryableDatatype externalQdt = (QueryableDatatype)externalValue;
            return this.internalQdtSyncer.setInternalQDTFromExternalQDT(externalQdt);
        }
        return (QueryableDatatype)this.javaProperty.get(target);
    }

    public void setJavaPropertyAsQueryableDatatype(Object target, QueryableDatatype dbvValue) {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to write value to identity-only property");
        }
        if (this.typeAdaptor != null && this.internalQdtSyncer instanceof SimpleValueQueryableDatatypeSyncer) {
            SimpleValueQueryableDatatypeSyncer syncer = (SimpleValueQueryableDatatypeSyncer)this.internalQdtSyncer;
            syncer.setInternalQueryableDatatype(dbvValue);
            Object externalValue = syncer.getExternalSimpleValueFromInternalQDT();
            this.javaProperty.set(target, externalValue);
        } else if (this.typeAdaptor != null) {
            Object externalValue = this.javaProperty.get(target);
            QueryableDatatype externalQdt = (QueryableDatatype)externalValue;
            this.internalQdtSyncer.setInternalQueryableDatatype(dbvValue);
            externalQdt = this.internalQdtSyncer.setExternalFromInternalQDT(externalQdt);
            if (externalQdt == null && externalValue != null) {
                this.javaProperty.set(target, null);
            }
        } else {
            this.javaProperty.set(target, dbvValue);
        }
    }

    private static DBTypeAdaptor<Object, Object> newTypeAdaptorInstanceGiven(JavaProperty property, DBAdaptType annotation) {
        DBTypeAdaptor<Object, Object> instance;
        Constructor<DBTypeAdaptor<?, ?>> constructor;
        Class<DBTypeAdaptor<?, ?>> adaptorClass = annotation.value();
        if (adaptorClass == null) {
            throw new DBRuntimeException("Encountered unexpected null " + DBAdaptType.class.getSimpleName() + ".adptor() (probably a bug in DBvolution)");
        }
        if (adaptorClass.isInterface()) {
            throw new InvalidDeclaredTypeException("TypeAdaptor cannot be an interface (" + adaptorClass.getSimpleName() + "), on property " + property.qualifiedName());
        }
        if (Modifier.isAbstract(adaptorClass.getModifiers())) {
            throw new InvalidDeclaredTypeException("TypeAdaptor cannot be an abstract class (" + adaptorClass.getSimpleName() + "), on property " + property.qualifiedName());
        }
        try {
            adaptorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new InvalidDeclaredTypeException("Type adaptor " + adaptorClass.getName() + " could not be constructed, on property " + property.qualifiedName() + ": " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new InvalidDeclaredTypeException("Type adaptor " + adaptorClass.getName() + " could not be constructed, on property " + property.qualifiedName() + ": " + e.getMessage(), e);
        }
        try {
            constructor = adaptorClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidDeclaredTypeException("Type adaptor " + adaptorClass.getName() + " has no default constructor, on property " + property.qualifiedName(), e);
        }
        catch (SecurityException e) {
            throw new DBRuntimeException("Java security error retrieving constructor for " + adaptorClass.getName() + ", referenced by property " + property.qualifiedName() + ": " + e.getLocalizedMessage(), e);
        }
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new InvalidDeclaredTypeException(adaptorClass.getName() + " cannot be constructed (it is probably abstract), referenced by property " + property.qualifiedName(), e);
        }
        catch (IllegalAccessException e) {
            throw new DBRuntimeException("Java security error instantiating " + adaptorClass.getName() + ", referenced by property " + property.qualifiedName() + ": " + e.getLocalizedMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Internal error instantiating " + adaptorClass.getName() + ", referenced by property " + property.qualifiedName() + ": " + e.getLocalizedMessage(), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            String msg = cause.getLocalizedMessage() == null ? "" : ": " + cause.getLocalizedMessage();
            throw new DBThrownByEndUserCodeException("Constructor threw " + cause.getClass().getSimpleName() + " when instantiating " + adaptorClass.getName() + ", referenced by property " + property.qualifiedName() + msg, cause);
        }
        DBTypeAdaptor<Object, Object> result = instance;
        return result;
    }
}

