/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.internal.properties.JavaProperty;
import nz.co.gregs.dbvolution.internal.properties.JavaPropertyFilter;

class JavaPropertyFinder {
    private Set<PropertyType> propertyTypes = EnumSet.allOf(PropertyType.class);
    private Visibility fieldVisibility = Visibility.PUBLIC;
    private Visibility methodVisibility = Visibility.PUBLIC;
    private JavaPropertyFilter filter = JavaPropertyFilter.ANY_PROPERTY_FILTER;

    public JavaPropertyFinder() {
    }

    public JavaPropertyFinder(Visibility fieldVisibility, Visibility methodVisibility, JavaPropertyFilter filter, PropertyType ... propertyTypes) {
        if (methodVisibility.ordinal() > Visibility.PUBLIC.ordinal()) {
            throw new UnsupportedOperationException("Scanning for non-public property accessors is not supported");
        }
        this.fieldVisibility = fieldVisibility;
        this.methodVisibility = methodVisibility;
        JavaPropertyFilter javaPropertyFilter = this.filter = filter == null ? JavaPropertyFilter.ANY_PROPERTY_FILTER : filter;
        if (propertyTypes == null || propertyTypes.length == 0) {
            this.propertyTypes = EnumSet.allOf(PropertyType.class);
        } else {
            this.propertyTypes = EnumSet.noneOf(PropertyType.class);
            for (PropertyType propertyType : propertyTypes) {
                this.propertyTypes.add(propertyType);
            }
        }
    }

    List<JavaProperty> getPropertiesOf(Class<?> clazz) {
        ArrayList<JavaProperty> properties = new ArrayList<JavaProperty>();
        if (this.propertyTypes.contains((Object)PropertyType.FIELD)) {
            properties.addAll(this.getFields(clazz));
        }
        if (this.propertyTypes.contains((Object)PropertyType.BEAN_PROPERTY)) {
            properties.addAll(this.getBeanProperties(clazz));
        }
        return properties;
    }

    private List<JavaProperty> getFields(Class<?> clazz) {
        ArrayList<JavaProperty> properties = new ArrayList<JavaProperty>();
        HashSet<String> observedFieldNames = new HashSet<String>();
        for (Field field : clazz.getFields()) {
            if (this.filter.acceptField(field)) {
                properties.add(new JavaProperty.JavaField(field));
            }
            observedFieldNames.add(field.getName());
        }
        if (this.fieldVisibility.ordinal() > Visibility.PUBLIC.ordinal()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (observedFieldNames.contains(field.getName()) || JavaPropertyFinder.visibilityOf(field).ordinal() > this.fieldVisibility.ordinal() || field.getName().equals("serialVersionUID") || !this.filter.acceptField(field)) continue;
                field.setAccessible(true);
                properties.add(new JavaProperty.JavaField(field));
            }
        }
        return properties;
    }

    private List<JavaProperty> getBeanProperties(Class<?> clazz) {
        ArrayList<JavaProperty> properties = new ArrayList<JavaProperty>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                Method getter = descriptor.getReadMethod();
                Method setter = descriptor.getWriteMethod();
                if (descriptor.getName().equals("class") || !this.filter.acceptBeanProperty(getter, setter)) continue;
                properties.add(new JavaProperty.JavaBeanProperty(descriptor));
            }
        }
        catch (IntrospectionException e) {
            throw new DBRuntimeException("Error inspecting " + clazz.getName() + ": " + e.getMessage(), e);
        }
        if (this.methodVisibility.ordinal() > Visibility.PUBLIC.ordinal()) {
            throw new UnsupportedOperationException("Using non-public property accessors is not supported");
        }
        return properties;
    }

    private static Visibility visibilityOf(Field field) {
        return JavaPropertyFinder.visibilityOf(field.getModifiers());
    }

    private static Visibility visibilityOf(Method method) {
        return JavaPropertyFinder.visibilityOf(method.getModifiers());
    }

    private static Visibility visibilityOf(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return Visibility.PUBLIC;
        }
        if (Modifier.isProtected(modifiers)) {
            return Visibility.PROTECTED;
        }
        if (Modifier.isPrivate(modifiers)) {
            return Visibility.PRIVATE;
        }
        return Visibility.DEFAULT;
    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        DEFAULT,
        PRIVATE;

    }

    public static enum PropertyType {
        FIELD,
        BEAN_PROPERTY;

    }
}

