/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import nz.co.gregs.dbvolution.annotations.DBColumn;

interface JavaPropertyFilter {
    public static final JavaPropertyFilter ANY_PROPERTY_FILTER = new AnyPropertyFilter();
    public static final JavaPropertyFilter COLUMN_PROPERTY_FILTER = new ColumnPropertyFilter();

    public boolean acceptField(Field var1);

    public boolean acceptBeanProperty(Method var1, Method var2);

    public static class ColumnPropertyFilter
    implements JavaPropertyFilter {
        @Override
        public boolean acceptField(Field field) {
            return field.isAnnotationPresent(DBColumn.class);
        }

        @Override
        public boolean acceptBeanProperty(Method getter, Method setter) {
            return getter != null && getter.isAnnotationPresent(DBColumn.class) || setter != null && setter.isAnnotationPresent(DBColumn.class);
        }
    }

    public static class AnyPropertyFilter
    implements JavaPropertyFilter {
        @Override
        public boolean acceptField(Field field) {
            return true;
        }

        @Override
        public boolean acceptBeanProperty(Method getter, Method setter) {
            return true;
        }
    }
}

