/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.exceptions.DBPebkacException;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.exceptions.DBThrownByEndUserCodeException;
import nz.co.gregs.dbvolution.exceptions.FailedToSetPropertyValueOnRowDefinition;

interface JavaProperty {
    public String toString();

    public boolean equals(Object var1);

    public int hashCode();

    public boolean isField();

    public String name();

    public String shortQualifiedName();

    public String qualifiedName();

    public Class<?> type();

    public Type genericType();

    public Object get(Object var1);

    public void set(Object var1, Object var2);

    public boolean isReadable();

    public boolean isWritable();

    public boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public <A extends Annotation> A getAnnotation(Class<A> var1);

    public static class JavaBeanProperty
    implements JavaProperty {
        private String name;
        private Class<?> type;
        private Type genericType;
        private Method getter;
        private Method setter;

        public JavaBeanProperty(PropertyDescriptor descriptor) {
            Type[] types;
            this.name = descriptor.getName();
            this.type = descriptor.getPropertyType();
            this.getter = descriptor.getReadMethod();
            this.setter = descriptor.getWriteMethod();
            if (this.getter != null) {
                this.genericType = this.getter.getGenericReturnType();
            } else if (this.setter != null && (types = this.setter.getGenericParameterTypes()).length == 1) {
                this.genericType = types[0];
            }
        }

        @Override
        public String toString() {
            return "property " + this.type().getSimpleName() + " " + this.qualifiedName();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getter == null ? 0 : this.getter.hashCode());
            result = 31 * result + (this.setter == null ? 0 : this.setter.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof JavaBeanProperty)) {
                return false;
            }
            JavaBeanProperty other = (JavaBeanProperty)obj;
            if (this.getter == null ? other.getter != null : !this.getter.equals(other.getter)) {
                return false;
            }
            return !(this.setter == null ? other.setter != null : !this.setter.equals(other.setter));
        }

        @Override
        public boolean isField() {
            return false;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String shortQualifiedName() {
            if (this.getter != null) {
                return this.getter.getDeclaringClass().getSimpleName() + "." + this.name;
            }
            if (this.setter != null) {
                return this.setter.getDeclaringClass().getSimpleName() + "." + this.name;
            }
            return this.name;
        }

        @Override
        public String qualifiedName() {
            if (this.getter != null) {
                return this.getter.getDeclaringClass().getName() + "." + this.name;
            }
            if (this.setter != null) {
                return this.setter.getDeclaringClass().getName() + "." + this.name;
            }
            return this.name;
        }

        @Override
        public Class<?> type() {
            return this.type;
        }

        @Override
        public Type genericType() {
            return this.genericType;
        }

        @Override
        public boolean isReadable() {
            return this.getter != null;
        }

        @Override
        public boolean isWritable() {
            return this.setter != null;
        }

        @Override
        public Object get(Object target) {
            if (this.getter == null) {
                throw new IllegalStateException("Internal error attempting to read non-readable property " + this.qualifiedName() + " (this is probably a DBvolution bug)");
            }
            try {
                return this.getter.invoke(target, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                String class1 = target == null ? "null" : target.getClass().getName();
                throw new DBRuntimeException("Internal error reading property " + this.qualifiedName() + " on object of type " + class1 + " (this is probably a DBvolution bug): " + e.getLocalizedMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new DBRuntimeException("Java security error reading property " + this.qualifiedName() + ": " + e.getLocalizedMessage(), e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause() == null ? e : e.getCause();
                String msg = cause.getLocalizedMessage() == null ? "" : ": " + cause.getLocalizedMessage();
                throw new DBThrownByEndUserCodeException("Accessor method threw " + cause.getClass().getSimpleName() + " reading property " + this.qualifiedName() + msg, cause);
            }
        }

        @Override
        public void set(Object target, Object value) {
            if (this.setter == null) {
                throw new IllegalStateException("Internal error attempting to write to non-writable property " + this.qualifiedName() + " (this is probably a DBvolution bug)");
            }
            try {
                this.setter.invoke(target, value);
            }
            catch (IllegalArgumentException e) {
                String class1 = target == null ? "null" : target.getClass().getName();
                throw new IllegalArgumentException("internal error writing to property " + this.qualifiedName() + " on object of type " + class1 + " (this is probably a DBvolution bug): " + e.getLocalizedMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new DBRuntimeException("Java security error writing to property " + this.qualifiedName() + ": " + e.getLocalizedMessage(), e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause() == null ? e : e.getCause();
                String msg = cause.getLocalizedMessage() == null ? "" : ": " + cause.getLocalizedMessage();
                throw new DBThrownByEndUserCodeException("Accessor method threw " + cause.getClass().getSimpleName() + " writing to property " + this.qualifiedName() + msg, cause);
            }
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.getter != null && this.getter.isAnnotationPresent(annotationClass) || this.setter != null && this.setter.isAnnotationPresent(annotationClass);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            A getterAnnotation = null;
            A setterAnnotation = null;
            if (this.getter != null) {
                getterAnnotation = this.getter.getAnnotation(annotationClass);
            }
            if (this.setter != null) {
                setterAnnotation = this.setter.getAnnotation(annotationClass);
            }
            if (getterAnnotation != null && setterAnnotation != null && !JavaBeanProperty.annotationsEqual(getterAnnotation, setterAnnotation)) {
                String name = annotationClass.getSimpleName();
                throw new DBPebkacException("@" + name + " different on " + this.qualifiedName() + " getter and setter ");
            }
            if (getterAnnotation != null) {
                return getterAnnotation;
            }
            if (setterAnnotation != null) {
                return setterAnnotation;
            }
            return null;
        }

        protected static <A extends Annotation> boolean annotationsEqual(A ann1, A ann2) {
            List<Object> values1 = JavaBeanProperty.getAnnotationValues(ann1);
            List<Object> values2 = JavaBeanProperty.getAnnotationValues(ann2);
            return ((Object)values1).equals(values2);
        }

        protected static <A extends Annotation> List<Object> getAnnotationValues(A annotation) {
            Method[] methods;
            ArrayList<Object> values = new ArrayList<Object>();
            for (Method method : methods = annotation.annotationType().getMethods()) {
                if (method.getDeclaringClass().isAssignableFrom(Annotation.class)) continue;
                try {
                    Object value = method.invoke(annotation, new Object[0]);
                    values.add(value);
                }
                catch (IllegalArgumentException e) {
                    String name = "@" + annotation.annotationType().getSimpleName() + "." + method.getName();
                    throw new DBRuntimeException("Internal error reading annotation value " + name + " (this is probably a DBvolution bug): " + e.getLocalizedMessage(), e);
                }
                catch (IllegalAccessException e) {
                    String name = "@" + annotation.annotationType().getSimpleName() + "." + method.getName();
                    throw new DBRuntimeException("Java security error reading annotation value " + name + ": " + e.getLocalizedMessage(), e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause() == null ? e : e.getCause();
                    String msg = cause.getLocalizedMessage() == null ? "" : ": " + cause.getLocalizedMessage();
                    String name = "@" + annotation.annotationType().getSimpleName() + "." + method.getName();
                    throw new DBRuntimeException("Internal error reading annotation value " + name + " (this is probably a DBvolution bug)" + msg, cause);
                }
            }
            return values;
        }
    }

    public static class JavaField
    implements JavaProperty {
        private Field field;

        public JavaField(Field field) {
            this.field = field;
        }

        @Override
        public String toString() {
            return "field " + this.qualifiedName();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof JavaField)) {
                return false;
            }
            JavaField other = (JavaField)obj;
            return !(this.field == null ? other.field != null : !this.field.equals(other.field));
        }

        @Override
        public boolean isField() {
            return true;
        }

        @Override
        public String name() {
            return this.field.getName();
        }

        @Override
        public String shortQualifiedName() {
            return this.field.getDeclaringClass().getSimpleName() + "." + this.field.getName();
        }

        @Override
        public String qualifiedName() {
            return this.field.getDeclaringClass().getName() + "." + this.field.getName();
        }

        @Override
        public Class<?> type() {
            return this.field.getType();
        }

        @Override
        public Type genericType() {
            return this.field.getGenericType();
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public Object get(Object target) {
            try {
                return this.field.get(target);
            }
            catch (IllegalArgumentException e) {
                String class1 = target == null ? "null" : target.getClass().getName();
                throw new FailedToSetPropertyValueOnRowDefinition(this.qualifiedName(), class1, e);
            }
            catch (IllegalAccessException e) {
                throw new DBRuntimeException("Java security error reading field " + this.qualifiedName() + ": " + e.getLocalizedMessage(), e);
            }
        }

        @Override
        public void set(Object target, Object value) {
            try {
                this.field.set(target, value);
            }
            catch (IllegalArgumentException e) {
                String class1 = target == null ? "null" : target.getClass().getName();
                throw new IllegalArgumentException("Internal error writing field " + this.qualifiedName() + " on object of type " + class1 + " (this is probably a DBvolution bug): " + e.getLocalizedMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new DBRuntimeException("Java security error writing field " + this.qualifiedName() + ": " + e.getLocalizedMessage(), e);
            }
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.field.isAnnotationPresent(annotationClass);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.field.getAnnotation(annotationClass);
        }
    }
}

