/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class InterfaceInfo {
    private boolean interfaceImplementedByImplementation = false;
    private ParameterBounds[] typeArgumentBounds;

    public InterfaceInfo(Class<?> interfaceClass, Object implementationObject) {
        this(interfaceClass, implementationObject.getClass());
    }

    public InterfaceInfo(Class<?> interfaceClass, Class<?> implementationClass) {
        this.typeArgumentBounds = InterfaceInfo.getParameterBounds(interfaceClass, implementationClass);
        this.interfaceImplementedByImplementation = this.typeArgumentBounds != null;
    }

    public boolean isInterfaceImplementedByImplementation() {
        return this.interfaceImplementedByImplementation;
    }

    public ParameterBounds[] getInterfaceParameterValueBounds() {
        return this.typeArgumentBounds;
    }

    protected static ParameterBounds[] getParameterBounds(Class<?> clazz) {
        return InterfaceInfo.getParameterBounds(clazz, clazz);
    }

    protected static ParameterBounds[] getParameterBounds(Class<?> interfaceClass, Class<?> implementationClass) {
        return InterfaceInfo.getParameterBounds(interfaceClass, implementationClass, null);
    }

    protected static ParameterBounds[] getParameterBounds(Class<?> interfaceClass, Class<?> implementationClass, ParameterBounds[] argumentValues) {
        HashMap<String, ParameterBounds> argumentValueByTypeVariableName = null;
        if (argumentValues != null) {
            TypeVariable<Class<?>>[] typeVariables = implementationClass.getTypeParameters();
            if (typeVariables.length != argumentValues.length) {
                throw new UnsupportedOperationException("Encountered mismatched number of type parameters (" + typeVariables.length + ") and values (" + argumentValues.length + ") on " + implementationClass.getSimpleName() + ": values=" + Arrays.toString(argumentValues));
            }
            argumentValueByTypeVariableName = new HashMap<String, ParameterBounds>();
            for (int i = 0; i < argumentValues.length && i < typeVariables.length; ++i) {
                argumentValueByTypeVariableName.put(typeVariables[i].getName(), argumentValues[i]);
            }
        }
        if (implementationClass.equals(interfaceClass)) {
            return ParameterBounds.boundsForParametersOf(implementationClass, argumentValueByTypeVariableName);
        }
        Type implementedInterfaceType = InterfaceInfo.ancestorTypeByClass(interfaceClass, implementationClass);
        if (implementedInterfaceType != null) {
            return ParameterBounds.boundsForParametersOf(implementedInterfaceType, argumentValueByTypeVariableName);
        }
        for (Type ancestorType : InterfaceInfo.ancestorTypesOf(implementationClass)) {
            ParameterBounds[] ancestorArgumentValues = ParameterBounds.boundsForParametersOf(ancestorType, argumentValueByTypeVariableName);
            try {
                Class<?> ancestorClass = InterfaceInfo.resolveClassOf(ancestorType);
                ParameterBounds[] result = InterfaceInfo.getParameterBounds(interfaceClass, ancestorClass, ancestorArgumentValues);
                if (result == null) continue;
                return result;
            }
            catch (UnsupportedType dropped) {
            }
        }
        return null;
    }

    private static List<Type> ancestorTypesOf(Class<?> child) {
        Type[] interfaces;
        ArrayList<Type> ancestors = new ArrayList<Type>();
        Type supertype = child.getGenericSuperclass();
        if (supertype != null && !Object.class.equals((Object)supertype)) {
            ancestors.add(supertype);
        }
        if ((interfaces = child.getGenericInterfaces()) != null) {
            for (Type interfaceType : interfaces) {
                ancestors.add(interfaceType);
            }
        }
        return ancestors;
    }

    private static Type ancestorTypeByClass(Class<?> ancestorClass, Class<?> child) {
        Type[] implementedInterfaces;
        Type supertype = child.getGenericSuperclass();
        if (supertype != null && !supertype.equals(Object.class)) {
            try {
                Class<?> supertypeClass = InterfaceInfo.resolveClassOf(supertype);
                if (supertypeClass.equals(ancestorClass)) {
                    return supertype;
                }
            }
            catch (UnsupportedType dropped) {
                // empty catch block
            }
        }
        for (Type implementedInterface : implementedInterfaces = child.getGenericInterfaces()) {
            try {
                Class<?> implementedInterfaceClass = InterfaceInfo.resolveClassOf(implementedInterface);
                if (!implementedInterfaceClass.equals(ancestorClass)) continue;
                return implementedInterface;
            }
            catch (UnsupportedType dropped) {
                // empty catch block
            }
        }
        return null;
    }

    protected static Class<?> resolveClassOf(Type type) throws UnsupportedType {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return InterfaceInfo.resolveClassOf(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof ParameterizedType) {
            return InterfaceInfo.resolveClassOf(((ParameterizedType)type).getRawType());
        }
        throw new UnsupportedType("Can't yet handle " + type.getClass().getSimpleName() + " types");
    }

    protected static String descriptionOf(Type type) {
        try {
            return InterfaceInfo.descriptionOf(type, new HashSet());
        }
        catch (RuntimeException dropped) {
            return type.toString();
        }
    }

    static String descriptionOf(Type[] types) {
        try {
            return InterfaceInfo.descriptionOf(types, new HashSet());
        }
        catch (RuntimeException dropped) {
            return Arrays.toString(types);
        }
    }

    private static String descriptionOf(Type[] types, Set<TypeVariable<?>> observedTypeVariables) {
        return InterfaceInfo.conditionalDescriptionOf(null, types, null, observedTypeVariables);
    }

    private static String conditionalDescriptionOf(String conditionalPrefix, Type[] types, String conditionalPostfix, Set<TypeVariable<?>> observedTypeVariables) {
        StringBuilder buf = new StringBuilder();
        if (types != null && types.length > 0) {
            boolean first = true;
            if (conditionalPrefix != null) {
                buf.append(conditionalPrefix);
            }
            for (Type type : types) {
                if (!first) {
                    buf.append(",");
                }
                buf.append(InterfaceInfo.descriptionOf(type, observedTypeVariables));
                first = false;
            }
            if (conditionalPostfix != null) {
                buf.append(conditionalPostfix);
            }
        }
        return buf.toString();
    }

    private static String descriptionOf(Type type, Set<TypeVariable<?>> observedTypeVariables) {
        StringBuilder buf = new StringBuilder();
        if (type == null) {
            buf.append("null");
        } else if (type instanceof Class) {
            buf.append(((Class)type).getSimpleName());
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            buf.append(InterfaceInfo.descriptionOf(pt.getRawType()));
            buf.append(InterfaceInfo.conditionalDescriptionOf("<", pt.getActualTypeArguments(), ">", observedTypeVariables));
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            buf.append(typeVariable.getName());
            if (!observedTypeVariables.contains(typeVariable) && typeVariable.getBounds() != null && typeVariable.getBounds().length > 0) {
                buf.append(" extends ");
                HashSet nestedObservedTypeVariables = new HashSet(observedTypeVariables);
                nestedObservedTypeVariables.add(typeVariable);
                boolean first = true;
                for (Type boundingType : typeVariable.getBounds()) {
                    String boundingTypeDescr;
                    if (!first) {
                        buf.append(",");
                    }
                    if ((boundingTypeDescr = InterfaceInfo.descriptionOf(boundingType, nestedObservedTypeVariables)).contains(" ")) {
                        buf.append("(").append(boundingTypeDescr).append(")");
                    } else {
                        buf.append(boundingTypeDescr);
                    }
                    first = false;
                }
            }
        } else if (type instanceof WildcardType) {
            String boundingTypeDescr;
            boolean first;
            WildcardType wildcard = (WildcardType)type;
            buf.append("?");
            if (wildcard.getUpperBounds() != null && wildcard.getUpperBounds().length > 0) {
                buf.append(" extends ");
                first = true;
                for (Type boundingType : wildcard.getUpperBounds()) {
                    if (!first) {
                        buf.append(",");
                    }
                    if ((boundingTypeDescr = InterfaceInfo.descriptionOf(boundingType, observedTypeVariables)).contains(" ")) {
                        buf.append("(").append(boundingTypeDescr).append(")");
                    } else {
                        buf.append(boundingTypeDescr);
                    }
                    first = false;
                }
            }
            if (wildcard.getLowerBounds() != null && wildcard.getLowerBounds().length > 0) {
                buf.append(" super ");
                first = true;
                for (Type boundingType : wildcard.getLowerBounds()) {
                    if (!first) {
                        buf.append(",");
                    }
                    if ((boundingTypeDescr = InterfaceInfo.descriptionOf(boundingType, observedTypeVariables)).contains(" ")) {
                        buf.append("(").append(boundingTypeDescr).append(")");
                    } else {
                        buf.append(boundingTypeDescr);
                    }
                    first = false;
                }
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)type;
            String typeDescr = InterfaceInfo.descriptionOf(array.getGenericComponentType(), observedTypeVariables);
            if (typeDescr.contains(" ")) {
                buf.append("(").append(typeDescr).append(")");
            } else {
                buf.append(typeDescr);
            }
            buf.append("[]");
        } else {
            buf.append(type.toString());
        }
        return buf.toString();
    }

    public static class UnsupportedType
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnsupportedType(String message) {
            super(message);
        }
    }

    public static class ParameterBounds {
        private Type[] upperTypes;
        private Type[] lowerTypes;

        public static ParameterBounds defaultBounds() {
            return new ParameterBounds(new Type[]{Object.class}, null);
        }

        public static ParameterBounds[] boundsForParametersOf(Type parameterizedTypeRef, Map<String, ParameterBounds> paramValuesByTypeVariableName) {
            if (parameterizedTypeRef instanceof Class) {
                return ParameterBounds.boundsForParametersOf((Class)parameterizedTypeRef);
            }
            if (parameterizedTypeRef instanceof ParameterizedType) {
                return ParameterBounds.boundsForParametersOf((ParameterizedType)parameterizedTypeRef, paramValuesByTypeVariableName);
            }
            throw new UnsupportedOperationException("Expecting only Class and ParameterizedType references, encountered " + parameterizedTypeRef.getClass().getSimpleName() + ": " + InterfaceInfo.descriptionOf(parameterizedTypeRef));
        }

        public static ParameterBounds[] boundsForParametersOf(Class<?> parameterizedClass) {
            ArrayList<ParameterBounds> bounds = new ArrayList<ParameterBounds>();
            for (TypeVariable<Class<?>> typeVariable : parameterizedClass.getTypeParameters()) {
                bounds.add(ParameterBounds.getBoundsOf(typeVariable));
            }
            return bounds.toArray(new ParameterBounds[0]);
        }

        public static ParameterBounds[] boundsForParametersOf(ParameterizedType parameterizedType, Map<String, ParameterBounds> paramValuesByTypeVariableName) {
            ArrayList<ParameterBounds> allBounds = new ArrayList<ParameterBounds>();
            for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                if (paramValuesByTypeVariableName != null && typeArgument instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)typeArgument;
                    ParameterBounds value = paramValuesByTypeVariableName.get(typeVariable.getName());
                    if (value == null) {
                        throw new UnsupportedOperationException("No known value for TypeVariable " + typeVariable.getName() + " " + "in " + paramValuesByTypeVariableName + " " + "when extracting parameters of " + InterfaceInfo.descriptionOf(parameterizedType));
                    }
                    allBounds.add(value);
                    continue;
                }
                allBounds.add(ParameterBounds.getBoundsOf(typeArgument));
            }
            return allBounds.toArray(new ParameterBounds[0]);
        }

        public static ParameterBounds getBoundsOf(Type type) {
            if (type instanceof Class) {
                return new ParameterBounds(new Type[]{type}, null);
            }
            if (type instanceof GenericArrayType) {
                return new ParameterBounds(new Type[]{type}, null);
            }
            if (type instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)type;
                return new ParameterBounds(typeVariable.getBounds(), null);
            }
            if (type instanceof WildcardType) {
                WildcardType wildcard = (WildcardType)type;
                return new ParameterBounds(wildcard.getUpperBounds(), wildcard.getLowerBounds());
            }
            if (type instanceof ParameterizedType) {
                return new ParameterBounds(new Type[]{type}, null);
            }
            throw new UnsupportedOperationException("Unsupported type " + type.getClass().getSimpleName() + ": " + InterfaceInfo.descriptionOf(type));
        }

        public ParameterBounds(Type[] upperTypes, Type[] lowerTypes) {
            Type[] typeArray;
            if (upperTypes == null || upperTypes.length == 0) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = Object.class;
            } else {
                typeArray = upperTypes;
            }
            this.upperTypes = typeArray;
            this.lowerTypes = lowerTypes == null || lowerTypes.length == 0 ? null : lowerTypes;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.isUpperMulti()) {
                buf.append("{").append(InterfaceInfo.descriptionOf(this.upperTypes)).append("}");
            } else {
                buf.append(InterfaceInfo.descriptionOf(this.upperTypes));
            }
            if (this.lowerTypes != null) {
                buf.append(" super ");
                if (this.isUpperMulti()) {
                    buf.append("{").append(InterfaceInfo.descriptionOf(this.lowerTypes)).append("}");
                } else {
                    buf.append(InterfaceInfo.descriptionOf(this.lowerTypes));
                }
            }
            return buf.toString();
        }

        public boolean hasUpperBound() {
            return this.upperTypes != null;
        }

        public boolean hasLowerBound() {
            return this.lowerTypes != null;
        }

        public boolean isUpperMulti() {
            return this.upperTypes != null && this.upperTypes.length > 1;
        }

        public boolean isLowerMulti() {
            return this.lowerTypes != null && this.lowerTypes.length > 1;
        }

        public Class<?> upperClass() throws UnsupportedType {
            Type type = this.upperType();
            if (type != null) {
                return InterfaceInfo.resolveClassOf(type);
            }
            return Object.class;
        }

        public Class<?> lowerClass() throws UnsupportedType {
            Type type = this.lowerType();
            if (type != null) {
                return InterfaceInfo.resolveClassOf(type);
            }
            return null;
        }

        public Class<?>[] upperClasses() throws UnsupportedType {
            if (this.upperTypes == null) {
                return null;
            }
            Class[] classes = new Class[this.upperTypes.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = InterfaceInfo.resolveClassOf(this.upperTypes[i]);
            }
            return classes;
        }

        public Class<?>[] lowerClasses() throws UnsupportedType {
            if (this.lowerTypes == null) {
                return null;
            }
            Class[] classes = new Class[this.lowerTypes.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = InterfaceInfo.resolveClassOf(this.lowerTypes[i]);
            }
            return classes;
        }

        public Type upperType() {
            if (this.upperTypes != null && this.upperTypes.length > 1) {
                throw new IllegalStateException("Cannot get single type where multiple types are used");
            }
            return this.upperTypes == null ? null : this.upperTypes[0];
        }

        public Type lowerType() {
            if (this.lowerTypes != null && this.lowerTypes.length > 1) {
                throw new IllegalStateException("Cannot get single type where multiple types are used");
            }
            return this.lowerTypes == null ? null : this.lowerTypes[0];
        }

        public Type[] upperTypes() {
            return this.upperTypes;
        }

        public Type[] lowerTypes() {
            return this.lowerTypes;
        }
    }
}

