/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.util.List;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.annotations.DBForeignKey;
import nz.co.gregs.dbvolution.exceptions.DBPebkacException;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.internal.properties.JavaProperty;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapperDefinition;
import nz.co.gregs.dbvolution.internal.properties.RowDefinitionClassWrapper;

class ForeignKeyHandler {
    private final boolean identityOnly;
    private final Class<? extends DBRow> referencedClass;
    private final PropertyWrapperDefinition identityOnlyReferencedProperty;
    private final DBForeignKey foreignKeyAnnotation;

    ForeignKeyHandler(JavaProperty adaptee, boolean processIdentityOnly) {
        if (processIdentityOnly) {
            this.foreignKeyAnnotation = null;
            this.identityOnly = true;
        } else {
            this.foreignKeyAnnotation = adaptee.getAnnotation(DBForeignKey.class);
            this.identityOnly = false;
        }
        this.referencedClass = this.foreignKeyAnnotation != null ? this.foreignKeyAnnotation.value() : null;
        String declaredReferencedColumnName = null;
        if (this.foreignKeyAnnotation != null && this.foreignKeyAnnotation.column() != null && this.foreignKeyAnnotation.column().trim().length() > 0) {
            declaredReferencedColumnName = this.foreignKeyAnnotation.column();
        }
        PropertyWrapperDefinition identifiedReferencedProperty = null;
        if (this.referencedClass != null) {
            RowDefinitionClassWrapper referencedClassWrapper = new RowDefinitionClassWrapper(this.referencedClass, true);
            if (!referencedClassWrapper.isTable()) {
                throw new DBPebkacException(adaptee.qualifiedName() + " is a foreign key to class " + referencedClassWrapper.javaName() + ", which is not a table");
            }
            if (referencedClassWrapper.tableName() == null) {
                throw new DBRuntimeException(adaptee.qualifiedName() + " is a foreign key to class " + referencedClassWrapper.javaName() + ", which is a table but doesn't have a table name (this is probably a bug in DBvolution)");
            }
            if (declaredReferencedColumnName != null) {
                List<PropertyWrapperDefinition> properties = referencedClassWrapper.getPropertyDefinitionIdentitiesByColumnNameCaseInsensitive(declaredReferencedColumnName);
                if (properties.size() > 1) {
                    throw new DBPebkacException(adaptee.qualifiedName() + " references column " + declaredReferencedColumnName + ", however there are " + properties.size() + " such properties in " + referencedClassWrapper.javaName() + ".");
                }
                if (properties.isEmpty()) {
                    throw new DBPebkacException("Property " + adaptee.qualifiedName() + " references class " + referencedClassWrapper.javaName() + " and column " + declaredReferencedColumnName + ", but the column doesn't exist");
                }
                identifiedReferencedProperty = properties.get(0);
            }
            if (declaredReferencedColumnName == null) {
                PropertyWrapperDefinition primaryKey = referencedClassWrapper.primaryKeyDefinition();
                if (primaryKey == null) {
                    throw new DBPebkacException("Property " + adaptee.qualifiedName() + " references class " + referencedClassWrapper.javaName() + ", which does not have a primary key. Please identify the primary key on that class or specify the column in the" + " @" + DBForeignKey.class.getSimpleName() + " declaration.");
                }
                identifiedReferencedProperty = primaryKey;
            }
        }
        this.identityOnlyReferencedProperty = identifiedReferencedProperty;
    }

    public boolean isForeignKey() {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only foreign key handler");
        }
        return this.referencedClass != null;
    }

    public Class<? extends DBRow> getReferencedClass() {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only foreign key handler");
        }
        return this.referencedClass;
    }

    public String getReferencedTableName() {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only foreign key handler");
        }
        return this.identityOnlyReferencedProperty == null ? null : this.identityOnlyReferencedProperty.tableName();
    }

    public String getReferencedColumnName() {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only foreign key handler");
        }
        return this.identityOnlyReferencedProperty == null ? null : this.identityOnlyReferencedProperty.getColumnName();
    }

    public PropertyWrapperDefinition getReferencedPropertyDefinitionIdentity() {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only foreign key handler");
        }
        return this.identityOnlyReferencedProperty;
    }

    public DBForeignKey getDBForeignKeyAnnotation() {
        if (this.identityOnly) {
            throw new AssertionError((Object)"Attempt to access non-identity information of identity-only foreign key handler");
        }
        return this.foreignKeyAnnotation;
    }

    boolean isForeignKeyTo(Class<? extends DBRow> aClass) {
        Class<? extends DBRow> reffedClass = this.getReferencedClass();
        boolean assignableFrom = reffedClass.isAssignableFrom(aClass);
        return assignableFrom;
    }
}

