/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import nz.co.gregs.dbvolution.datatypes.DBEnum;
import nz.co.gregs.dbvolution.datatypes.DBEnumValue;
import nz.co.gregs.dbvolution.exceptions.InvalidDeclaredTypeException;
import nz.co.gregs.dbvolution.internal.properties.ColumnHandler;
import nz.co.gregs.dbvolution.internal.properties.JavaProperty;

class EnumTypeHandler {
    private final Class<? extends Enum<?>> enumType;
    private final Class<?> enumLiteralValueType;

    EnumTypeHandler(JavaProperty javaProperty, ColumnHandler columnHandler) {
        Type type = javaProperty.genericType();
        Class<?> propertyClass = EnumTypeHandler.classOf(type);
        Class<?> identifiedEnumType = null;
        Class<?> identifiedEnumLiteralValueType = null;
        if (columnHandler.isColumn() && propertyClass != null && DBEnum.class.isAssignableFrom(propertyClass)) {
            if (type instanceof ParameterizedType) {
                Type[] parameterTypes = ((ParameterizedType)type).getActualTypeArguments();
                if (parameterTypes.length >= 1) {
                    identifiedEnumType = EnumTypeHandler.classOf(parameterTypes[0]);
                }
            } else if (type instanceof WildcardType) {
                throw new InvalidDeclaredTypeException("Wildcard generics must not be used on " + propertyClass.getSimpleName() + " declaration for " + javaProperty);
            }
            if (identifiedEnumType == null) {
                throw new InvalidDeclaredTypeException("Use of " + propertyClass.getSimpleName() + " declaration requires concrete generic parameter" + " on " + javaProperty);
            }
            identifiedEnumLiteralValueType = EnumTypeHandler.enumLiteralValueTypeOf(identifiedEnumType);
        }
        this.enumType = identifiedEnumType;
        this.enumLiteralValueType = identifiedEnumLiteralValueType;
    }

    public Class<? extends Enum<?>> getEnumType() {
        return this.enumType;
    }

    public Class<?> getEnumLiteralValueType() {
        return this.enumLiteralValueType;
    }

    private static Class<?> classOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return EnumTypeHandler.classOf(((ParameterizedType)type).getRawType());
        }
        return null;
    }

    private static Class<?> enumLiteralValueTypeOf(Class<? extends Enum<?>> enumType) {
        Enum<?>[] enumValues = enumType.getEnumConstants();
        if (enumValues != null) {
            for (Enum<?> enumValue : enumValues) {
                Object code;
                if (!(enumValue instanceof DBEnumValue) || (code = ((DBEnumValue)((Object)enumValue)).getCode()) == null) continue;
                return code.getClass();
            }
        }
        return null;
    }
}

