/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.internal.properties;

import nz.co.gregs.dbvolution.annotations.DBAutoIncrement;
import nz.co.gregs.dbvolution.annotations.DBColumn;
import nz.co.gregs.dbvolution.annotations.DBPrimaryKey;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.internal.properties.JavaProperty;

class ColumnHandler {
    private final String columnName;
    private final DBColumn columnAnnotation;
    private final DBPrimaryKey primaryKeyAnnotation;
    private final DBAutoIncrement autoIncrementAnnotation;
    private DBExpression columnExpression;

    ColumnHandler(JavaProperty adaptee) {
        QueryableDatatype qdt;
        String name;
        this.columnAnnotation = adaptee.getAnnotation(DBColumn.class);
        this.primaryKeyAnnotation = adaptee.getAnnotation(DBPrimaryKey.class);
        this.autoIncrementAnnotation = adaptee.getAnnotation(DBAutoIncrement.class);
        this.columnName = this.columnAnnotation != null ? ((name = this.columnAnnotation.value()) == null || name.trim().isEmpty() ? adaptee.name() : name) : null;
        this.columnExpression = QueryableDatatype.class.isAssignableFrom(adaptee.getClass()) ? ((qdt = (QueryableDatatype)((Object)adaptee)).hasColumnExpression() ? qdt.getColumnExpression() : null) : null;
    }

    public boolean isColumn() {
        return this.columnAnnotation != null;
    }

    public boolean isPrimaryKey() {
        return this.isColumn() && this.primaryKeyAnnotation != null;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DBColumn getDBColumnAnnotation() {
        return this.columnAnnotation;
    }

    public DBExpression getColumnExpression() {
        return this.columnExpression;
    }

    void setColumnExpression(DBExpression expression) {
        this.columnExpression = expression;
    }

    boolean isAutoIncrement() {
        return this.autoIncrementAnnotation != null;
    }
}

