/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.generation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBByteArray;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBInteger;
import nz.co.gregs.dbvolution.datatypes.DBJavaObject;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.datatypes.DBUnknownDatatype;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.UnknownJavaSQLTypeException;
import nz.co.gregs.dbvolution.generation.DBTableClass;
import nz.co.gregs.dbvolution.generation.DBTableField;
import nz.co.gregs.dbvolution.generation.ForeignKeyRecognisor;
import nz.co.gregs.dbvolution.generation.PrimaryKeyRecognisor;

public class DBTableClassGenerator {
    public static void generateClasses(DBDatabase database, String packageName, String baseDirectory) throws SQLException, FileNotFoundException, IOException {
        DBTableClassGenerator.generateClasses(database, packageName, baseDirectory, 1L, new PrimaryKeyRecognisor(), new ForeignKeyRecognisor());
    }

    public static void generateClasses(DBDatabase database, String packageName, String baseDirectory, Long versionNumber) throws SQLException, FileNotFoundException, IOException {
        DBTableClassGenerator.generateClasses(database, packageName, baseDirectory, versionNumber, new PrimaryKeyRecognisor(), new ForeignKeyRecognisor());
    }

    public static void generateClasses(DBDatabase database, String packageName, String baseDirectory, Long versionNumber, PrimaryKeyRecognisor pkRecog, ForeignKeyRecognisor fkRecog) throws SQLException, FileNotFoundException, IOException {
        String viewsPackage = packageName + ".views";
        String viewsPath = viewsPackage.replaceAll("[.]", "/");
        List<DBTableClass> generatedViews = DBTableClassGenerator.generateClassesOfViews(database, viewsPackage, versionNumber, pkRecog, fkRecog);
        String tablesPackage = packageName + ".tables";
        String tablesPath = tablesPackage.replaceAll("[.]", "/");
        List<DBTableClass> generatedTables = DBTableClassGenerator.generateClassesOfTables(database, tablesPackage, versionNumber, pkRecog, fkRecog);
        ArrayList<DBTableClass> allGeneratedClasses = new ArrayList<DBTableClass>();
        allGeneratedClasses.addAll(generatedViews);
        allGeneratedClasses.addAll(generatedTables);
        DBTableClassGenerator.generateAllJavaSource(allGeneratedClasses);
        File dir = new File(baseDirectory + "/" + viewsPath);
        if (!dir.mkdirs() && !dir.exists()) {
            throw new RuntimeException("Unable to Make Directories, QUITTING!");
        }
        DBTableClassGenerator.saveGeneratedClassesToDirectory(generatedViews, dir);
        dir = new File(baseDirectory + "/" + tablesPath);
        if (!dir.mkdirs() && !dir.exists()) {
            throw new RuntimeException("Unable to Make Directories, QUITTING!");
        }
        DBTableClassGenerator.saveGeneratedClassesToDirectory(generatedTables, dir);
    }

    private static void saveGeneratedClassesToDirectory(List<DBTableClass> generatedClasses, File classDirectory) throws SQLException, FileNotFoundException, IOException {
        for (DBTableClass clazz : generatedClasses) {
            File file = new File(classDirectory, clazz.className + ".java");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(clazz.getJavaSource().getBytes());
            fileOutputStream.close();
        }
    }

    public static List<DBTableClass> generateClassesOfTables(DBDatabase database, String packageName, Long versionNumber, PrimaryKeyRecognisor pkRecog, ForeignKeyRecognisor fkRecog) throws SQLException {
        return DBTableClassGenerator.generateClassesOfObjectTypes(database, packageName, versionNumber, pkRecog, fkRecog, "TABLE");
    }

    public static List<DBTableClass> generateClassesOfViews(DBDatabase database, String packageName, Long versionNumber, PrimaryKeyRecognisor pkRecog, ForeignKeyRecognisor fkRecog) throws SQLException {
        return DBTableClassGenerator.generateClassesOfObjectTypes(database, packageName, versionNumber, pkRecog, fkRecog, "VIEW");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DBTableClass> generateClassesOfObjectTypes(DBDatabase database, String packageName, Long versionNumber, PrimaryKeyRecognisor pkRecog, ForeignKeyRecognisor fkRecog, String ... dbObjectTypes) throws SQLException {
        ArrayList<DBTableClass> dbTableClasses = new ArrayList<DBTableClass>();
        DBStatement dbStatement = database.getDBStatement();
        try {
            Connection connection = dbStatement.getConnection();
            String catalog = connection.getCatalog();
            String schema = null;
            try {
                Method method = connection.getClass().getMethod("getSchema", new Class[0]);
                schema = (String)method.invoke((Object)connection, new Object[0]);
            }
            catch (AbstractMethodError exp) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (SecurityException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet tables = metaData.getTables(catalog, schema, null, dbObjectTypes);
            try {
                while (tables.next()) {
                    DBTableClass dbTableClass = new DBTableClass();
                    dbTableClass.setPackageName(packageName);
                    dbTableClass.serialversionUIDBValue = versionNumber;
                    dbTableClass.setTableName(tables.getString("TABLE_NAME"));
                    dbTableClass.className = DBTableClassGenerator.toClassCase(dbTableClass.getTableName());
                    ResultSet primaryKeysRS = metaData.getPrimaryKeys(catalog, schema, dbTableClass.getTableName());
                    ArrayList<String> pkNames = new ArrayList<String>();
                    try {
                        while (primaryKeysRS.next()) {
                            String pkColumnName = primaryKeysRS.getString("COLUMN_NAME");
                            pkNames.add(pkColumnName);
                        }
                    }
                    finally {
                        primaryKeysRS.close();
                    }
                    ResultSet foreignKeysRS = metaData.getImportedKeys(catalog, schema, dbTableClass.getTableName());
                    HashMap<String, String[]> fkNames = new HashMap<String, String[]>();
                    try {
                        while (foreignKeysRS.next()) {
                            String pkTableName = foreignKeysRS.getString("PKTABLE_NAME");
                            String pkColumnName = foreignKeysRS.getString("PKCOLUMN_NAME");
                            String fkColumnName = foreignKeysRS.getString("FKCOLUMN_NAME");
                            fkNames.put(fkColumnName, new String[]{pkTableName, pkColumnName});
                        }
                    }
                    finally {
                        foreignKeysRS.close();
                    }
                    ResultSet columns = metaData.getColumns(catalog, schema, dbTableClass.getTableName(), null);
                    try {
                        while (columns.next()) {
                            DBTableField dbTableField = new DBTableField();
                            dbTableField.columnName = columns.getString("COLUMN_NAME");
                            dbTableField.fieldName = DBTableClassGenerator.toFieldCase(dbTableField.columnName);
                            dbTableField.precision = columns.getInt("COLUMN_SIZE");
                            dbTableField.comments = columns.getString("REMARKS");
                            String isAutoIncr = null;
                            try {
                                isAutoIncr = columns.getString("IS_AUTOINCREMENT");
                            }
                            catch (SQLException sqlex) {
                                // empty catch block
                            }
                            dbTableField.isAutoIncrement = isAutoIncr != null && isAutoIncr.equals("YES");
                            try {
                                dbTableField.sqlDataTypeInt = columns.getInt("DATA_TYPE");
                                dbTableField.columnType = DBTableClassGenerator.getQueryableDatatypeNameOfSQLType(dbTableField.sqlDataTypeInt, dbTableField.precision);
                            }
                            catch (UnknownJavaSQLTypeException ex) {
                                dbTableField.columnType = DBUnknownDatatype.class;
                                dbTableField.javaSQLDatatype = ex.getUnknownJavaSQLType();
                            }
                            if (pkNames.contains(dbTableField.columnName) || pkRecog.isPrimaryKeyColumn(dbTableClass.getTableName(), dbTableField.columnName)) {
                                dbTableField.isPrimaryKey = true;
                            }
                            database.getDefinition().sanityCheckDBTableField(dbTableField);
                            String[] pkData = (String[])fkNames.get(dbTableField.columnName);
                            if (pkData != null && pkData.length == 2) {
                                dbTableField.isForeignKey = true;
                                dbTableField.referencesClass = DBTableClassGenerator.toClassCase(pkData[0]);
                                dbTableField.referencesField = pkData[1];
                            } else if (fkRecog.isForeignKeyColumn(dbTableClass.getTableName(), dbTableField.columnName)) {
                                dbTableField.isForeignKey = true;
                                dbTableField.referencesField = fkRecog.getReferencedColumn(dbTableClass.getTableName(), dbTableField.columnName);
                                dbTableField.referencesClass = DBTableClassGenerator.toClassCase(fkRecog.getReferencedTable(dbTableClass.getTableName(), dbTableField.columnName));
                            }
                            dbTableClass.getFields().add(dbTableField);
                        }
                    }
                    finally {
                        columns.close();
                    }
                    dbTableClasses.add(dbTableClass);
                }
            }
            finally {
                tables.close();
            }
            DBTableClassGenerator.generateAllJavaSource(dbTableClasses);
        }
        finally {
            dbStatement.close();
        }
        return dbTableClasses;
    }

    static void generateAllJavaSource(List<DBTableClass> dbTableClasses) {
        ArrayList<String> dbTableClassNames = new ArrayList<String>();
        for (DBTableClass dbt : dbTableClasses) {
            dbTableClassNames.add(dbt.className);
        }
        for (DBTableClass dbt : dbTableClasses) {
            for (DBTableField dbf : dbt.getFields()) {
                String properClassname;
                if (!dbf.isForeignKey || dbTableClassNames.contains(dbf.referencesClass)) continue;
                ArrayList<String> matchingNames = new ArrayList<String>();
                for (String name : dbTableClassNames) {
                    if (!name.toLowerCase().startsWith(dbf.referencesClass.toLowerCase())) continue;
                    matchingNames.add(name);
                }
                if (matchingNames.size() != 1) continue;
                dbf.referencesClass = properClassname = (String)matchingNames.get(0);
            }
            dbt.generateJavaSource();
        }
    }

    private static Class<? extends Object> getQueryableDatatypeNameOfSQLType(int columnType, int precision) throws UnknownJavaSQLTypeException {
        Class<QueryableDatatype> value = QueryableDatatype.class;
        switch (columnType) {
            case -7: {
                if (precision == 1) {
                    value = DBBoolean.class;
                    break;
                }
                value = DBByteArray.class;
                break;
            }
            case -8: 
            case -6: 
            case -5: 
            case -2: 
            case 4: 
            case 5: 
            case 16: {
                if (precision == 1) {
                    value = DBBoolean.class;
                    break;
                }
                value = DBInteger.class;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                value = DBNumber.class;
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                value = DBString.class;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                value = DBDate.class;
                break;
            }
            case 1111: 
            case 2000: {
                value = DBJavaObject.class;
                break;
            }
            case -4: 
            case -3: 
            case 2003: 
            case 2004: 
            case 2009: {
                value = DBByteArray.class;
                break;
            }
            default: {
                throw new UnknownJavaSQLTypeException("Unknown Java SQL Type: " + columnType, columnType);
            }
        }
        return value;
    }

    public static String toClassCase(String s) {
        String classCaseString = "";
        if (s.matches("[lLtT]+_[0-9]+(_[0-9]+)*")) {
            classCaseString = s.toUpperCase();
        } else {
            String[] parts;
            for (String part : parts = s.split("_")) {
                classCaseString = classCaseString + DBTableClassGenerator.toProperCase(part);
            }
        }
        return classCaseString;
    }

    private static String toFieldCase(String s) {
        String classClass = DBTableClassGenerator.toClassCase(s);
        String camelCaseString = classClass.substring(0, 1).toLowerCase() + classClass.substring(1);
        return camelCaseString;
    }

    private static String toProperCase(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        String firstChar = s.substring(0, 1);
        String rest = s.substring(1).toLowerCase();
        if (firstChar.matches("[^a-zA-Z]")) {
            return "_" + firstChar + rest;
        }
        return firstChar.toUpperCase() + rest;
    }
}

