/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.generation;

import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.annotations.DBAutoIncrement;
import nz.co.gregs.dbvolution.annotations.DBColumn;
import nz.co.gregs.dbvolution.annotations.DBForeignKey;
import nz.co.gregs.dbvolution.annotations.DBPrimaryKey;
import nz.co.gregs.dbvolution.annotations.DBTableName;
import nz.co.gregs.dbvolution.annotations.DBUnknownJavaSQLType;
import nz.co.gregs.dbvolution.datatypes.DBUnknownDatatype;
import nz.co.gregs.dbvolution.generation.DBTableField;

public class DBTableClass {
    public long serialversionUIDBValue = 1L;
    private final Class<DBUnknownDatatype> unknownDatatype = DBUnknownDatatype.class;
    private String packageName;
    public String className;
    private String tableName;
    private String javaSource;
    private final List<DBTableField> fields = new ArrayList<DBTableField>();
    private final String lineSeparator = System.getProperty("line.separator");
    private final String conceptBreak = this.lineSeparator + this.lineSeparator;

    public String getFullyQualifiedName() {
        return this.getPackageName() + "." + this.className;
    }

    public String generateJavaSource() {
        StringBuilder javaSrc = new StringBuilder();
        String outputPackageName = this.getPackageName();
        if (outputPackageName != null) {
            javaSrc.append("package ").append(outputPackageName).append(";");
            javaSrc.append(this.conceptBreak);
        }
        String importPackageName = DBRow.class.getPackage().getName();
        javaSrc.append("import ").append(importPackageName).append(".*;");
        javaSrc.append(this.lineSeparator);
        javaSrc.append("import ").append(importPackageName).append(".datatypes.*;");
        javaSrc.append(this.lineSeparator);
        javaSrc.append("import ").append(importPackageName).append(".annotations.*;");
        javaSrc.append(this.conceptBreak);
        String tableNameAnnotation = DBTableName.class.getSimpleName();
        String dbRowClassName = DBRow.class.getSimpleName();
        String dbColumnAnnotation = DBColumn.class.getSimpleName();
        String primaryKeyAnnotation = DBPrimaryKey.class.getSimpleName();
        String autoIncrementAnnotation = DBAutoIncrement.class.getSimpleName();
        String foreignKeyAnnotation = DBForeignKey.class.getSimpleName();
        String unknownJavaSQLTypeAnnotation = DBUnknownJavaSQLType.class.getSimpleName();
        javaSrc.append("@").append(tableNameAnnotation).append("(\"").append(this.getTableName()).append("\") ");
        javaSrc.append(this.lineSeparator);
        javaSrc.append("public class ").append(this.className).append(" extends ").append(dbRowClassName).append(" {");
        javaSrc.append(this.conceptBreak);
        javaSrc.append("    public static final long serialVersionUID = ").append(this.serialversionUIDBValue).append("L;");
        javaSrc.append(this.conceptBreak);
        for (DBTableField field : this.getFields()) {
            if (field.comments == null || field.comments.isEmpty()) {
                javaSrc.append("    @").append(dbColumnAnnotation).append("(\"").append(field.columnName).append("\")");
            } else {
                javaSrc.append("    @").append(dbColumnAnnotation).append("(value=\"").append(field.columnName).append("\"").append(", comments=\"").append(field.comments.replaceAll("\"", "\\\"")).append(")");
            }
            javaSrc.append(this.lineSeparator);
            if (field.isPrimaryKey) {
                javaSrc.append("    @").append(primaryKeyAnnotation).append(this.lineSeparator);
            }
            if (field.isAutoIncrement) {
                javaSrc.append("    @").append(autoIncrementAnnotation).append(this.lineSeparator);
            }
            if (field.isForeignKey) {
                javaSrc.append("    @").append(foreignKeyAnnotation).append("(").append(field.referencesClass).append(".class)");
                javaSrc.append(this.lineSeparator);
            }
            if (this.unknownDatatype.equals(field.columnType)) {
                javaSrc.append("    @").append(unknownJavaSQLTypeAnnotation).append("(").append(field.javaSQLDatatype).append(")");
                javaSrc.append(this.lineSeparator);
            }
            javaSrc.append("    public ").append(field.columnType.getSimpleName()).append(" ").append(field.fieldName).append(" = new ").append(field.columnType.getSimpleName()).append("();");
            javaSrc.append(this.conceptBreak);
        }
        javaSrc.append("}");
        javaSrc.append(this.conceptBreak);
        this.javaSource = javaSrc.toString();
        return this.getJavaSource();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public List<DBTableField> getFields() {
        return this.fields;
    }

    public String getJavaSource() {
        return this.javaSource;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

