/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.expressions.BooleanExpression;
import nz.co.gregs.dbvolution.expressions.BooleanResult;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.expressions.NumberExpression;
import nz.co.gregs.dbvolution.expressions.NumberResult;
import nz.co.gregs.dbvolution.expressions.StringResult;

public class StringExpression
implements StringResult {
    private StringResult string1;
    private boolean nullProtectionRequired;

    protected StringExpression() {
    }

    public StringExpression(StringResult stringVariable) {
        this.string1 = stringVariable;
        if (stringVariable == null || stringVariable.getIncludesNull()) {
            this.nullProtectionRequired = true;
        }
    }

    public StringExpression(String stringVariable) {
        this.string1 = new DBString(stringVariable);
        if (stringVariable == null) {
            this.nullProtectionRequired = true;
        }
    }

    public StringExpression(NumberExpression numberVariable) {
        this.string1 = numberVariable.stringResult();
        if (numberVariable == null || this.string1.getIncludesNull()) {
            this.nullProtectionRequired = true;
        }
    }

    public StringExpression(Number numberVariable) {
        this.string1 = NumberExpression.value(numberVariable).stringResult();
        if (numberVariable == null || this.string1.getIncludesNull()) {
            this.nullProtectionRequired = true;
        }
    }

    public StringExpression(DBString stringVariable) {
        this.string1 = stringVariable.copy();
        if (stringVariable == null || stringVariable.getIncludesNull()) {
            this.nullProtectionRequired = true;
        }
    }

    @Override
    public String toSQLString(DBDatabase db) {
        return this.getStringInput().toSQLString(db);
    }

    @Override
    public StringExpression copy() {
        return new StringExpression(this);
    }

    public static StringExpression value(String string) {
        return new StringExpression(string);
    }

    public StringExpression ifDBNull(String alternative) {
        return this.ifDBNull(new StringExpression(alternative));
    }

    public StringExpression ifDBNull(StringResult alternative) {
        return new StringExpression(new DBBinaryStringFunction(this, new StringExpression(alternative)){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getIfNullFunctionName();
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isLike(String sqlPattern) {
        return this.isLike(StringExpression.value(sqlPattern));
    }

    public BooleanExpression isLike(StringResult sqlPattern) {
        if (sqlPattern.getIncludesNull()) {
            return new BooleanExpression(this.isNull());
        }
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, sqlPattern){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " LIKE ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isLikeIgnoreCase(String sqlPattern) {
        return this.isLikeIgnoreCase(StringExpression.value(sqlPattern));
    }

    public BooleanExpression isLikeIgnoreCase(StringResult sqlPattern) {
        return this.isLikeIgnoreCase(new StringExpression(sqlPattern));
    }

    public BooleanExpression isLikeIgnoreCase(StringExpression sqlpattern) {
        return this.lowercase().isLike(sqlpattern.lowercase());
    }

    public BooleanExpression isIgnoreCase(String equivalentString) {
        return this.isIgnoreCase(StringExpression.value(equivalentString));
    }

    public BooleanExpression isIgnoreCase(NumberExpression numberResult) {
        return this.isIgnoreCase(numberResult.stringResult().lowercase());
    }

    public BooleanExpression isIgnoreCase(Number number) {
        return this.isIgnoreCase(NumberExpression.value(number).stringResult().lowercase());
    }

    public BooleanExpression isIgnoreCase(StringResult equivalentString) {
        return this.isIgnoreCase(new StringExpression(equivalentString));
    }

    public BooleanExpression isIgnoreCase(StringExpression equivalentString) {
        return this.lowercase().is(equivalentString.lowercase());
    }

    public BooleanExpression is(String equivalentString) {
        return this.is(StringExpression.value(equivalentString));
    }

    public BooleanExpression is(NumberExpression numberResult) {
        return this.is(numberResult.stringResult());
    }

    public BooleanExpression is(Number number) {
        return this.is(NumberExpression.value(number).stringResult());
    }

    public BooleanExpression is(StringResult equivalentString) {
        if (equivalentString.getIncludesNull()) {
            return new BooleanExpression(this.isNull());
        }
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, equivalentString){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().doStringEqualsTransform(((DBBinaryBooleanArithmetic)this).first.toSQLString(db), ((DBBinaryBooleanArithmetic)this).second.toSQLString(db));
            }

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " = ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isBetween(StringResult lowerBound, StringResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetween(String lowerBound, StringResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetween(StringResult lowerBound, String upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetween(String lowerBound, String upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(StringResult lowerBound, StringResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(String lowerBound, StringResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(StringResult lowerBound, String upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(String lowerBound, String upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenExclusive(StringResult lowerBound, StringResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isBetweenExclusive(String lowerBound, StringResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isBetweenExclusive(StringResult lowerBound, String upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isBetweenExclusive(String lowerBound, String upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isLessThan(String equivalentString) {
        return this.isLessThan(StringExpression.value(equivalentString));
    }

    public BooleanExpression isLessThan(StringResult equivalentString) {
        if (equivalentString.getIncludesNull()) {
            return new BooleanExpression(this.isNull());
        }
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, equivalentString){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " < ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isLessThanOrEqual(String equivalentString) {
        return this.isLessThanOrEqual(StringExpression.value(equivalentString));
    }

    public BooleanExpression isLessThanOrEqual(StringResult equivalentString) {
        if (equivalentString.getIncludesNull()) {
            return new BooleanExpression(this.isNull());
        }
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, equivalentString){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " <= ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isGreaterThan(String equivalentString) {
        return this.isGreaterThan(StringExpression.value(equivalentString));
    }

    public BooleanExpression isGreaterThan(StringResult equivalentString) {
        if (equivalentString.getIncludesNull()) {
            return new BooleanExpression(this.isNotNull());
        }
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, equivalentString){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " > ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isGreaterThanOrEqual(String equivalentString) {
        return this.isGreaterThanOrEqual(StringExpression.value(equivalentString));
    }

    public BooleanExpression isGreaterThanOrEqual(StringResult equivalentString) {
        if (equivalentString.getIncludesNull()) {
            return this.is(equivalentString).not();
        }
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, equivalentString){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " >= ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isIn(String ... possibleValues) {
        ArrayList<StringExpression> possVals = new ArrayList<StringExpression>();
        for (String str : possibleValues) {
            possVals.add(StringExpression.value(str));
        }
        return this.isIn(possVals.toArray(new StringExpression[0]));
    }

    public BooleanExpression isIn(Collection<String> possibleValues) {
        ArrayList<StringExpression> possVals = new ArrayList<StringExpression>();
        for (String str : possibleValues) {
            possVals.add(StringExpression.value(str));
        }
        return this.isIn(possVals.toArray(new StringExpression[0]));
    }

    public BooleanExpression isIn(StringResult ... possibleValues) {
        BooleanExpression isInExpression = new BooleanExpression(new DBNnaryBooleanFunction(this, possibleValues){

            @Override
            protected String getFunctionName(DBDatabase db) {
                return " IN ";
            }
        });
        if (isInExpression.getIncludesNull()) {
            return BooleanExpression.anyOf(new BooleanExpression(this.isNull()), isInExpression);
        }
        return isInExpression;
    }

    public StringExpression append(StringResult string2) {
        return new StringExpression(new DBBinaryStringArithmetic(this, string2){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().doConcatTransform(((DBBinaryStringArithmetic)this).first.toSQLString(db), ((DBBinaryStringArithmetic)this).second.toSQLString(db));
            }

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return db.getDefinition().getConcatOperator();
            }
        });
    }

    public StringExpression append(String string2) {
        return this.append(StringExpression.value(string2));
    }

    public StringExpression append(NumberResult number1) {
        return this.append(new NumberExpression(number1).stringResult());
    }

    public StringExpression append(Number number1) {
        return this.append(NumberExpression.value(number1));
    }

    public StringExpression replace(String findString, String replaceWith) {
        return this.replace((StringResult)new StringExpression(findString), (StringResult)new StringExpression(replaceWith));
    }

    public StringExpression replace(StringResult findString, String replaceWith) {
        return this.replace(findString, (StringResult)StringExpression.value(replaceWith));
    }

    public StringExpression replace(String findString, StringResult replaceWith) {
        return this.replace((StringResult)StringExpression.value(findString), replaceWith);
    }

    public StringExpression replace(StringResult findString, StringResult replaceWith) {
        StringResult replaceValue = replaceWith;
        if (replaceWith.getIncludesNull()) {
            replaceValue = StringExpression.value("");
        }
        return new StringExpression(new DBTrinaryStringFunction(this, findString, replaceValue){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getReplaceFunctionName();
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public StringExpression trim() {
        return new StringExpression(new DBUnaryStringFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().doTrimFunction(this.only.toSQLString(db));
            }

            @Override
            String getFunctionName(DBDatabase db) {
                return "NOT USED BECAUSE SQLSERVER DOESN'T IMPLEMENT TRIM";
            }
        });
    }

    public StringExpression leftTrim() {
        return new StringExpression(new DBUnaryStringFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                if (!db.getDefinition().supportsLeftTrimFunction()) {
                    return db.getDefinition().doLeftTrimFunction(this.only.toSQLString(db));
                }
                return super.toSQLString(db);
            }

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getLeftTrimFunctionName();
            }
        });
    }

    public StringExpression rightTrim() {
        return new StringExpression(new DBUnaryStringFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getRightTrimFunctionName();
            }
        });
    }

    public StringExpression lowercase() {
        return new StringExpression(new DBUnaryStringFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getLowercaseFunctionName();
            }
        });
    }

    public StringExpression uppercase() {
        return new StringExpression(new DBUnaryStringFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getUppercaseFunctionName();
            }
        });
    }

    public StringExpression substring(Number startingIndex0Based) {
        return new Substring((StringResult)this, startingIndex0Based);
    }

    public StringExpression substring(NumberExpression startingIndex0Based) {
        return new Substring((StringResult)this, startingIndex0Based);
    }

    public StringExpression substring(Number startingIndex0Based, Number endIndex0Based) {
        return new Substring((StringResult)this, startingIndex0Based, endIndex0Based);
    }

    public StringExpression substring(NumberExpression startingIndex0Based, Number endIndex0Based) {
        return new Substring((StringResult)this, startingIndex0Based, new NumberExpression(endIndex0Based));
    }

    public StringExpression substring(Number startingIndex0Based, NumberExpression endIndex0Based) {
        return new Substring((StringResult)this, new NumberExpression(startingIndex0Based), endIndex0Based);
    }

    public StringExpression substring(NumberExpression startingIndex0Based, NumberExpression endIndex0Based) {
        return new Substring((StringResult)this, startingIndex0Based, endIndex0Based);
    }

    public NumberExpression length() {
        return new NumberExpression(new DBUnaryNumberFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getStringLengthFunctionName();
            }
        });
    }

    public static StringExpression currentUser() {
        return new StringExpression(new DBNonaryStringFunction(){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getCurrentUserFunctionName();
            }
        });
    }

    protected StringResult getStringInput() {
        return this.string1;
    }

    public NumberExpression locationOf(String searchString) {
        return new NumberExpression(new BinaryComplicatedNumberFunction(this, StringExpression.value(searchString)){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().getPositionFunction(this.first.toSQLString(db), this.second.toSQLString(db));
            }
        });
    }

    public NumberExpression count() {
        return new NumberExpression(new DBUnaryNumberFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getCountFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    public StringExpression max() {
        return new StringExpression(new DBUnaryStringFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getMaxFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    public StringExpression min() {
        return new StringExpression(new DBUnaryStringFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getMinFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    @Override
    public DBString getQueryableDatatypeForExpressionValue() {
        return new DBString();
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        HashSet<DBRow> hashSet = new HashSet<DBRow>();
        if (this.string1 != null) {
            hashSet.addAll(this.string1.getTablesInvolved());
        }
        return hashSet;
    }

    @Override
    public boolean isAggregator() {
        return this.string1 == null ? false : this.string1.isAggregator();
    }

    public BooleanExpression isNotNull() {
        return BooleanExpression.isNotNull(this);
    }

    public BooleanExpression isNull() {
        return BooleanExpression.isNull(this);
    }

    @Override
    public boolean getIncludesNull() {
        return this.nullProtectionRequired;
    }

    private static abstract class DBBinaryStringNumberArithmetic
    implements StringResult {
        private StringResult first;
        private NumberResult second;

        DBBinaryStringNumberArithmetic(StringResult first, NumberResult second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.first.toSQLString(db) + this.getEquationOperator(db) + this.second.toSQLString(db);
        }

        @Override
        public DBBinaryStringNumberArithmetic copy() {
            DBBinaryStringNumberArithmetic newInstance;
            try {
                newInstance = (DBBinaryStringNumberArithmetic)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        protected abstract String getEquationOperator(DBDatabase var1);

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }
    }

    private static abstract class DBNnaryBooleanFunction
    implements BooleanResult {
        protected StringExpression column;
        protected List<StringResult> values = new ArrayList<StringResult>();
        private boolean includesNulls = false;

        DBNnaryBooleanFunction() {
            this.values = null;
        }

        DBNnaryBooleanFunction(StringExpression leftHandSide, StringResult[] rightHandSide) {
            this.column = leftHandSide;
            for (StringResult stringResult : rightHandSide) {
                if (stringResult.getIncludesNull()) {
                    this.includesNulls = true;
                    continue;
                }
                this.values.add(stringResult);
            }
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.column.toSQLString(db)).append(this.getFunctionName(db)).append(this.beforeValue(db));
            String separator = "";
            for (StringResult val : this.values) {
                if (val != null) {
                    builder.append(separator).append(val.toSQLString(db));
                }
                separator = ", ";
            }
            builder.append(this.afterValue(db));
            return builder.toString();
        }

        @Override
        public DBNnaryBooleanFunction copy() {
            DBNnaryBooleanFunction newInstance;
            try {
                newInstance = (DBNnaryBooleanFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.column = this.column.copy();
            Collections.copy(this.values, newInstance.values);
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.column != null) {
                hashSet.addAll(this.column.getTablesInvolved());
            }
            for (StringResult second : this.values) {
                if (second == null) continue;
                hashSet.addAll(second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            boolean result = this.column.isAggregator();
            for (StringResult numer : this.values) {
                result = result || numer.isAggregator();
            }
            return result;
        }

        @Override
        public boolean getIncludesNull() {
            return this.includesNulls;
        }
    }

    private static abstract class DBBinaryBooleanArithmetic
    implements BooleanResult {
        private StringResult first;
        private StringResult second;

        DBBinaryBooleanArithmetic(StringResult first, StringResult second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.first.toSQLString(db) + this.getEquationOperator(db) + this.second.toSQLString(db);
        }

        @Override
        public DBBinaryBooleanArithmetic copy() {
            DBBinaryBooleanArithmetic newInstance;
            try {
                newInstance = (DBBinaryBooleanArithmetic)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        protected abstract String getEquationOperator(DBDatabase var1);

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }
    }

    private class Substring
    extends StringExpression
    implements StringResult {
        private NumberResult startingPosition;
        private NumberResult length;

        Substring(StringResult stringInput, Number startingIndex0Based) {
            super(stringInput);
            this.startingPosition = new DBNumber(startingIndex0Based);
            this.length = new StringExpression(stringInput).length();
        }

        Substring(StringResult stringInput, NumberResult startingIndex0Based) {
            super(stringInput);
            this.startingPosition = startingIndex0Based.copy();
            this.length = new StringExpression(stringInput).length();
        }

        Substring(StringResult stringInput, Number startingIndex0Based, Number endIndex0Based) {
            super(stringInput);
            this.startingPosition = new DBNumber(startingIndex0Based);
            this.length = new DBNumber(endIndex0Based);
        }

        Substring(StringResult stringInput, NumberResult startingIndex0Based, NumberResult endIndex0Based) {
            super(stringInput);
            this.startingPosition = startingIndex0Based.copy();
            this.length = endIndex0Based.copy();
        }

        @Override
        public Substring copy() {
            return (StringExpression)this.new Substring(this.getStringInput(), this.startingPosition, this.length);
        }

        @Override
        public String toSQLString(DBDatabase db) {
            if (this.getStringInput() == null) {
                return "";
            }
            return this.doSubstringTransform(db, this.getStringInput(), this.startingPosition, this.length);
        }

        public String doSubstringTransform(DBDatabase db, StringResult enclosedValue, NumberResult startingPosition, NumberResult substringLength) {
            return db.getDefinition().doSubstringTransform(enclosedValue.toSQLString(db), startingPosition.toSQLString(db) + " + 1", substringLength != null ? substringLength.toSQLString(db) + " - " + startingPosition.toSQLString(db) : "");
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class BinaryComplicatedNumberFunction
    implements NumberResult {
        protected StringExpression first;
        protected StringExpression second;

        BinaryComplicatedNumberFunction() {
            this.first = null;
        }

        BinaryComplicatedNumberFunction(StringExpression first, StringExpression second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        @Override
        public abstract String toSQLString(DBDatabase var1);

        @Override
        public BinaryComplicatedNumberFunction copy() {
            BinaryComplicatedNumberFunction newInstance;
            try {
                newInstance = (BinaryComplicatedNumberFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBBinaryStringFunction
    implements StringResult {
        private StringResult first;
        private StringResult second;

        DBBinaryStringFunction(StringResult first) {
            this.first = first;
            this.second = null;
        }

        DBBinaryStringFunction(StringResult first, StringResult second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + this.first.toSQLString(db) + this.getSeparator(db) + (this.second == null ? "" : this.second.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBBinaryStringFunction copy() {
            DBBinaryStringFunction newInstance;
            try {
                newInstance = (DBBinaryStringFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first == null ? null : this.first.copy();
            newInstance.second = this.second == null ? null : this.second.copy();
            return newInstance;
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return " " + this.getFunctionName(db) + "( ";
        }

        protected String getSeparator(DBDatabase db) {
            return ", ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }
    }

    private static abstract class DBTrinaryStringFunction
    implements StringResult {
        private DBExpression first;
        private DBExpression second;
        private DBExpression third;

        DBTrinaryStringFunction(DBExpression first) {
            this.first = first;
            this.second = null;
            this.third = null;
        }

        DBTrinaryStringFunction(DBExpression first, DBExpression second) {
            this.first = first;
            this.second = second;
        }

        DBTrinaryStringFunction(DBExpression first, DBExpression second, DBExpression third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + this.first.toSQLString(db) + this.getSeparator(db) + (this.second == null ? "" : this.second.toSQLString(db)) + this.getSeparator(db) + (this.third == null ? "" : this.third.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBTrinaryStringFunction copy() {
            DBTrinaryStringFunction newInstance;
            try {
                newInstance = (DBTrinaryStringFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first == null ? null : this.first.copy();
            newInstance.second = this.second == null ? null : this.second.copy();
            newInstance.third = this.third == null ? null : this.third.copy();
            return newInstance;
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return " " + this.getFunctionName(db) + "( ";
        }

        protected String getSeparator(DBDatabase db) {
            return ", ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            if (this.third != null) {
                hashSet.addAll(this.third.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator() || this.third.isAggregator();
        }
    }

    private static abstract class DBUnaryNumberFunction
    implements NumberResult {
        protected StringExpression only;

        DBUnaryNumberFunction() {
            this.only = null;
        }

        DBUnaryNumberFunction(StringExpression only) {
            this.only = only;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "" + this.getFunctionName(db) + "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + (this.only == null ? "" : this.only.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBUnaryNumberFunction copy() {
            DBUnaryNumberFunction newInstance;
            try {
                newInstance = (DBUnaryNumberFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.only = this.only == null ? null : this.only.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.only != null) {
                hashSet.addAll(this.only.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.only.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBUnaryStringFunction
    implements StringResult {
        protected StringExpression only;

        DBUnaryStringFunction() {
            this.only = null;
        }

        DBUnaryStringFunction(StringExpression only) {
            this.only = only;
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "" + this.getFunctionName(db) + "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + (this.only == null ? "" : this.only.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBUnaryStringFunction copy() {
            DBUnaryStringFunction newInstance;
            try {
                newInstance = (DBUnaryStringFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.only = this.only.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.only != null) {
                hashSet.addAll(this.only.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.only.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBNonaryStringFunction
    implements StringResult {
        DBNonaryStringFunction() {
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return " " + this.getFunctionName(db) + "";
        }

        protected String afterValue(DBDatabase db) {
            return " ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + this.afterValue(db);
        }

        @Override
        public DBNonaryStringFunction copy() {
            DBNonaryStringFunction newInstance;
            try {
                newInstance = (DBNonaryStringFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return false;
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBBinaryStringArithmetic
    implements StringResult {
        private StringResult first;
        private StringResult second;
        private boolean includeNulls;

        DBBinaryStringArithmetic(StringResult first, StringResult second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.first.toSQLString(db) + this.getEquationOperator(db) + this.second.toSQLString(db);
        }

        @Override
        public DBBinaryStringArithmetic copy() {
            DBBinaryStringArithmetic newInstance;
            try {
                newInstance = (DBBinaryStringArithmetic)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        protected abstract String getEquationOperator(DBDatabase var1);

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return this.includeNulls;
        }
    }
}

