/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.expressions.BooleanExpression;
import nz.co.gregs.dbvolution.expressions.BooleanResult;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.expressions.NumberResult;
import nz.co.gregs.dbvolution.expressions.StringExpression;
import nz.co.gregs.dbvolution.expressions.StringResult;

public class NumberExpression
implements NumberResult {
    private NumberResult innerNumberResult;
    private boolean nullProtectionRequired;

    protected NumberExpression() {
    }

    public NumberExpression(Number value) {
        this.innerNumberResult = new DBNumber(value);
        if (value == null || this.innerNumberResult.getIncludesNull()) {
            this.nullProtectionRequired = true;
        }
    }

    public NumberExpression(NumberResult value) {
        this.innerNumberResult = value;
        if (value == null || this.innerNumberResult.getIncludesNull()) {
            this.nullProtectionRequired = true;
        }
    }

    @Override
    public String toSQLString(DBDatabase db) {
        return this.getInputNumber().toSQLString(db);
    }

    protected NumberResult getInputNumber() {
        return this.getInnerNumberResult();
    }

    @Override
    public NumberExpression copy() {
        return new NumberExpression(this.getInputNumber());
    }

    public static NumberExpression value(Number object) {
        return new NumberExpression(object);
    }

    public StringExpression stringResult() {
        return new StringExpression(new DBBinaryStringNumberFunction(StringExpression.value(""), this){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().doConcatTransform(((DBBinaryStringNumberFunction)this).first.toSQLString(db), ((DBBinaryStringNumberFunction)this).second.toSQLString(db));
            }
        });
    }

    public StringExpression append(String string) {
        return this.stringResult().append(string);
    }

    public StringExpression append(StringResult string) {
        return this.stringResult().append(string);
    }

    public BooleanExpression is(Number number) {
        return this.is(NumberExpression.value(number));
    }

    public BooleanExpression is(NumberResult numberExpression) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, numberExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " = ";
            }
        });
    }

    public BooleanExpression isNotNull() {
        return BooleanExpression.isNotNull(this);
    }

    public BooleanExpression isNull() {
        return BooleanExpression.isNull(this);
    }

    public BooleanExpression isNot(Number number) {
        return this.is(NumberExpression.value(number)).not();
    }

    public BooleanExpression isNot(NumberResult number) {
        return this.is(number).not();
    }

    public BooleanExpression isBetween(NumberResult lowerBound, NumberResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetween(Number lowerBound, NumberResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetween(NumberResult lowerBound, Number upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetween(Number lowerBound, Number upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(NumberResult lowerBound, NumberResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(Number lowerBound, NumberResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(NumberResult lowerBound, Number upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(Number lowerBound, Number upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenExclusive(NumberResult lowerBound, NumberResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isBetweenExclusive(Number lowerBound, NumberResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isBetweenExclusive(NumberResult lowerBound, Number upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isBetweenExclusive(Number lowerBound, Number upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isLessThan(Number number) {
        return this.isLessThan(NumberExpression.value(number));
    }

    public BooleanExpression isLessThan(NumberResult numberExpression) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, numberExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " < ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isLessThanOrEqual(Number number) {
        return this.isLessThanOrEqual(NumberExpression.value(number));
    }

    public BooleanExpression isLessThanOrEqual(NumberResult numberExpression) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, numberExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " <= ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isGreaterThan(Number number) {
        return this.isGreaterThan(NumberExpression.value(number));
    }

    public BooleanExpression isGreaterThan(NumberResult number) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, number){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " > ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isGreaterThanOrEqual(Number number) {
        return this.isGreaterThanOrEqual(NumberExpression.value(number));
    }

    public BooleanExpression isGreaterThanOrEqual(NumberResult number) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, number){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " >= ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isIn(Number ... possibleValues) {
        ArrayList<NumberExpression> possVals = new ArrayList<NumberExpression>();
        for (Number num : possibleValues) {
            possVals.add(NumberExpression.value(num));
        }
        return this.isIn(possVals.toArray(new NumberExpression[0]));
    }

    public BooleanExpression isIn(Collection<? extends Number> possibleValues) {
        ArrayList<NumberExpression> possVals = new ArrayList<NumberExpression>();
        for (Number number : possibleValues) {
            possVals.add(NumberExpression.value(number));
        }
        return this.isIn(possVals.toArray(new NumberExpression[0]));
    }

    public BooleanExpression isIn(NumberResult ... possibleValues) {
        BooleanExpression isinExpr = new BooleanExpression(new DBNnaryBooleanFunction(this, possibleValues){

            @Override
            protected String getFunctionName(DBDatabase db) {
                return " IN ";
            }
        });
        if (isinExpr.getIncludesNull()) {
            return BooleanExpression.anyOf(BooleanExpression.isNull(this), isinExpr);
        }
        return isinExpr;
    }

    public static NumberExpression leastOf(Number ... possibleValues) {
        ArrayList<NumberExpression> possVals = new ArrayList<NumberExpression>();
        for (Number num : possibleValues) {
            possVals.add(NumberExpression.value(num));
        }
        return NumberExpression.leastOf(possVals.toArray(new NumberExpression[0]));
    }

    public static NumberExpression leastOf(Collection<? extends Number> possibleValues) {
        ArrayList<NumberExpression> possVals = new ArrayList<NumberExpression>();
        for (Number number : possibleValues) {
            possVals.add(NumberExpression.value(number));
        }
        return NumberExpression.leastOf(possVals.toArray(new NumberExpression[0]));
    }

    public static NumberExpression leastOf(NumberResult ... possibleValues) {
        NumberExpression leastExpr = new NumberExpression(new DBNnaryNumberFunction(possibleValues){

            @Override
            protected String getFunctionName(DBDatabase db) {
                return db.getDefinition().getLeastOfFunctionName();
            }
        });
        return leastExpr;
    }

    public static NumberExpression greatestOf(Number ... possibleValues) {
        ArrayList<NumberExpression> possVals = new ArrayList<NumberExpression>();
        for (Number num : possibleValues) {
            possVals.add(NumberExpression.value(num));
        }
        return NumberExpression.greatestOf(possVals.toArray(new NumberExpression[0]));
    }

    public static NumberExpression greatestOf(Collection<? extends Number> possibleValues) {
        ArrayList<NumberExpression> possVals = new ArrayList<NumberExpression>();
        for (Number number : possibleValues) {
            possVals.add(NumberExpression.value(number));
        }
        return NumberExpression.greatestOf(possVals.toArray(new NumberExpression[0]));
    }

    public static NumberExpression greatestOf(NumberResult ... possibleValues) {
        NumberExpression greatestExpr = new NumberExpression(new DBNnaryNumberFunction(possibleValues){

            @Override
            protected String getFunctionName(DBDatabase db) {
                return db.getDefinition().getGreatestOfFunctionName();
            }
        });
        return greatestExpr;
    }

    public static NumberExpression getNextSequenceValue(String sequenceName) {
        return NumberExpression.getNextSequenceValue(null, sequenceName);
    }

    public static NumberExpression getNextSequenceValue(String schemaName, String sequenceName) {
        if (schemaName != null) {
            return new NumberExpression(new DBBinaryFunction(StringExpression.value(schemaName), StringExpression.value(sequenceName)){

                @Override
                String getFunctionName(DBDatabase db) {
                    return db.getDefinition().getNextSequenceValueFunctionName();
                }
            });
        }
        return new NumberExpression(new DBUnaryFunction(StringExpression.value(sequenceName)){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getNextSequenceValueFunctionName();
            }
        });
    }

    public NumberExpression ifDBNull(Number alternative) {
        return new NumberExpression(new DBBinaryFunction(this, new NumberExpression(alternative)){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getIfNullFunctionName();
            }
        });
    }

    public NumberExpression ifDBNull(NumberResult alternative) {
        return new NumberExpression(new DBBinaryFunction(this, alternative){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getIfNullFunctionName();
            }
        });
    }

    public NumberExpression bracket() {
        return new NumberExpression(new BracketUnaryFunction((DBExpression)this));
    }

    public NumberExpression exp() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                if (!db.getDefinition().supportsExpFunction() && this.only instanceof NumberExpression) {
                    return new NumberExpression(2.718281828).power((NumberExpression)this.only).toSQLString(db);
                }
                return super.toSQLString(db);
            }

            @Override
            String getFunctionName(DBDatabase db) {
                return "exp";
            }
        });
    }

    public NumberExpression cos() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "cos";
            }
        });
    }

    public NumberExpression cosh() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "cosh";
            }
        });
    }

    public NumberExpression sin() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "sin";
            }
        });
    }

    public NumberExpression sinh() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "sinh";
            }
        });
    }

    public NumberExpression tan() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "tan";
            }
        });
    }

    public NumberExpression tanh() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "tanh";
            }
        });
    }

    public NumberExpression abs() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "abs";
            }
        });
    }

    public NumberExpression arccos() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "acos";
            }
        });
    }

    public NumberExpression arcsin() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "asin";
            }
        });
    }

    public NumberExpression arctan() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "atan";
            }
        });
    }

    public NumberExpression arctan2(NumberExpression n) {
        return new NumberExpression(new DBBinaryFunction(this, n){

            @Override
            String getFunctionName(DBDatabase db) {
                return "atn2";
            }
        });
    }

    public NumberExpression cotangent() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "cot";
            }
        });
    }

    public NumberExpression degrees() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                if (db.getDefinition().supportsDegreesFunction()) {
                    return super.toSQLString(db);
                }
                return db.getDefinition().doDegreesTransform(this.only.toSQLString(db));
            }

            @Override
            String getFunctionName(DBDatabase db) {
                return "degrees";
            }
        });
    }

    public NumberExpression radians() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                if (db.getDefinition().supportsRadiansFunction()) {
                    return super.toSQLString(db);
                }
                return db.getDefinition().doRadiansTransform(this.only.toSQLString(db));
            }

            @Override
            String getFunctionName(DBDatabase db) {
                return "radians";
            }
        });
    }

    public NumberExpression log() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "log";
            }
        });
    }

    public NumberExpression logBase10() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "log10";
            }
        });
    }

    public NumberExpression power(NumberExpression n) {
        return new NumberExpression(new DBBinaryFunction(this, n){

            @Override
            String getFunctionName(DBDatabase db) {
                return "power";
            }
        });
    }

    public NumberExpression random() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "rand";
            }
        });
    }

    public NumberExpression sign() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "sign";
            }
        });
    }

    public NumberExpression squareRoot() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "sqrt";
            }
        });
    }

    public NumberExpression roundUp() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "ceil";
            }
        });
    }

    public NumberExpression round() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "round";
            }
        });
    }

    public NumberExpression roundDown() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return "floor";
            }
        });
    }

    public NumberExpression trunc() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().doTruncTransform(this.only.toSQLString(db), "0");
            }

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getTruncFunctionName();
            }

            @Override
            protected String afterValue(DBDatabase db) {
                return ", 0) ";
            }
        });
    }

    public NumberExpression minus(NumberExpression equation) {
        return new NumberExpression(new MinusBinaryArithmetic(this, equation));
    }

    public NumberExpression minus(Number num) {
        NumberExpression minusThisExpression = new NumberExpression(num);
        MinusBinaryArithmetic minusExpression = new MinusBinaryArithmetic(this, minusThisExpression);
        return new NumberExpression(minusExpression);
    }

    public NumberExpression plus(NumberResult number) {
        return new NumberExpression(new DBBinaryArithmetic(this, new NumberExpression(number)){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " + ";
            }
        });
    }

    public NumberExpression plus(Number num) {
        return new NumberExpression(new DBBinaryArithmetic(this, new NumberExpression(num)){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " + ";
            }
        });
    }

    public NumberExpression times(NumberResult number) {
        return new NumberExpression(new DBBinaryArithmetic(this, new NumberExpression(number)){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " * ";
            }
        });
    }

    public NumberExpression times(Number num) {
        return new NumberExpression(new DBBinaryArithmetic(this, new NumberExpression(num)){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " * ";
            }
        });
    }

    public NumberExpression dividedBy(NumberResult number) {
        return new NumberExpression(new DBBinaryArithmetic(this, new NumberExpression(number)){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " / ";
            }
        });
    }

    public NumberExpression dividedBy(Number num) {
        return new NumberExpression(new DivisionBinaryArithmetic(this, new NumberExpression(num)));
    }

    public NumberExpression mod(NumberResult number) {
        return new NumberExpression(new DBBinaryArithmetic(this, new NumberExpression(number)){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " % ";
            }
        });
    }

    public NumberExpression mod(Number num) {
        return new NumberExpression(new DBBinaryArithmetic(this, new DBNumber(num)){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return "%";
            }
        });
    }

    public NumberExpression average() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getAverageFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    public NumberExpression stddev() {
        return this.standardDeviation();
    }

    public NumberExpression standardDeviation() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                if (db.getDefinition().supportsStandardDeviationFunction()) {
                    return super.toSQLString(db);
                }
                if (this.only instanceof NumberExpression) {
                    NumberExpression numb = (NumberExpression)this.only;
                    return new NumberExpression(numb).max().minus(new NumberExpression(numb).min()).bracket().dividedBy(6).toSQLString(db);
                }
                return null;
            }

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getStandardDeviationFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    public NumberExpression count() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getCountFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    public NumberExpression max() {
        return new NumberExpression(new MaxUnaryFunction((DBExpression)this));
    }

    public NumberExpression min() {
        return new NumberExpression(new MinUnaryFunction((DBExpression)this));
    }

    public NumberExpression sum() {
        return new NumberExpression(new DBUnaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getSumFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    public static NumberExpression countAll() {
        return new NumberExpression(new DBNonaryFunction(){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getCountFunctionName();
            }

            @Override
            protected String afterValue(DBDatabase db) {
                return "(*)";
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    @Override
    public DBNumber getQueryableDatatypeForExpressionValue() {
        return new DBNumber();
    }

    @Override
    public boolean isAggregator() {
        return this.getInnerNumberResult() == null ? false : this.getInnerNumberResult().isAggregator();
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        HashSet<DBRow> hashSet = new HashSet<DBRow>();
        if (this.getInnerNumberResult() != null) {
            hashSet.addAll(this.getInnerNumberResult().getTablesInvolved());
        }
        return hashSet;
    }

    public NumberResult getInnerNumberResult() {
        return this.innerNumberResult;
    }

    public void setInnerNumberResult(NumberResult innerNumberResult) {
        this.innerNumberResult = innerNumberResult;
    }

    @Override
    public boolean getIncludesNull() {
        return this.nullProtectionRequired;
    }

    private static class DivisionBinaryArithmetic
    extends DBBinaryArithmetic {
        DivisionBinaryArithmetic(NumberResult first, NumberResult second) {
            super(first, second);
        }

        @Override
        protected String getEquationOperator(DBDatabase db) {
            return " / ";
        }
    }

    private static class BracketUnaryFunction
    extends DBUnaryFunction {
        BracketUnaryFunction(DBExpression only) {
            super(only);
        }

        @Override
        String getFunctionName(DBDatabase db) {
            return "";
        }
    }

    private static class MinusBinaryArithmetic
    extends DBBinaryArithmetic {
        MinusBinaryArithmetic(NumberResult first, NumberResult second) {
            super(first, second);
        }

        @Override
        protected String getEquationOperator(DBDatabase db) {
            return " - ";
        }
    }

    private static class MinUnaryFunction
    extends DBUnaryFunction {
        MinUnaryFunction(DBExpression only) {
            super(only);
        }

        @Override
        String getFunctionName(DBDatabase db) {
            return db.getDefinition().getMinFunctionName();
        }

        @Override
        public boolean isAggregator() {
            return true;
        }
    }

    private static class MaxUnaryFunction
    extends DBUnaryFunction {
        public MaxUnaryFunction(DBExpression only) {
            super(only);
        }

        @Override
        String getFunctionName(DBDatabase db) {
            return db.getDefinition().getMaxFunctionName();
        }

        @Override
        public boolean isAggregator() {
            return true;
        }
    }

    private static abstract class DBUnaryStringFunction
    implements StringResult {
        protected DBExpression only;

        DBUnaryStringFunction() {
            this.only = null;
        }

        DBUnaryStringFunction(DBExpression only) {
            this.only = only;
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "" + this.getFunctionName(db) + "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + (this.only == null ? "" : this.only.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBUnaryStringFunction copy() {
            DBUnaryStringFunction newInstance;
            try {
                newInstance = (DBUnaryStringFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.only = this.only.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.only != null) {
                hashSet.addAll(this.only.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.only.isAggregator();
        }
    }

    private static abstract class DBNnaryNumberFunction
    implements NumberResult {
        protected NumberExpression column;
        protected final List<NumberResult> values = new ArrayList<NumberResult>();
        boolean nullProtectionRequired = false;

        DBNnaryNumberFunction() {
        }

        DBNnaryNumberFunction(NumberResult[] rightHandSide) {
            for (NumberResult numberResult : rightHandSide) {
                if (numberResult == null) {
                    this.nullProtectionRequired = true;
                    continue;
                }
                if (numberResult.getIncludesNull()) {
                    this.nullProtectionRequired = true;
                }
                this.values.add(numberResult);
            }
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getFunctionName(db)).append(this.beforeValue(db));
            String separator = "";
            for (NumberResult val : this.values) {
                if (val != null) {
                    builder.append(separator).append(val.toSQLString(db));
                }
                separator = ", ";
            }
            builder.append(this.afterValue(db));
            return builder.toString();
        }

        @Override
        public DBNnaryNumberFunction copy() {
            DBNnaryNumberFunction newInstance;
            try {
                newInstance = (DBNnaryNumberFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.column = this.column.copy();
            Collections.copy(this.values, newInstance.values);
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.column != null) {
                hashSet.addAll(this.column.getTablesInvolved());
            }
            for (NumberResult second : this.values) {
                if (second == null) continue;
                hashSet.addAll(second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            boolean result = this.column.isAggregator();
            for (NumberResult numer : this.values) {
                result = result || numer.isAggregator();
            }
            return result;
        }

        @Override
        public boolean getIncludesNull() {
            return this.nullProtectionRequired;
        }
    }

    private static abstract class DBNnaryBooleanFunction
    implements BooleanResult {
        protected NumberExpression column;
        protected final List<NumberResult> values = new ArrayList<NumberResult>();
        boolean nullProtectionRequired = false;

        DBNnaryBooleanFunction() {
        }

        DBNnaryBooleanFunction(NumberExpression leftHandSide, NumberResult[] rightHandSide) {
            this.column = leftHandSide;
            for (NumberResult numberResult : rightHandSide) {
                if (numberResult == null) {
                    this.nullProtectionRequired = true;
                    continue;
                }
                if (numberResult.getIncludesNull()) {
                    this.nullProtectionRequired = true;
                }
                this.values.add(numberResult);
            }
        }

        @Override
        public DBBoolean getQueryableDatatypeForExpressionValue() {
            return new DBBoolean();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.column.toSQLString(db)).append(this.getFunctionName(db)).append(this.beforeValue(db));
            String separator = "";
            for (NumberResult val : this.values) {
                if (val != null) {
                    builder.append(separator).append(val.toSQLString(db));
                }
                separator = ", ";
            }
            builder.append(this.afterValue(db));
            return builder.toString();
        }

        @Override
        public DBNnaryBooleanFunction copy() {
            DBNnaryBooleanFunction newInstance;
            try {
                newInstance = (DBNnaryBooleanFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.column = this.column.copy();
            Collections.copy(this.values, newInstance.values);
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.column != null) {
                hashSet.addAll(this.column.getTablesInvolved());
            }
            for (NumberResult second : this.values) {
                if (second == null) continue;
                hashSet.addAll(second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            boolean result = this.column.isAggregator();
            for (NumberResult numer : this.values) {
                result = result || numer.isAggregator();
            }
            return result;
        }

        @Override
        public boolean getIncludesNull() {
            return this.nullProtectionRequired;
        }
    }

    private static abstract class DBBinaryBooleanArithmetic
    implements BooleanResult {
        private NumberExpression first;
        private NumberResult second;
        private boolean requiresNullProtection;

        DBBinaryBooleanArithmetic(NumberExpression first, NumberResult second) {
            this.first = first;
            this.second = second;
            if (this.second == null || this.second.getIncludesNull()) {
                this.requiresNullProtection = true;
            }
        }

        @Override
        public DBBoolean getQueryableDatatypeForExpressionValue() {
            return new DBBoolean();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            if (this.getIncludesNull()) {
                return BooleanExpression.isNull(this.first).toSQLString(db);
            }
            return this.first.toSQLString(db) + this.getEquationOperator(db) + this.second.toSQLString(db);
        }

        @Override
        public DBBinaryBooleanArithmetic copy() {
            DBBinaryBooleanArithmetic newInstance;
            try {
                newInstance = (DBBinaryBooleanArithmetic)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        protected abstract String getEquationOperator(DBDatabase var1);

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return this.requiresNullProtection;
        }
    }

    private static abstract class DBTrinaryFunction
    implements NumberResult {
        private DBExpression first;
        private DBExpression second;
        private DBExpression third;

        DBTrinaryFunction(DBExpression first) {
            this.first = first;
            this.second = null;
            this.third = null;
        }

        DBTrinaryFunction(DBExpression first, DBExpression second) {
            this.first = first;
            this.second = second;
        }

        DBTrinaryFunction(DBExpression first, DBExpression second, DBExpression third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + this.first.toSQLString(db) + this.getSeparator(db) + (this.second == null ? "" : this.second.toSQLString(db)) + this.getSeparator(db) + (this.third == null ? "" : this.third.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBTrinaryFunction copy() {
            DBTrinaryFunction newInstance;
            try {
                newInstance = (DBTrinaryFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first == null ? null : this.first.copy();
            newInstance.second = this.second == null ? null : this.second.copy();
            return newInstance;
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return " " + this.getFunctionName(db) + "( ";
        }

        protected String getSeparator(DBDatabase db) {
            return ", ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator() || this.third.isAggregator();
        }
    }

    private static abstract class DBBinaryStringNumberFunction
    implements StringResult {
        private DBExpression first;
        private DBExpression second;

        DBBinaryStringNumberFunction(StringResult first, NumberResult second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        @Override
        public abstract String toSQLString(DBDatabase var1);

        @Override
        public DBBinaryStringNumberFunction copy() {
            DBBinaryStringNumberFunction newInstance;
            try {
                newInstance = (DBBinaryStringNumberFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBBinaryFunction
    implements NumberResult {
        private DBExpression first;
        private DBExpression second;

        DBBinaryFunction(NumberExpression first) {
            this.first = first;
            this.second = null;
        }

        DBBinaryFunction(DBExpression first, DBExpression second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + this.first.toSQLString(db) + this.getSeparator(db) + (this.second == null ? "" : this.second.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBBinaryFunction copy() {
            DBBinaryFunction newInstance;
            try {
                newInstance = (DBBinaryFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return " " + this.getFunctionName(db) + "( ";
        }

        protected String getSeparator(DBDatabase db) {
            return ", ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBUnaryFunction
    implements NumberResult {
        protected DBExpression only;

        DBUnaryFunction() {
            this.only = null;
        }

        DBUnaryFunction(NumberExpression only) {
            this.only = only;
        }

        DBUnaryFunction(DBExpression only) {
            this.only = only;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "" + this.getFunctionName(db) + "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + (this.only == null ? "" : this.only.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBUnaryFunction copy() {
            DBUnaryFunction newInstance;
            try {
                newInstance = (DBUnaryFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.only = this.only.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.only != null) {
                hashSet.addAll(this.only.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.only.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBNonaryFunction
    implements NumberResult {
        DBNonaryFunction() {
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return " " + this.getFunctionName(db) + "";
        }

        protected String afterValue(DBDatabase db) {
            return " ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + this.afterValue(db);
        }

        @Override
        public DBNonaryFunction copy() {
            DBNonaryFunction newInstance;
            try {
                newInstance = (DBNonaryFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            return newInstance;
        }

        @Override
        public QueryableDatatype getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        @Override
        public boolean isAggregator() {
            return false;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            return new HashSet<DBRow>();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBBinaryArithmetic
    implements NumberResult {
        public NumberResult first;
        public NumberResult second;

        DBBinaryArithmetic() {
            this.first = null;
            this.second = null;
        }

        DBBinaryArithmetic(NumberResult first, NumberResult second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.first.toSQLString(db) + this.getEquationOperator(db) + this.second.toSQLString(db);
        }

        @Override
        public DBBinaryArithmetic copy() {
            DBBinaryArithmetic newInstance;
            try {
                newInstance = (DBBinaryArithmetic)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        protected abstract String getEquationOperator(DBDatabase var1);

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }
}

