/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.expressions.BooleanExpression;
import nz.co.gregs.dbvolution.expressions.BooleanResult;
import nz.co.gregs.dbvolution.expressions.DateResult;
import nz.co.gregs.dbvolution.expressions.NumberExpression;
import nz.co.gregs.dbvolution.expressions.NumberResult;

public class DateExpression
implements DateResult {
    private DateResult date1;
    private boolean needsNullProtection = false;

    protected DateExpression() {
    }

    public DateExpression(DateResult dateVariable) {
        this.date1 = dateVariable;
        if (this.date1 == null || this.date1.getIncludesNull()) {
            this.needsNullProtection = true;
        }
    }

    public DateExpression(Date date) {
        this.date1 = new DBDate(date);
        if (date == null || this.date1.getIncludesNull()) {
            this.needsNullProtection = true;
        }
    }

    @Override
    public String toSQLString(DBDatabase db) {
        return this.date1.toSQLString(db);
    }

    @Override
    public DateExpression copy() {
        return new DateExpression(this.date1);
    }

    public static DateExpression value(Date date) {
        return new DateExpression(date);
    }

    public static DateExpression currentDate() {
        return new DateExpression(new DBNonaryFunction(){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getCurrentDateFunctionName();
            }
        });
    }

    public static DateExpression currentDateTime() {
        return new DateExpression(new DBNonaryFunction(){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getCurrentTimestampFunction();
            }
        });
    }

    public static DateExpression currentTime() {
        return new DateExpression(new DBNonaryFunction(){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getCurrentTimeFunction();
            }
        });
    }

    public NumberExpression year() {
        return new NumberExpression(new UnaryComplicatedNumberFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().getYearFunction(this.only.toSQLString(db));
            }
        });
    }

    public NumberExpression month() {
        return new NumberExpression(new UnaryComplicatedNumberFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().getMonthFunction(this.only.toSQLString(db));
            }
        });
    }

    public NumberExpression day() {
        return new NumberExpression(new UnaryComplicatedNumberFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().getDayFunction(this.only.toSQLString(db));
            }
        });
    }

    public NumberExpression hour() {
        return new NumberExpression(new UnaryComplicatedNumberFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().getHourFunction(this.only.toSQLString(db));
            }
        });
    }

    public NumberExpression minute() {
        return new NumberExpression(new UnaryComplicatedNumberFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().getMinuteFunction(this.only.toSQLString(db));
            }
        });
    }

    public NumberExpression second() {
        return new NumberExpression(new UnaryComplicatedNumberFunction(this){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().getSecondFunction(this.only.toSQLString(db));
            }
        });
    }

    public BooleanExpression is(Date date) {
        return this.is(DateExpression.value(date));
    }

    public BooleanExpression is(DateResult dateExpression) {
        BooleanExpression isExpr = new BooleanExpression(new DBBinaryBooleanArithmetic(this, dateExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " = ";
            }
        });
        if (isExpr.getIncludesNull()) {
            return BooleanExpression.isNull(this);
        }
        return isExpr;
    }

    public BooleanExpression isNotNull() {
        return BooleanExpression.isNotNull(this);
    }

    public BooleanExpression isNull() {
        return BooleanExpression.isNull(this);
    }

    public BooleanExpression isBetween(DateResult lowerBound, DateResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetween(Date lowerBound, DateResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetween(DateResult lowerBound, Date upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetween(Date lowerBound, Date upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(DateResult lowerBound, DateResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(Date lowerBound, DateResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(DateResult lowerBound, Date upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenInclusive(Date lowerBound, Date upperBound) {
        return BooleanExpression.allOf(this.isGreaterThanOrEqual(lowerBound), this.isLessThanOrEqual(upperBound));
    }

    public BooleanExpression isBetweenExclusive(DateResult lowerBound, DateResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isBetweenExclusive(Date lowerBound, DateResult upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isBetweenExclusive(DateResult lowerBound, Date upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isBetweenExclusive(Date lowerBound, Date upperBound) {
        return BooleanExpression.allOf(this.isGreaterThan(lowerBound), this.isLessThan(upperBound));
    }

    public BooleanExpression isLessThan(Date date) {
        return this.isLessThan(DateExpression.value(date));
    }

    public BooleanExpression isLessThan(DateResult dateExpression) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, dateExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " < ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isLessThanOrEqual(Date date) {
        return this.isLessThanOrEqual(DateExpression.value(date));
    }

    public BooleanExpression isLessThanOrEqual(DateResult dateExpression) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, dateExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " <= ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isGreaterThan(Date date) {
        return this.isGreaterThan(DateExpression.value(date));
    }

    public BooleanExpression isGreaterThan(DateResult dateExpression) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, dateExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " > ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isGreaterThanOrEqual(Date date) {
        return this.isGreaterThanOrEqual(DateExpression.value(date));
    }

    public BooleanExpression isGreaterThanOrEqual(DateResult dateExpression) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, dateExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " >= ";
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public BooleanExpression isIn(Date ... possibleValues) {
        ArrayList<DateExpression> possVals = new ArrayList<DateExpression>();
        for (Date num : possibleValues) {
            possVals.add(DateExpression.value(num));
        }
        return this.isIn(possVals.toArray(new DateExpression[0]));
    }

    public BooleanExpression isIn(Collection<? extends Date> possibleValues) {
        ArrayList<DateExpression> possVals = new ArrayList<DateExpression>();
        for (Date date : possibleValues) {
            possVals.add(DateExpression.value(date));
        }
        return this.isIn(possVals.toArray(new DateExpression[0]));
    }

    public BooleanExpression isIn(DateResult ... possibleValues) {
        BooleanExpression isInExpr = new BooleanExpression(new DBNnaryBooleanFunction(this, possibleValues){

            @Override
            protected String getFunctionName(DBDatabase db) {
                return " IN ";
            }
        });
        if (isInExpr.getIncludesNull()) {
            return BooleanExpression.anyOf(BooleanExpression.isNull(this), isInExpr);
        }
        return isInExpr;
    }

    public DateExpression ifDBNull(Date alternative) {
        return new DateExpression(new DBBinaryFunction(this, new DateExpression(alternative)){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getIfNullFunctionName();
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public DateExpression ifDBNull(DateResult alternative) {
        return new DateExpression(new DBBinaryFunction(this, alternative){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getIfNullFunctionName();
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public NumberExpression count() {
        return new NumberExpression(new DBUnaryNumberFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getCountFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    public DateExpression max() {
        return new DateExpression(new DBUnaryDateFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getMaxFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public DateExpression min() {
        return new DateExpression(new DBUnaryDateFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getMinFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    @Override
    public DBDate getQueryableDatatypeForExpressionValue() {
        return new DBDate();
    }

    @Override
    public boolean isAggregator() {
        return this.date1 == null ? false : this.date1.isAggregator();
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return this.date1 == null ? new HashSet() : this.date1.getTablesInvolved();
    }

    @Override
    public boolean getIncludesNull() {
        return this.needsNullProtection;
    }

    private static abstract class DBUnaryDateFunction
    implements DateResult {
        protected DateExpression only;

        DBUnaryDateFunction() {
            this.only = null;
        }

        DBUnaryDateFunction(DateExpression only) {
            this.only = only;
        }

        @Override
        public DBString getQueryableDatatypeForExpressionValue() {
            return new DBString();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "" + this.getFunctionName(db) + "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + (this.only == null ? "" : this.only.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBUnaryDateFunction copy() {
            DBUnaryDateFunction newInstance;
            try {
                newInstance = (DBUnaryDateFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.only = this.only.copy();
            return newInstance;
        }

        @Override
        public boolean isAggregator() {
            return this.only.isAggregator();
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            return this.only.getTablesInvolved();
        }
    }

    private static abstract class DBUnaryNumberFunction
    implements NumberResult {
        protected DateExpression only;

        DBUnaryNumberFunction() {
            this.only = null;
        }

        DBUnaryNumberFunction(DateExpression only) {
            this.only = only;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "" + this.getFunctionName(db) + "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + (this.only == null ? "" : this.only.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBUnaryNumberFunction copy() {
            DBUnaryNumberFunction newInstance;
            try {
                newInstance = (DBUnaryNumberFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.only = this.only == null ? null : this.only.copy();
            return newInstance;
        }

        @Override
        public boolean isAggregator() {
            return this.only.isAggregator();
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            return this.only.getTablesInvolved();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBBinaryFunction
    implements DateResult {
        private DateExpression first;
        private DateResult second;

        DBBinaryFunction(DateExpression first) {
            this.first = first;
            this.second = null;
        }

        DBBinaryFunction(DateExpression first, DateResult second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + this.first.toSQLString(db) + this.getSeparator(db) + (this.second == null ? "" : this.second.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBBinaryFunction copy() {
            DBBinaryFunction newInstance;
            try {
                newInstance = (DBBinaryFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return " " + this.getFunctionName(db) + "( ";
        }

        protected String getSeparator(DBDatabase db) {
            return ", ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }
    }

    private static abstract class DBNnaryBooleanFunction
    implements BooleanResult {
        protected DateExpression column;
        protected List<DateResult> values = new ArrayList<DateResult>();
        boolean nullProtectionRequired = false;

        DBNnaryBooleanFunction() {
        }

        DBNnaryBooleanFunction(DateExpression leftHandSide, DateResult[] rightHandSide) {
            this.column = leftHandSide;
            for (DateResult dateResult : rightHandSide) {
                if (dateResult == null) {
                    this.nullProtectionRequired = true;
                    continue;
                }
                if (dateResult.getIncludesNull()) {
                    this.nullProtectionRequired = true;
                    continue;
                }
                this.values.add(dateResult);
            }
        }

        @Override
        public DBBoolean getQueryableDatatypeForExpressionValue() {
            return new DBBoolean();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.column.toSQLString(db)).append(this.getFunctionName(db)).append(this.beforeValue(db));
            String separator = "";
            for (DateResult val : this.values) {
                if (val != null) {
                    builder.append(separator).append(val.toSQLString(db));
                }
                separator = ", ";
            }
            builder.append(this.afterValue(db));
            return builder.toString();
        }

        @Override
        public DBNnaryBooleanFunction copy() {
            DBNnaryBooleanFunction newInstance;
            try {
                newInstance = (DBNnaryBooleanFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.column = this.column.copy();
            Collections.copy(this.values, newInstance.values);
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.column != null) {
                hashSet.addAll(this.column.getTablesInvolved());
            }
            for (DateResult val : this.values) {
                if (val == null) continue;
                hashSet.addAll(val.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            boolean result = this.column.isAggregator();
            for (DateResult dater : this.values) {
                result = result || dater.isAggregator();
            }
            return result;
        }

        @Override
        public boolean getIncludesNull() {
            return this.nullProtectionRequired;
        }
    }

    private static abstract class DBNnaryDateFunction
    implements DateResult {
        protected DateExpression column;
        protected DateResult[] values;

        DBNnaryDateFunction() {
            this.values = null;
        }

        DBNnaryDateFunction(DateExpression leftHandSide, DateResult[] rightHandSide) {
            this.values = new DateResult[rightHandSide.length];
            this.column = leftHandSide;
            System.arraycopy(rightHandSide, 0, this.values, 0, rightHandSide.length);
        }

        @Override
        public DBDate getQueryableDatatypeForExpressionValue() {
            return new DBDate();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.column.toSQLString(db)).append(" ").append(this.getFunctionName(db)).append(this.beforeValue(db));
            String separator = "";
            for (DateResult val : this.values) {
                if (val != null) {
                    builder.append(separator).append(val.toSQLString(db));
                }
                separator = ", ";
            }
            builder.append(this.afterValue(db));
            return builder.toString();
        }

        @Override
        public DBNnaryDateFunction copy() {
            DBNnaryDateFunction newInstance;
            try {
                newInstance = (DBNnaryDateFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.column = this.column.copy();
            newInstance.values = this.values;
            return newInstance;
        }

        @Override
        public boolean isAggregator() {
            boolean result = this.column.isAggregator();
            for (DateResult dater : this.values) {
                result = result || dater.isAggregator();
            }
            return result;
        }
    }

    private static abstract class DBBinaryBooleanArithmetic
    implements BooleanResult {
        private DateExpression first;
        private DateResult second;
        private boolean requiresNullProtection = false;

        DBBinaryBooleanArithmetic(DateExpression first, DateResult second) {
            this.first = first;
            this.second = second;
            if (second.getIncludesNull()) {
                this.requiresNullProtection = true;
            }
        }

        @Override
        public DBBoolean getQueryableDatatypeForExpressionValue() {
            return new DBBoolean();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.first.toSQLString(db) + this.getEquationOperator(db) + this.second.toSQLString(db);
        }

        @Override
        public DBBinaryBooleanArithmetic copy() {
            DBBinaryBooleanArithmetic newInstance;
            try {
                newInstance = (DBBinaryBooleanArithmetic)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        protected abstract String getEquationOperator(DBDatabase var1);

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return this.requiresNullProtection;
        }
    }

    private static abstract class UnaryComplicatedNumberFunction
    implements NumberResult {
        protected DateExpression only;

        UnaryComplicatedNumberFunction() {
            this.only = null;
        }

        UnaryComplicatedNumberFunction(DateExpression only) {
            this.only = only;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        @Override
        public abstract String toSQLString(DBDatabase var1);

        @Override
        public UnaryComplicatedNumberFunction copy() {
            UnaryComplicatedNumberFunction newInstance;
            try {
                newInstance = (UnaryComplicatedNumberFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.only = this.only.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.only != null) {
                hashSet.addAll(this.only.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.only.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBNonaryFunction
    implements DateResult {
        DBNonaryFunction() {
        }

        abstract String getFunctionName(DBDatabase var1);

        @Override
        public DBDate getQueryableDatatypeForExpressionValue() {
            return new DBDate();
        }

        protected String beforeValue(DBDatabase db) {
            return " " + this.getFunctionName(db) + "";
        }

        protected String afterValue(DBDatabase db) {
            return " ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + this.afterValue(db);
        }

        @Override
        public DBNonaryFunction copy() {
            DBNonaryFunction newInstance;
            try {
                newInstance = (DBNonaryFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            return new HashSet<DBRow>();
        }

        @Override
        public boolean isAggregator() {
            return false;
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }
}

