/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.expressions;

import java.util.HashSet;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.expressions.BooleanResult;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.expressions.NumberExpression;
import nz.co.gregs.dbvolution.expressions.NumberResult;

public class BooleanExpression
implements BooleanResult {
    private final BooleanResult onlyBool;
    private boolean includeNulls;

    protected BooleanExpression() {
        this.onlyBool = new DBBoolean();
    }

    public BooleanExpression(BooleanResult booleanResult) {
        this.onlyBool = booleanResult;
        if (booleanResult.getIncludesNull()) {
            this.includeNulls = true;
        }
    }

    public BooleanExpression(Boolean bool) {
        this.onlyBool = new DBBoolean(bool);
        if (bool == null) {
            this.includeNulls = true;
        }
    }

    @Override
    public String toSQLString(DBDatabase db) {
        return this.onlyBool.toSQLString(db);
    }

    @Override
    public BooleanExpression copy() {
        return new BooleanExpression(this.onlyBool);
    }

    public static BooleanExpression value(Boolean bool) {
        return new BooleanExpression(bool);
    }

    public BooleanExpression is(Boolean bool) {
        return this.is(new BooleanExpression(bool));
    }

    public BooleanExpression is(BooleanResult bool) {
        return new BooleanExpression(new DBBinaryBooleanArithmetic(this, bool){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " = ";
            }
        });
    }

    public BooleanExpression xor(BooleanResult bool) {
        return this.is(bool).not();
    }

    public static BooleanExpression allOf(BooleanExpression ... booleanExpressions) {
        return new BooleanExpression(new DBNnaryBooleanArithmetic(booleanExpressions){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return db.getDefinition().beginAndLine();
            }
        });
    }

    public static BooleanExpression anyOf(BooleanExpression ... booleanExpressions) {
        return new BooleanExpression(new DBNnaryBooleanArithmetic(booleanExpressions){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return db.getDefinition().beginOrLine();
            }
        });
    }

    public BooleanExpression negate() {
        return new BooleanExpression(new DBUnaryBinaryFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getNegationFunctionName();
            }
        });
    }

    public BooleanExpression not() {
        return this.negate();
    }

    public static BooleanExpression isNotNull(DBExpression possibleNullExpression) {
        return new BooleanExpression(new DBUnaryBooleanArithmetic(possibleNullExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " IS NOT " + db.getDefinition().getNull();
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public static BooleanExpression isNull(DBExpression possibleNullExpression) {
        return new BooleanExpression(new DBUnaryBooleanArithmetic(possibleNullExpression){

            @Override
            protected String getEquationOperator(DBDatabase db) {
                return " IS " + db.getDefinition().getNull();
            }

            @Override
            public boolean getIncludesNull() {
                return false;
            }
        });
    }

    public NumberExpression count() {
        return new NumberExpression(new DBUnaryNumberFunction(this){

            @Override
            String getFunctionName(DBDatabase db) {
                return db.getDefinition().getCountFunctionName();
            }

            @Override
            public boolean isAggregator() {
                return true;
            }
        });
    }

    public static BooleanExpression falseExpression() {
        return new BooleanExpression(){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().getFalseOperation();
            }

            @Override
            public boolean isAggregator() {
                return false;
            }
        };
    }

    public static BooleanExpression trueExpression() {
        return new BooleanExpression(){

            @Override
            public String toSQLString(DBDatabase db) {
                return db.getDefinition().getTrueOperation();
            }

            @Override
            public boolean isAggregator() {
                return false;
            }
        };
    }

    @Override
    public DBBoolean getQueryableDatatypeForExpressionValue() {
        return new DBBoolean();
    }

    @Override
    public boolean isAggregator() {
        if (this.onlyBool != null) {
            return this.onlyBool.isAggregator();
        }
        return false;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return this.onlyBool == null ? new HashSet() : this.onlyBool.getTablesInvolved();
    }

    public boolean isRelationship() {
        return this.getTablesInvolved().size() > 1;
    }

    @Override
    public boolean getIncludesNull() {
        return this.includeNulls || this.onlyBool.getIncludesNull();
    }

    private static abstract class DBBinaryBooleanArithmetic
    implements BooleanResult {
        private BooleanResult first;
        private BooleanResult second;

        DBBinaryBooleanArithmetic(BooleanResult first, BooleanResult second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public DBBoolean getQueryableDatatypeForExpressionValue() {
            return new DBBoolean();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            DBDefinition defn;
            String sqlString = this.first.toSQLString(db) + this.getEquationOperator(db) + this.second.toSQLString(db);
            if (this.first.getIncludesNull()) {
                defn = db.getDefinition();
                sqlString = this.second.toSQLString(db) + " IS " + defn.getNull() + defn.beginOrLine() + sqlString;
            }
            if (this.second.getIncludesNull()) {
                defn = db.getDefinition();
                sqlString = this.first.toSQLString(db) + " IS " + defn.getNull() + defn.beginOrLine() + sqlString;
            }
            return "(" + sqlString + ")";
        }

        @Override
        public DBBinaryBooleanArithmetic copy() {
            DBBinaryBooleanArithmetic newInstance;
            try {
                newInstance = (DBBinaryBooleanArithmetic)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.first = this.first.copy();
            newInstance.second = this.second.copy();
            return newInstance;
        }

        protected abstract String getEquationOperator(DBDatabase var1);

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            if (this.first != null) {
                hashSet.addAll(this.first.getTablesInvolved());
            }
            if (this.second != null) {
                hashSet.addAll(this.second.getTablesInvolved());
            }
            return hashSet;
        }

        @Override
        public boolean isAggregator() {
            return this.first.isAggregator() || this.second.isAggregator();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBUnaryBinaryFunction
    implements BooleanResult {
        protected BooleanExpression onlyBool;
        private boolean includeNulls;

        DBUnaryBinaryFunction() {
            this.onlyBool = null;
        }

        DBUnaryBinaryFunction(BooleanExpression only) {
            this.onlyBool = only;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "" + this.getFunctionName(db) + "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + (this.onlyBool == null ? "" : this.onlyBool.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBUnaryBinaryFunction copy() {
            DBUnaryBinaryFunction newInstance;
            try {
                newInstance = (DBUnaryBinaryFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.onlyBool = this.onlyBool == null ? null : this.onlyBool.copy();
            return newInstance;
        }

        @Override
        public boolean isAggregator() {
            return this.onlyBool.isAggregator();
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            return this.onlyBool.getTablesInvolved();
        }

        @Override
        public boolean getIncludesNull() {
            return this.includeNulls;
        }
    }

    private static abstract class DBUnaryNumberFunction
    implements NumberResult {
        protected BooleanExpression onlyBool;

        DBUnaryNumberFunction() {
            this.onlyBool = null;
        }

        DBUnaryNumberFunction(BooleanExpression only) {
            this.onlyBool = only;
        }

        @Override
        public DBNumber getQueryableDatatypeForExpressionValue() {
            return new DBNumber();
        }

        abstract String getFunctionName(DBDatabase var1);

        protected String beforeValue(DBDatabase db) {
            return "" + this.getFunctionName(db) + "( ";
        }

        protected String afterValue(DBDatabase db) {
            return ") ";
        }

        @Override
        public String toSQLString(DBDatabase db) {
            return this.beforeValue(db) + (this.onlyBool == null ? "" : this.onlyBool.toSQLString(db)) + this.afterValue(db);
        }

        @Override
        public DBUnaryNumberFunction copy() {
            DBUnaryNumberFunction newInstance;
            try {
                newInstance = (DBUnaryNumberFunction)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.onlyBool = this.onlyBool == null ? null : this.onlyBool.copy();
            return newInstance;
        }

        @Override
        public boolean isAggregator() {
            return this.onlyBool.isAggregator();
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            return this.onlyBool.getTablesInvolved();
        }

        @Override
        public boolean getIncludesNull() {
            return false;
        }
    }

    private static abstract class DBNnaryBooleanArithmetic
    implements BooleanResult {
        private BooleanResult[] bools;
        private boolean includeNulls;

        DBNnaryBooleanArithmetic(BooleanResult ... bools) {
            this.bools = bools;
        }

        @Override
        public DBBoolean getQueryableDatatypeForExpressionValue() {
            return new DBBoolean();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            String returnStr = "";
            String separator = "";
            String op = this.getEquationOperator(db);
            for (BooleanResult boo : this.bools) {
                returnStr = returnStr + separator + boo.toSQLString(db);
                separator = op;
            }
            return returnStr;
        }

        @Override
        public DBNnaryBooleanArithmetic copy() {
            DBNnaryBooleanArithmetic newInstance;
            try {
                newInstance = (DBNnaryBooleanArithmetic)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.bools = new BooleanResult[this.bools.length];
            for (int i = 0; i < newInstance.bools.length; ++i) {
                newInstance.bools[i] = this.bools[i].copy();
            }
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            HashSet<DBRow> hashSet = new HashSet<DBRow>();
            for (BooleanResult boo : this.bools) {
                hashSet.addAll(boo.getTablesInvolved());
            }
            return hashSet;
        }

        protected abstract String getEquationOperator(DBDatabase var1);

        @Override
        public boolean isAggregator() {
            boolean result = false;
            for (BooleanResult boex : this.bools) {
                result = result || boex.isAggregator();
            }
            return result;
        }

        @Override
        public boolean getIncludesNull() {
            return this.includeNulls;
        }
    }

    private static abstract class DBUnaryBooleanArithmetic
    implements BooleanResult {
        private DBExpression onlyBool;

        DBUnaryBooleanArithmetic(DBExpression bool) {
            this.onlyBool = bool.copy();
        }

        @Override
        public DBBoolean getQueryableDatatypeForExpressionValue() {
            return new DBBoolean();
        }

        @Override
        public String toSQLString(DBDatabase db) {
            String op = this.getEquationOperator(db);
            String returnStr = this.onlyBool.toSQLString(db) + " " + op;
            return returnStr;
        }

        @Override
        public DBUnaryBooleanArithmetic copy() {
            DBUnaryBooleanArithmetic newInstance;
            try {
                newInstance = (DBUnaryBooleanArithmetic)this.getClass().newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            newInstance.onlyBool = this.onlyBool.copy();
            return newInstance;
        }

        @Override
        public Set<DBRow> getTablesInvolved() {
            return this.onlyBool == null ? new HashSet() : this.onlyBool.getTablesInvolved();
        }

        @Override
        public boolean isAggregator() {
            return this.onlyBool.isAggregator();
        }

        protected abstract String getEquationOperator(DBDatabase var1);
    }
}

