/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.example;

import java.util.regex.Pattern;
import nz.co.gregs.dbvolution.generation.DBTableClassGenerator;
import nz.co.gregs.dbvolution.generation.ForeignKeyRecognisor;

public class FKBasedFKRecognisor
extends ForeignKeyRecognisor {
    Pattern fkStartPattern = Pattern.compile("^[fF][kK]_");

    @Override
    public boolean isForeignKeyColumn(String tableName, String columnName) {
        return columnName.toLowerCase().startsWith("fk_");
    }

    @Override
    public String getReferencedColumn(String tableName, String columnName) {
        if (this.isForeignKeyColumn(tableName, columnName)) {
            String strippedOfFK = "";
            strippedOfFK = this.fkStartPattern.matcher(columnName).replaceAll("uid_").replaceAll("^(uid_[a-zA-Z0-9]+)(_[0-9]*)*$", "$1");
            return strippedOfFK;
        }
        return null;
    }

    @Override
    public String getReferencedTable(String tableName, String columnName) {
        if (this.isForeignKeyColumn(tableName, columnName)) {
            String strippedOfFK = this.fkStartPattern.matcher(columnName).replaceAll("");
            if (strippedOfFK.matches("^[0-9_]+$")) {
                return "T_" + strippedOfFK.replaceAll("^([a-zA-Z0-9]+)(_[0-9]*)*$", "$1");
            }
            return DBTableClassGenerator.toClassCase(strippedOfFK.replaceAll("_[0-9]+$", ""));
        }
        return null;
    }
}

