/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nz.co.gregs.dbvolution.datatypes.DBTypeAdaptor;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.internal.properties.SafeOneWaySimpleTypeAdaptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryableDatatypeSyncer {
    private static final Log log = LogFactory.getLog(QueryableDatatypeSyncer.class);
    protected final String propertyName;
    protected final DBTypeAdaptor<Object, Object> typeAdaptor;
    protected final Class<? extends QueryableDatatype> internalQdtType;
    protected QueryableDatatype internalQdt;
    protected SafeOneWaySimpleTypeAdaptor toExternalSimpleTypeAdaptor;
    protected SafeOneWaySimpleTypeAdaptor toInternalSimpleTypeAdaptor;

    public QueryableDatatypeSyncer(String propertyName, Class<? extends QueryableDatatype> internalQdtType, Class<?> internalQdtLiteralType, Class<?> externalSimpleType, DBTypeAdaptor<Object, Object> typeAdaptor) {
        if (typeAdaptor == null) {
            throw new DBRuntimeException("Null typeAdaptor was passed, this is an internal bug");
        }
        this.propertyName = propertyName;
        this.typeAdaptor = typeAdaptor;
        this.internalQdtType = internalQdtType;
        this.toExternalSimpleTypeAdaptor = new SafeOneWaySimpleTypeAdaptor(propertyName, typeAdaptor, SafeOneWaySimpleTypeAdaptor.Direction.TO_EXTERNAL, internalQdtLiteralType, externalSimpleType);
        this.toInternalSimpleTypeAdaptor = new SafeOneWaySimpleTypeAdaptor(propertyName, typeAdaptor, SafeOneWaySimpleTypeAdaptor.Direction.TO_INTERNAL, externalSimpleType, internalQdtLiteralType);
        try {
            this.internalQdt = internalQdtType.newInstance();
        }
        catch (InstantiationException e) {
            throw new DBRuntimeException("Instantiation error creating internal " + internalQdtType.getSimpleName() + " QDT: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new DBRuntimeException("Access error creating internal " + internalQdtType.getSimpleName() + " QDT: " + e.getMessage(), e);
        }
    }

    public QueryableDatatype getInternalQueryableDatatype() {
        return this.internalQdt;
    }

    public void setInternalQueryableDatatype(QueryableDatatype internalQdt) {
        if (internalQdt != null && !internalQdt.getClass().equals(this.internalQdtType)) {
            throw new ClassCastException("Cannot assign " + internalQdt.getClass().getSimpleName() + " to " + this.internalQdtType.getSimpleName() + " property " + this.propertyName);
        }
        this.internalQdt = internalQdt;
    }

    public QueryableDatatype setInternalQDTFromExternalQDT(QueryableDatatype externalQdt) {
        if (externalQdt == null) {
            this.internalQdt = null;
        } else {
            DBSafeInternalQDTAdaptor qdtAdaptor = new DBSafeInternalQDTAdaptor(this.internalQdtType, this.toInternalSimpleTypeAdaptor);
            qdtAdaptor.setTargetQDTFromSourceQDT(this.internalQdt, externalQdt);
        }
        return this.internalQdt;
    }

    public QueryableDatatype setExternalFromInternalQDT(QueryableDatatype externalQdt) {
        if (this.internalQdt == null) {
            return null;
        }
        DBSafeInternalQDTAdaptor qdtAdaptor = new DBSafeInternalQDTAdaptor(externalQdt.getClass(), this.toExternalSimpleTypeAdaptor);
        qdtAdaptor.setTargetQDTFromSourceQDT(externalQdt, this.internalQdt);
        return externalQdt;
    }

    static String qdtToString(QueryableDatatype qdt) {
        String literalStr = qdt == null ? null : (qdt.literalValue == null ? "null" : qdt.literalValue.getClass().getSimpleName() + "[" + qdt.literalValue + "]");
        StringBuilder buf = new StringBuilder();
        if (qdt == null) {
            buf.append("null");
        } else {
            buf.append(qdt.getClass().getSimpleName());
            buf.append("[");
            buf.append(qdt);
            buf.append(", ");
            buf.append("literal=").append(literalStr);
            if (qdt.operator != null) {
                buf.append(", ");
                buf.append(qdt.operator.getClass().getSimpleName());
            }
            buf.append("]");
        }
        return buf.toString();
    }

    public static class DBSafeInternalQDTAdaptor {
        private Class<? extends QueryableDatatype> targetQdtType;
        private SafeOneWaySimpleTypeAdaptor simpleTypeAdaptor;
        private List<Map.Entry<QueryableDatatype, QueryableDatatype>> observedSourcesAndTargets = new ArrayList<Map.Entry<QueryableDatatype, QueryableDatatype>>();

        public DBSafeInternalQDTAdaptor(Class<? extends QueryableDatatype> targetQdtType, SafeOneWaySimpleTypeAdaptor typeAdaptor) {
            this.targetQdtType = targetQdtType;
            this.simpleTypeAdaptor = typeAdaptor;
        }

        public DBExpression convert(DBExpression source) {
            if (!(source instanceof QueryableDatatype)) {
                return source;
            }
            QueryableDatatype sourceQDT = (QueryableDatatype)source;
            try {
                for (Map.Entry<QueryableDatatype, QueryableDatatype> sourceAndTarget : this.observedSourcesAndTargets) {
                    if (sourceAndTarget.getKey() != sourceQDT) continue;
                    return sourceAndTarget.getValue();
                }
                QueryableDatatype targetQdt = this.newTargetQDT();
                this.setTargetQDTFromSourceQDT(targetQdt, sourceQDT);
                log.debug((Object)(this.simpleTypeAdaptor + " converting " + QueryableDatatypeSyncer.qdtToString(sourceQDT) + " ==> " + QueryableDatatypeSyncer.qdtToString(targetQdt)));
                return targetQdt;
            }
            catch (RuntimeException e) {
                log.debug((Object)(this.simpleTypeAdaptor + " converting " + QueryableDatatypeSyncer.qdtToString(sourceQDT) + " ==> " + e.getClass().getSimpleName()));
                throw e;
            }
        }

        protected void setTargetQDTFromSourceQDT(QueryableDatatype targetQdt, QueryableDatatype sourceQdt) {
            if (!targetQdt.getClass().equals(this.targetQdtType)) {
                throw new RuntimeException("Don't know what to do here: targetQdtType:" + targetQdt.getClass().getSimpleName() + " != " + this.targetQdtType + ":" + this.targetQdtType.getSimpleName());
            }
            for (Map.Entry<QueryableDatatype, QueryableDatatype> soFarEntry : this.observedSourcesAndTargets) {
                if (soFarEntry.getKey() != sourceQdt) continue;
                return;
            }
            this.observedSourcesAndTargets.add(new AbstractMap.SimpleEntry<QueryableDatatype, QueryableDatatype>(sourceQdt, targetQdt));
            targetQdt.changed = sourceQdt.changed;
            targetQdt.includingNulls = sourceQdt.includingNulls;
            targetQdt.isDBNull = sourceQdt.isDBNull;
            targetQdt.isPrimaryKey = sourceQdt.isPrimaryKey;
            targetQdt.setDefined(sourceQdt.isDefined());
            targetQdt.sort = sourceQdt.sort;
            targetQdt.columnExpression = sourceQdt.columnExpression;
            targetQdt.literalValue = this.simpleTypeAdaptor.convert(sourceQdt.literalValue);
            targetQdt.previousValueAsQDT = (QueryableDatatype)this.convert(sourceQdt.previousValueAsQDT);
            targetQdt.operator = sourceQdt.operator == null ? null : sourceQdt.operator.copyAndAdapt(this);
        }

        private QueryableDatatype newTargetQDT() {
            try {
                return this.targetQdtType.newInstance();
            }
            catch (InstantiationException e) {
                throw new DBRuntimeException("Instantiation error creating internal " + this.targetQdtType.getSimpleName() + " QDT: " + e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new DBRuntimeException("Access error creating internal " + this.targetQdtType.getSimpleName() + " QDT: " + e.getMessage(), e);
            }
        }
    }
}

