/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBByteArray;
import nz.co.gregs.dbvolution.datatypes.DBDataGenerator;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBInteger;
import nz.co.gregs.dbvolution.datatypes.DBJavaObject;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.exceptions.UnableInstantiateQueryableDatatypeException;
import nz.co.gregs.dbvolution.exceptions.UnableToCopyQueryableDatatypeException;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapperDefinition;
import nz.co.gregs.dbvolution.operators.DBEqualsOperator;
import nz.co.gregs.dbvolution.operators.DBIsNullOperator;
import nz.co.gregs.dbvolution.operators.DBOperator;

public abstract class QueryableDatatype
implements Serializable,
DBExpression {
    public static final long serialVersionUID = 1L;
    protected Object literalValue = null;
    protected boolean isDBNull = false;
    protected boolean includingNulls = false;
    protected DBOperator operator = null;
    private boolean undefined = true;
    protected boolean changed = false;
    protected QueryableDatatype previousValueAsQDT = null;
    protected boolean isPrimaryKey = false;
    public static final Boolean SORT_ASCENDING = Boolean.TRUE;
    public static final Boolean SORT_DESCENDING = Boolean.FALSE;
    protected Boolean sort = SORT_ASCENDING;
    protected transient PropertyWrapperDefinition propertyWrapper;
    protected DBExpression columnExpression = null;
    private boolean setValueHasBeenCalled = false;

    protected QueryableDatatype() {
    }

    protected QueryableDatatype(Object obj) {
        if (obj == null) {
            this.isDBNull = true;
        } else {
            this.literalValue = obj;
            this.operator = new DBEqualsOperator(this);
            this.undefined = false;
        }
    }

    protected QueryableDatatype(DBExpression columnExpression) {
        this.columnExpression = columnExpression.copy();
    }

    public static <T extends QueryableDatatype> T getQueryableDatatypeInstance(Class<T> requiredQueryableDatatype) {
        try {
            return (T)((QueryableDatatype)requiredQueryableDatatype.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Unable To Create " + requiredQueryableDatatype.getClass().getSimpleName() + ": Please ensure that the constructor of  " + requiredQueryableDatatype.getClass().getSimpleName() + " has no arguments, throws no exceptions, and is public", ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Unable To Create " + requiredQueryableDatatype.getClass().getSimpleName() + ": Please ensure that the constructor of  " + requiredQueryableDatatype.getClass().getSimpleName() + " has no arguments, throws no exceptions, and is public", ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable To Create " + requiredQueryableDatatype.getClass().getSimpleName() + ": Please ensure that the constructor of  " + requiredQueryableDatatype.getClass().getSimpleName() + " has no arguments, throws no exceptions, and is public", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Unable To Create " + requiredQueryableDatatype.getClass().getSimpleName() + ": Please ensure that the constructor of  " + requiredQueryableDatatype.getClass().getSimpleName() + " has no arguments, throws no exceptions, and is public", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Unable To Create " + requiredQueryableDatatype.getClass().getSimpleName() + ": Please ensure that the constructor of  " + requiredQueryableDatatype.getClass().getSimpleName() + " has no arguments, throws no exceptions, and is public", ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Unable To Create " + requiredQueryableDatatype.getClass().getSimpleName() + ": Please ensure that the constructor of  " + requiredQueryableDatatype.getClass().getSimpleName() + " has no arguments, throws no exceptions, and is public", ex);
        }
    }

    public static QueryableDatatype getQueryableDatatypeForObject(Object o) {
        Object qdt;
        if (o instanceof QueryableDatatype) {
            qdt = QueryableDatatype.getQueryableDatatypeInstance(((QueryableDatatype)o).getClass());
            ((QueryableDatatype)qdt).setLiteralValue(((QueryableDatatype)o).literalValue);
        } else {
            qdt = o instanceof DBExpression ? new DBDataGenerator() : (o instanceof Integer ? new DBInteger() : (o instanceof Number ? new DBNumber() : (o instanceof String ? new DBString() : (o instanceof Date ? new DBDate() : (o instanceof Byte[] ? new DBByteArray() : (o instanceof Boolean ? new DBBoolean() : new DBJavaObject()))))));
            ((QueryableDatatype)qdt).setLiteralValue(o);
        }
        return qdt;
    }

    @Override
    public QueryableDatatype copy() {
        QueryableDatatype newQDT = this;
        try {
            newQDT = (QueryableDatatype)this.getClass().newInstance();
            newQDT.literalValue = this.literalValue;
            newQDT.isDBNull = this.isDBNull;
            newQDT.includingNulls = this.includingNulls;
            newQDT.operator = this.operator;
            newQDT.undefined = this.undefined;
            newQDT.changed = this.changed;
            newQDT.setValueHasBeenCalled = this.setValueHasBeenCalled;
            if (this.previousValueAsQDT != null) {
                newQDT.previousValueAsQDT = this.previousValueAsQDT.copy();
            }
            newQDT.isPrimaryKey = this.isPrimaryKey;
            newQDT.sort = this.sort;
            newQDT.columnExpression = this.columnExpression;
        }
        catch (InstantiationException ex) {
            throw new UnableInstantiateQueryableDatatypeException(this, ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnableToCopyQueryableDatatypeException(this, ex);
        }
        return newQDT;
    }

    public String toString() {
        return this.literalValue == null ? "" : this.literalValue.toString();
    }

    public String stringValue() {
        return this.literalValue == null ? "" : this.literalValue.toString();
    }

    @Deprecated
    public Long longValue() throws NumberFormatException {
        if (this.isDBNull || this.literalValue == null) {
            return null;
        }
        if (this.literalValue instanceof Long) {
            return (Long)this.literalValue;
        }
        if (this.literalValue instanceof Number) {
            return ((Number)this.literalValue).longValue();
        }
        return Long.parseLong(this.literalValue.toString());
    }

    @Deprecated
    public Integer intValue() throws NumberFormatException {
        if (this.isDBNull || this.literalValue == null) {
            return null;
        }
        if (this.literalValue instanceof Integer) {
            return (Integer)this.literalValue;
        }
        if (this.literalValue instanceof Number) {
            return ((Number)this.literalValue).intValue();
        }
        return Integer.parseInt(this.literalValue.toString());
    }

    @Deprecated
    public Double doubleValue() {
        if (this.isDBNull || this.literalValue == null) {
            return null;
        }
        if (this.literalValue instanceof Double) {
            return (Double)this.literalValue;
        }
        if (this.literalValue instanceof Number) {
            return ((Number)this.literalValue).doubleValue();
        }
        return Double.parseDouble(this.literalValue.toString());
    }

    protected void blankQuery() {
        this.includingNulls = false;
        this.isDBNull = false;
        this.operator = null;
    }

    public String getWhereClause(DBDatabase db, String columnName) {
        return this.getWhereClauseUsingOperators(db, columnName);
    }

    private String getWhereClauseUsingOperators(DBDatabase db, String columnName) {
        String whereClause = "";
        DBOperator op = this.getOperator();
        if (op != null) {
            whereClause = op.generateWhereLine(db, columnName);
        }
        return whereClause;
    }

    public void negateOperator() {
        if (this.getOperator() == null) {
            throw new RuntimeException("No Operator Has Been Defined Yet: please use the permitted/excluded methods before negating the operation");
        }
        this.getOperator().invertOperator(true);
    }

    public Object getValue() {
        if (this.undefined || this.isNull()) {
            return null;
        }
        return this.literalValue;
    }

    public abstract void setValue(Object var1);

    protected void setLiteralValue(Object newLiteralValue) {
        this.preventChangeOfPrimaryKey();
        if (newLiteralValue == null) {
            this.setChanged(newLiteralValue);
            this.setToNull();
        } else {
            this.setChanged(newLiteralValue);
            this.literalValue = newLiteralValue;
            if (newLiteralValue instanceof DBExpression) {
                this.setOperator(new DBEqualsOperator(new DBDataGenerator((DBExpression)newLiteralValue)));
            } else if (newLiteralValue instanceof Date) {
                this.setOperator(new DBEqualsOperator(new DBDate((Date)newLiteralValue)));
            } else if (newLiteralValue instanceof Timestamp) {
                this.setOperator(new DBEqualsOperator(new DBDate((Timestamp)newLiteralValue)));
            } else {
                this.setOperator(new DBEqualsOperator(this.copy()));
            }
        }
        this.setHasBeenSet(true);
    }

    public void setUnchanged() {
        this.changed = false;
        this.previousValueAsQDT = null;
    }

    protected DBOperator setToNull() {
        this.literalValue = null;
        this.isDBNull = true;
        this.setOperator(new DBIsNullOperator());
        return this.getOperator();
    }

    public void includingNulls() {
        this.operator.includeNulls();
    }

    public abstract String getSQLDatatype();

    @Override
    public final String toSQLString(DBDatabase db) {
        DBDefinition def = db.getDefinition();
        if (this.isDBNull || this.literalValue == null) {
            return def.getNull();
        }
        if (this.literalValue instanceof DBExpression) {
            return ((DBExpression)this.literalValue).toSQLString(db);
        }
        return this.formatValueForSQLStatement(db);
    }

    protected abstract String formatValueForSQLStatement(DBDatabase var1);

    public DBOperator getOperator() {
        return this.operator;
    }

    public void setOperator(DBOperator operator) {
        this.blankQuery();
        this.operator = operator;
        if (this.undefined) {
            this.undefined = false;
        } else {
            this.changed = true;
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setFromResultSet(DBDatabase database, ResultSet resultSet, String resultSetColumnName) throws SQLException {
        this.blankQuery();
        if (resultSet == null || resultSetColumnName == null) {
            this.setToNull();
        } else {
            String dbValue;
            try {
                dbValue = resultSet.getString(resultSetColumnName);
                if (resultSet.wasNull()) {
                    dbValue = null;
                }
            }
            catch (SQLException ex) {
                dbValue = null;
            }
            if (dbValue == null) {
                this.setToNull();
            } else {
                this.setLiteralValue(dbValue);
            }
        }
        this.setUnchanged();
        this.setDefined(true);
        this.propertyWrapper = null;
    }

    private void preventChangeOfPrimaryKey() {
        if (this.isPrimaryKey && !this.undefined) {
            throw new RuntimeException("Accidental Change Of Primary Key Stopped: Use the changePrimaryKey() method to change the primary key's value.");
        }
    }

    private void setChanged(Object newLiteralValue) {
        if (this.isDBNull && newLiteralValue != null || this.literalValue != null && (newLiteralValue == null || !newLiteralValue.equals(this.literalValue))) {
            this.changed = true;
            Object copyOfOldValues = QueryableDatatype.getQueryableDatatypeInstance(this.getClass());
            if (this.isDBNull) {
                ((QueryableDatatype)copyOfOldValues).setToNull();
            } else {
                ((QueryableDatatype)copyOfOldValues).setLiteralValue(this.literalValue);
            }
            this.previousValueAsQDT = copyOfOldValues;
        }
    }

    public boolean isNull() {
        return this.isDBNull || this.literalValue == null;
    }

    public String getPreviousSQLValue(DBDatabase db) {
        return this.previousValueAsQDT == null ? null : this.previousValueAsQDT.toSQLString(db);
    }

    private QueryableDatatype setSortOrder(Boolean order) {
        this.sort = order;
        return this;
    }

    public QueryableDatatype setSortOrderAscending() {
        return this.setSortOrder(true);
    }

    public QueryableDatatype setSortOrderDescending() {
        return this.setSortOrder(false);
    }

    public Boolean getSortOrder() {
        return this.sort;
    }

    public void clear() {
        this.blankQuery();
    }

    public boolean equals(QueryableDatatype other) {
        if (other == null) {
            return false;
        }
        if (this.operator == null && other.operator == null) {
            return true;
        }
        if (this.operator != null && other.operator == null) {
            return false;
        }
        if (this.operator == null && other.operator != null) {
            return false;
        }
        return this.getOperator().equals(other.getOperator());
    }

    protected boolean isDefined() {
        return !this.undefined;
    }

    protected void setDefined(boolean defined) {
        this.undefined = !defined;
    }

    void setPropertyWrapper(PropertyWrapperDefinition propertyWrapper) {
        this.propertyWrapper = propertyWrapper;
    }

    @Override
    public QueryableDatatype getQueryableDatatypeForExpressionValue() {
        try {
            return (QueryableDatatype)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            return this;
        }
        catch (IllegalAccessException ex) {
            return this;
        }
    }

    public final DBExpression getColumnExpression() {
        return this.columnExpression;
    }

    public final boolean hasColumnExpression() {
        return this.columnExpression != null;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return new HashSet<DBRow>();
    }

    public boolean hasBeenSet() {
        return this.setValueHasBeenCalled;
    }

    private void setHasBeenSet(boolean hasBeenSet) {
        this.setValueHasBeenCalled = hasBeenSet;
    }
}

