/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.DBEnum;
import nz.co.gregs.dbvolution.datatypes.DBEnumValue;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.expressions.StringExpression;
import nz.co.gregs.dbvolution.expressions.StringResult;
import nz.co.gregs.dbvolution.operators.DBPermittedPatternOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeExclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeInclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedValuesIgnoreCaseOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedValuesOperator;

public class DBStringEnum<E extends Enum<E>>
extends DBEnum<E> {
    private static final long serialVersionUID = 1L;

    public DBStringEnum() {
    }

    public DBStringEnum(String value) {
        super(value);
    }

    public DBStringEnum(StringResult stringExpression) {
        super(stringExpression);
    }

    public DBStringEnum(E value) {
        super(value);
    }

    @Override
    protected void validateLiteralValue(E enumValue) {
        Object localValue = ((DBEnumValue)enumValue).getCode();
        if (localValue != null && !(localValue instanceof String)) {
            String enumMethodRef = enumValue.getClass().getName() + "." + ((Enum)enumValue).name() + ".getLiteralValue()";
            String literalValueTypeRef = localValue.getClass().getName();
            throw new IncompatibleClassChangeError("Enum literal type is not valid: " + enumMethodRef + " returned a " + literalValueTypeRef + ", which is not valid for a " + this.getClass().getSimpleName());
        }
    }

    @Override
    public String getSQLDatatype() {
        return new DBString().getSQLDatatype();
    }

    @Override
    public void setValue(Object newLiteralValue) {
        if (newLiteralValue instanceof String) {
            this.setValue((String)newLiteralValue);
        } else if (newLiteralValue instanceof DBString) {
            this.setValue(((DBString)newLiteralValue).getValue());
        } else {
            throw new ClassCastException(this.getClass().getSimpleName() + ".setValue() Called With A Non-String: Use only Strings with this class");
        }
    }

    @Override
    public void setValue(String newLiteralValue) {
        super.setLiteralValue(newLiteralValue);
    }

    @Override
    public DBString getQueryableDatatypeForExpressionValue() {
        return new DBString();
    }

    @Override
    public boolean isAggregator() {
        return false;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return new HashSet<DBRow>();
    }

    protected String[] convertToLiteralString(E ... enumValues) {
        String[] result = new String[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            E enumValue = enumValues[i];
            result[i] = this.convertToLiteralString(enumValue);
        }
        return result;
    }

    protected String[] convertToLiteralString(Collection<E> enumValues) {
        ArrayList<String> result = new ArrayList<String>();
        for (Enum e : enumValues) {
            result.add(this.convertToLiteralString((E)e));
        }
        return result.toArray(new String[0]);
    }

    protected final String convertToLiteralString(E enumValue) {
        if (enumValue == null || ((DBEnumValue)enumValue).getCode() == null) {
            return null;
        }
        this.validateLiteralValue(enumValue);
        String newLiteralValue = (String)((DBEnumValue)enumValue).getCode();
        return newLiteralValue;
    }

    public void permittedValues(String ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValuesIgnoreCase(String ... permitted) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(permitted));
    }

    public void permittedValuesIgnoreCase(StringExpression ... permitted) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(permitted));
    }

    public void permittedValuesIgnoreCase(List<String> permitted) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(permitted));
    }

    public void permittedValuesIgnoreCase(Set<String> permitted) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(permitted));
    }

    public void excludedValuesIgnoreCase(String ... excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(excluded));
        this.negateOperator();
    }

    public void excludedValuesIgnoreCase(StringExpression ... excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(excluded));
        this.negateOperator();
    }

    public void excludedValuesIgnoreCase(List<String> excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(excluded));
        this.negateOperator();
    }

    public void excludedValuesIgnoreCase(Set<String> excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(excluded));
        this.negateOperator();
    }

    public void excludedValues(String ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedRange(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void excludedRange(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void permittedPattern(String pattern) {
        this.setOperator(new DBPermittedPatternOperator(pattern));
    }

    public void excludedPattern(String pattern) {
        this.setOperator(new DBPermittedPatternOperator(pattern));
        this.negateOperator();
    }

    public void permittedPattern(StringExpression pattern) {
        this.setOperator(new DBPermittedPatternOperator(pattern));
    }

    public void excludedPattern(StringExpression pattern) {
        this.setOperator(new DBPermittedPatternOperator(pattern));
        this.negateOperator();
    }

    public void permittedValues(E ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(this.convertToLiteral((Enum[])permitted)));
    }

    public void permittedValuesIgnoreCase(E ... permitted) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator((String[])this.convertToLiteral((Enum[])permitted)));
    }

    public void excludedValuesIgnoreCase(E ... excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(this.convertToLiteralString((Enum[])excluded)));
        this.negateOperator();
    }

    public void excludedValuesIgnoreCase(Collection<E> excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(this.convertToLiteralString(excluded)));
        this.negateOperator();
    }

    public void excludedValues(E ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(this.convertToLiteralString((Enum[])excluded)));
        this.negateOperator();
    }

    public void permittedRange(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeOperator(this.convertToLiteralString(lowerBound), this.convertToLiteralString(upperBound)));
    }

    public void permittedRangeInclusive(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(this.convertToLiteralString(lowerBound), this.convertToLiteralString(upperBound)));
    }

    public void permittedRangeExclusive(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(this.convertToLiteralString(lowerBound), this.convertToLiteralString(upperBound)));
    }

    public void excludedRange(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeOperator(this.convertToLiteralString(lowerBound), this.convertToLiteralString(upperBound)));
        this.negateOperator();
    }

    public void excludedRangeInclusive(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(this.convertToLiteralString(lowerBound), this.convertToLiteralString(upperBound)));
        this.negateOperator();
    }

    public void excludedRangeExclusive(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(this.convertToLiteralString(lowerBound), this.convertToLiteralString(upperBound)));
        this.negateOperator();
    }

    @Override
    public String getValue() {
        Object value = this.literalValue;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }
}

