/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.expressions.StringExpression;
import nz.co.gregs.dbvolution.expressions.StringResult;
import nz.co.gregs.dbvolution.operators.DBPermittedPatternOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeExclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeInclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedValuesIgnoreCaseOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedValuesOperator;

public class DBString
extends QueryableDatatype
implements StringResult {
    private static final long serialVersionUID = 1L;

    public static List<String> toStringList(List<DBString> dbStrings) {
        ArrayList<String> strings = new ArrayList<String>();
        for (DBString dBString : dbStrings) {
            strings.add(dBString.stringValue());
        }
        return strings;
    }

    public DBString() {
    }

    public DBString(String string) {
        super(string);
    }

    public DBString(StringResult stringExpression) {
        super(stringExpression);
    }

    @Override
    public void setValue(Object newLiteralValue) {
        if (!(newLiteralValue instanceof String)) {
            throw new ClassCastException(this.getClass().getSimpleName() + ".setValue() Called With A Non-String: Use only Strings with this class");
        }
        this.setValue((String)newLiteralValue);
    }

    public void setValue(String str) {
        super.setLiteralValue(str);
    }

    @Override
    public String getValue() {
        Object value = super.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    @Override
    public String getSQLDatatype() {
        return "VARCHAR(1000)";
    }

    @Override
    public String formatValueForSQLStatement(DBDatabase db) {
        DBDefinition defn = db.getDefinition();
        if (this.literalValue instanceof Date) {
            return defn.getDateFormattedForQuery((Date)this.literalValue);
        }
        if (this.literalValue.equals("")) {
            return defn.getEmptyString();
        }
        String unsafeValue = this.literalValue.toString();
        return defn.beginStringValue() + defn.safeString(unsafeValue) + defn.endStringValue();
    }

    @Override
    public DBString copy() {
        return (DBString)super.copy();
    }

    @Override
    public DBString getQueryableDatatypeForExpressionValue() {
        return new DBString();
    }

    @Override
    public boolean isAggregator() {
        return false;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return new HashSet<DBRow>();
    }

    public void permittedValues(String ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValues(Object ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValues(Collection<String> permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValuesIgnoreCase(String ... permitted) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(permitted));
    }

    public void permittedValuesIgnoreCase(StringExpression ... permitted) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(permitted));
    }

    public void permittedValuesIgnoreCase(List<String> permitted) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(permitted));
    }

    public void permittedValuesIgnoreCase(Set<String> permitted) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(permitted));
    }

    public void excludedValuesIgnoreCase(String ... excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(excluded));
        this.negateOperator();
    }

    public void excludedValuesIgnoreCase(StringExpression ... excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(excluded));
        this.negateOperator();
    }

    public void excludedValuesIgnoreCase(List<String> excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(excluded));
        this.negateOperator();
    }

    public void excludedValuesIgnoreCase(Set<String> excluded) {
        this.setOperator(new DBPermittedValuesIgnoreCaseOperator(excluded));
        this.negateOperator();
    }

    public void excludedValues(String ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void excludedValues(List<String> excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedRange(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void excludedRange(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(String lowerBound, String upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void permittedPattern(String pattern) {
        this.setOperator(new DBPermittedPatternOperator(pattern));
    }

    public void excludedPattern(String pattern) {
        this.setOperator(new DBPermittedPatternOperator(pattern));
        this.negateOperator();
    }

    public void permittedPattern(StringExpression pattern) {
        this.setOperator(new DBPermittedPatternOperator(pattern));
    }

    public void excludedPattern(StringExpression pattern) {
        this.setOperator(new DBPermittedPatternOperator(pattern));
        this.negateOperator();
    }

    public void permittedValues(StringExpression ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void excludedValues(StringExpression ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedRange(StringExpression lowerBound, StringExpression upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(StringExpression lowerBound, StringExpression upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(StringExpression lowerBound, StringExpression upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void excludedRange(StringExpression lowerBound, StringExpression upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(StringExpression lowerBound, StringExpression upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(StringExpression lowerBound, StringExpression upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    @Override
    public boolean getIncludesNull() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

