/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.expressions.NumberResult;
import nz.co.gregs.dbvolution.operators.DBLikeCaseInsensitiveOperator;
import nz.co.gregs.dbvolution.operators.DBLikeOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeExclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeInclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedValuesOperator;

public class DBNumber
extends QueryableDatatype
implements NumberResult {
    private static final long serialVersionUID = 1L;

    public DBNumber() {
    }

    public DBNumber(NumberResult numberExpression) {
        super(numberExpression);
    }

    public DBNumber(Number aNumber) {
        super(aNumber);
    }

    public DBNumber(Integer aNumber) {
        super(aNumber);
    }

    public DBNumber(Long aNumber) {
        super(aNumber);
    }

    @Override
    public DBNumber copy() {
        return (DBNumber)super.copy();
    }

    @Override
    public void setValue(Object newLiteralValue) {
        if (newLiteralValue instanceof Number) {
            this.setValue((Number)newLiteralValue);
        } else if (newLiteralValue instanceof DBNumber) {
            this.setValue((DBNumber)newLiteralValue);
        } else {
            throw new ClassCastException(this.getClass().getSimpleName() + ".setValue() Called With A " + newLiteralValue.getClass().getSimpleName() + ": Use only Numbers with this class");
        }
    }

    public void setValue(DBNumber newLiteralValue) {
        this.setValue(newLiteralValue.getValue());
    }

    public void setValue(Number newLiteralValue) {
        if (newLiteralValue == null) {
            super.setLiteralValue(null);
        } else {
            super.setLiteralValue(newLiteralValue);
        }
    }

    @Override
    public void blankQuery() {
        super.blankQuery();
    }

    @Override
    public String getWhereClause(DBDatabase db, String columnName) {
        if (this.getOperator() instanceof DBLikeCaseInsensitiveOperator) {
            throw new RuntimeException("NUMBER COLUMNS CAN'T USE \"LIKE\": " + columnName);
        }
        if (this.getOperator() instanceof DBLikeOperator) {
            throw new RuntimeException("NUMBER COLUMNS CAN'T USE \"LIKE\": " + columnName);
        }
        return super.getWhereClause(db, columnName);
    }

    @Override
    public String getSQLDatatype() {
        return "NUMERIC(15,5)";
    }

    @Override
    public String formatValueForSQLStatement(DBDatabase db) {
        DBDefinition defn = db.getDefinition();
        if (this.isNull()) {
            return defn.getNull();
        }
        return defn.beginNumberValue() + this.literalValue.toString() + defn.endNumberValue();
    }

    @Override
    public Number getValue() {
        return this.numberValue();
    }

    public Number numberValue() {
        if (this.literalValue == null) {
            return null;
        }
        if (this.literalValue instanceof Number) {
            return (Number)this.literalValue;
        }
        return Double.parseDouble(this.literalValue.toString());
    }

    @Override
    public Double doubleValue() {
        if (this.literalValue == null) {
            return null;
        }
        if (this.literalValue instanceof Number) {
            return ((Number)this.literalValue).doubleValue();
        }
        return Double.parseDouble(this.literalValue.toString());
    }

    @Override
    public Long longValue() {
        if (this.literalValue == null) {
            return null;
        }
        if (this.literalValue instanceof Long) {
            return (Long)this.literalValue;
        }
        if (this.literalValue instanceof Number) {
            return ((Number)this.literalValue).longValue();
        }
        return Long.parseLong(this.literalValue.toString());
    }

    @Override
    public Integer intValue() {
        if (this.literalValue == null) {
            return null;
        }
        if (this.literalValue instanceof Number) {
            return ((Number)this.literalValue).intValue();
        }
        return Integer.parseInt(this.literalValue.toString());
    }

    @Override
    public void setFromResultSet(DBDatabase database, ResultSet resultSet, String fullColumnName) {
        this.blankQuery();
        if (resultSet == null || fullColumnName == null) {
            this.setToNull();
        } else {
            Number dbValue;
            try {
                dbValue = resultSet.getBigDecimal(fullColumnName);
            }
            catch (SQLException ex) {
                try {
                    dbValue = resultSet.getLong(fullColumnName);
                }
                catch (SQLException ex2) {
                    dbValue = null;
                }
            }
            try {
                if (resultSet.wasNull()) {
                    dbValue = null;
                }
            }
            catch (SQLException ex) {
                dbValue = null;
            }
            if (dbValue == null) {
                this.setToNull();
            } else {
                this.setValue(dbValue);
            }
        }
        this.setUnchanged();
        this.setDefined(true);
    }

    @Override
    public DBNumber getQueryableDatatypeForExpressionValue() {
        return new DBNumber();
    }

    @Override
    public boolean isAggregator() {
        return false;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return new HashSet<DBRow>();
    }

    public void permittedValues(Number ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValues(Collection<Number> permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValues(NumberResult ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void excludedValues(Number ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void excludedValues(Collection<Number> excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void excludedValues(NumberResult ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedRange(Number lowerBound, Number upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRange(NumberResult lowerBound, NumberResult upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(Number lowerBound, Number upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(NumberResult lowerBound, NumberResult upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(Number lowerBound, Number upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(NumberResult lowerBound, NumberResult upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void excludedRange(Number lowerBound, Number upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRange(NumberResult lowerBound, NumberResult upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(Number lowerBound, Number upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(NumberResult lowerBound, NumberResult upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(Number lowerBound, Number upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(NumberResult lowerBound, NumberResult upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    @Override
    public boolean getIncludesNull() {
        return false;
    }
}

