/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.DBEnum;
import nz.co.gregs.dbvolution.datatypes.DBEnumValue;
import nz.co.gregs.dbvolution.datatypes.DBInteger;
import nz.co.gregs.dbvolution.expressions.NumberResult;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeExclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeInclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedValuesOperator;

public class DBIntegerEnum<E extends Enum<E>>
extends DBEnum<E> {
    private static final long serialVersionUID = 1L;

    public DBIntegerEnum() {
    }

    public DBIntegerEnum(Integer value) {
        super((Object)value.longValue());
    }

    public DBIntegerEnum(Long value) {
        super(value);
    }

    public DBIntegerEnum(NumberResult numberExpression) {
        super((Object)numberExpression);
    }

    public DBIntegerEnum(E value) {
        super(value);
    }

    @Override
    public void setValue(Object newLiteralValue) {
        if (newLiteralValue instanceof Long) {
            this.setValue((Long)newLiteralValue);
        } else if (newLiteralValue instanceof Integer) {
            this.setValue((Integer)newLiteralValue);
        } else if (newLiteralValue instanceof DBIntegerEnum) {
            this.setValue(((DBIntegerEnum)newLiteralValue).literalValue);
        } else {
            throw new ClassCastException(this.getClass().getSimpleName() + ".setValue() Called With A Non-Long: Use only Long with this class");
        }
    }

    @Override
    public void setValue(Long newLiteralValue) {
        super.setLiteralValue(newLiteralValue);
    }

    @Override
    public void setValue(Integer newLiteralValue) {
        super.setLiteralValue(newLiteralValue);
    }

    @Override
    protected void validateLiteralValue(E enumValue) {
        Object literalValue = ((DBEnumValue)enumValue).getCode();
        if (literalValue != null && !(literalValue instanceof Integer) && !(literalValue instanceof Long)) {
            String enumMethodRef = enumValue.getClass().getName() + "." + ((Enum)enumValue).name() + ".getLiteralValue()";
            String literalValueTypeRef = literalValue.getClass().getName();
            throw new IncompatibleClassChangeError("Enum literal type is not valid: " + enumMethodRef + " returned a " + literalValueTypeRef + ", which is not valid for a " + this.getClass().getSimpleName());
        }
    }

    @Override
    public String getSQLDatatype() {
        return new DBInteger().getSQLDatatype();
    }

    @Override
    public void setFromResultSet(DBDatabase database, ResultSet resultSet, String fullColumnName) {
        this.blankQuery();
        if (resultSet == null || fullColumnName == null) {
            this.setToNull();
        } else {
            Long dbValue;
            try {
                dbValue = resultSet.getLong(fullColumnName);
                if (resultSet.wasNull()) {
                    dbValue = null;
                }
            }
            catch (SQLException ex) {
                dbValue = null;
            }
            if (dbValue == null) {
                this.setToNull();
            } else {
                this.setLiteralValue(dbValue);
            }
        }
        this.setUnchanged();
        this.setDefined(true);
    }

    @Override
    public DBInteger getQueryableDatatypeForExpressionValue() {
        return new DBInteger();
    }

    @Override
    public boolean isAggregator() {
        return false;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return new HashSet<DBRow>();
    }

    public void permittedValues(E ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(this.convertToLiteral((Enum[])permitted)));
    }

    public void excludedValues(E ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(this.convertToLiteral((Enum[])excluded)));
        this.negateOperator();
    }

    public void permittedRange(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeOperator(this.convertToLiteral(lowerBound), this.convertToLiteral(upperBound)));
    }

    public void permittedRangeInclusive(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(this.convertToLiteral(lowerBound), this.convertToLiteral(upperBound)));
    }

    public void permittedRangeExclusive(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(this.convertToLiteral(lowerBound), this.convertToLiteral(upperBound)));
    }

    public void excludedRange(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeOperator(this.convertToLiteral(lowerBound), this.convertToLiteral(upperBound)));
        this.negateOperator();
    }

    public void excludedRangeInclusive(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(this.convertToLiteral(lowerBound), this.convertToLiteral(upperBound)));
        this.negateOperator();
    }

    public void excludedRangeExclusive(E lowerBound, E upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(this.convertToLiteral(lowerBound), this.convertToLiteral(upperBound)));
        this.negateOperator();
    }

    public void permittedValues(Long ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void excludedValues(Long ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedRange(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void excludedRange(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void permittedValues(Integer ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void excludedValues(Integer ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedRange(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void excludedRange(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public Number numberValue() {
        if (this.literalValue == null) {
            return null;
        }
        if (this.literalValue instanceof Number) {
            return (Number)this.literalValue;
        }
        return Double.parseDouble(this.literalValue.toString());
    }

    @Override
    public Number getValue() {
        return this.numberValue();
    }
}

