/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.expressions.NumberResult;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeExclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeInclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedValuesOperator;

public class DBInteger
extends QueryableDatatype {
    private static final long serialVersionUID = 1L;

    public DBInteger(Object someNumber) {
        this(Long.parseLong(someNumber.toString()));
    }

    public DBInteger(int anInt) {
        this((Integer)anInt);
    }

    public DBInteger(Integer anInt) {
        super(anInt);
    }

    public DBInteger(long aLong) {
        this((Long)aLong);
    }

    public DBInteger(Long aLong) {
        super(aLong);
    }

    public DBInteger(NumberResult aLong) {
        super(aLong);
    }

    @Deprecated
    public DBInteger(double aDouble) {
        this(new Double(aDouble));
    }

    @Deprecated
    public DBInteger(Double aDouble) {
        this(aDouble == null ? null : Long.valueOf(aDouble.longValue()));
    }

    public DBInteger() {
    }

    @Override
    public String getSQLDatatype() {
        return "INTEGER";
    }

    @Override
    public void setFromResultSet(DBDatabase database, ResultSet resultSet, String fullColumnName) {
        this.blankQuery();
        if (resultSet == null || fullColumnName == null) {
            this.setToNull();
        } else {
            Long dbValue;
            try {
                dbValue = resultSet.getLong(fullColumnName);
                if (resultSet.wasNull()) {
                    dbValue = null;
                }
            }
            catch (SQLException ex) {
                dbValue = null;
            }
            if (dbValue == null) {
                this.setToNull();
            } else {
                this.setValue(dbValue);
            }
        }
        this.setUnchanged();
        this.setDefined(true);
    }

    @Override
    public Long getValue() {
        if (this.literalValue instanceof Long) {
            return (Long)this.literalValue;
        }
        if (this.literalValue == null) {
            return null;
        }
        return Long.parseLong(this.literalValue.toString());
    }

    @Override
    public Integer intValue() {
        Long value = this.getValue();
        return value == null ? null : Integer.valueOf(value.intValue());
    }

    @Override
    public Long longValue() {
        return this.getValue();
    }

    public void permittedValues(Long ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValues(NumberResult ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValues(Number ... permitted) {
        ArrayList<Long> ints = new ArrayList<Long>();
        for (Number dbint : permitted) {
            ints.add(dbint.longValue());
        }
        Long[] longArray = ints.toArray(new Long[0]);
        this.setOperator(new DBPermittedValuesOperator(longArray));
    }

    public void permittedValues(DBInteger ... permitted) {
        ArrayList<Long> ints = new ArrayList<Long>();
        for (DBInteger dbint : permitted) {
            ints.add(dbint.getValue());
        }
        Long[] longArray = ints.toArray(new Long[0]);
        this.setOperator(new DBPermittedValuesOperator(longArray));
    }

    public void permittedValues(DBNumber ... permitted) {
        ArrayList<Long> ints = new ArrayList<Long>();
        for (DBNumber dbint : permitted) {
            ints.add(dbint.getValue().longValue());
        }
        Long[] longArray = ints.toArray(new Long[0]);
        this.setOperator(new DBPermittedValuesOperator(longArray));
    }

    public void permittedValues(Collection<Long> permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValuesInteger(Collection<Integer> permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void permittedValues(Integer ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void excludedValues(Long ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void excludedValues(DBInteger ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void excludedValues(Integer ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void excludedValuesLong(List<Long> excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void excludedValuesInteger(List<Integer> excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedRange(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRange(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void excludedRange(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRange(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(Long lowerBound, Long upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(Integer lowerBound, Integer upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    @Override
    public void setValue(Object newLiteralValue) {
        if (newLiteralValue == null) {
            super.setLiteralValue(null);
        } else if (newLiteralValue.toString().isEmpty()) {
            super.setLiteralValue(null);
        } else {
            try {
                Long literalLong = Long.parseLong(newLiteralValue.toString());
                this.setLiteralValue(literalLong);
            }
            catch (NumberFormatException noFormat) {
                this.setLiteralValue(null);
            }
        }
    }

    public void setValue(DBNumber newLiteralValue) {
        this.setValue(newLiteralValue.getValue());
    }

    public void setValue(DBInteger newLiteralValue) {
        this.setValue(newLiteralValue.getValue());
    }

    public void setValue(Number newLiteralValue) {
        if (newLiteralValue == null) {
            super.setLiteralValue(null);
        } else {
            super.setLiteralValue(newLiteralValue);
        }
    }

    public void setValue(Long newLiteralValue) {
        if (newLiteralValue == null) {
            super.setLiteralValue(null);
        } else {
            super.setLiteralValue(newLiteralValue);
        }
    }

    public void setValue(Integer newLiteralValue) {
        if (newLiteralValue == null) {
            super.setLiteralValue(null);
        } else {
            super.setLiteralValue(newLiteralValue);
        }
    }

    @Override
    public String formatValueForSQLStatement(DBDatabase db) {
        DBDefinition defn = db.getDefinition();
        if (this.isNull()) {
            return defn.getNull();
        }
        return defn.beginNumberValue() + this.literalValue.toString() + defn.endNumberValue();
    }

    @Override
    public boolean isAggregator() {
        return false;
    }

    @Override
    public void blankQuery() {
        super.blankQuery();
    }
}

