/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.datatypes.DBEnumValue;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;

public abstract class DBEnum<E extends Enum<E>>
extends QueryableDatatype {
    private static final long serialVersionUID = 1L;
    private Class<E> enumType;

    public DBEnum() {
    }

    protected DBEnum(Object literalValue) {
        super(literalValue);
    }

    public DBEnum(E value) {
        this.enumType = value == null ? null : value.getClass();
        this.setLiteralValue(this.convertToLiteral(value));
    }

    public void setValue(E enumValue) {
        this.enumType = enumValue == null ? null : enumValue.getClass();
        super.setLiteralValue(this.convertToLiteral(enumValue));
    }

    protected abstract void validateLiteralValue(E var1);

    public E enumValue() {
        Enum[] enumValues;
        Object localValue = super.getValue();
        if (localValue == null) {
            return null;
        }
        for (Enum enumValue : enumValues = (Enum[])this.getEnumType().getEnumConstants()) {
            Object enumLiteralValue = ((DBEnumValue)((Object)enumValue)).getCode();
            if (!DBEnum.areLiteralValuesEqual(localValue, enumLiteralValue)) continue;
            return (E)enumValue;
        }
        throw new IncompatibleClassChangeError("Invalid literal value [" + localValue + "] encountered" + " when converting to enum type " + this.enumType.getName());
    }

    private static boolean areLiteralValuesEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null ^ o2 == null) {
            return false;
        }
        if (o1.getClass().isAssignableFrom(o2.getClass())) {
            return o2.equals(o1);
        }
        if (o2.getClass().isAssignableFrom(o1.getClass())) {
            return o1.equals(o2);
        }
        if (o1 instanceof Number && o2 instanceof Number && DBEnum.isRecognisedRealOrIntegerType((Number)o1) && DBEnum.isRecognisedRealOrIntegerType((Number)o2)) {
            Number n1 = (Number)o1;
            Number n2 = (Number)o2;
            Number v1 = null;
            Number v2 = null;
            if (n1 instanceof Double || n2 instanceof Double) {
                v1 = n1.doubleValue();
                v2 = n2.doubleValue();
            } else if (n1 instanceof Float || n2 instanceof Float) {
                v1 = Float.valueOf(n1.floatValue());
                v2 = Float.valueOf(n2.floatValue());
            } else if (n1 instanceof Long || n2 instanceof Long) {
                v1 = n1.longValue();
                v2 = n2.longValue();
            } else if (n1 instanceof Integer || n2 instanceof Integer) {
                v1 = n1.intValue();
                v2 = n2.intValue();
            } else if (n1 instanceof Short || n2 instanceof Short) {
                v1 = n1.shortValue();
                v2 = n2.shortValue();
            } else if (n1 instanceof Float || n2 instanceof Float) {
                v1 = Float.valueOf(n1.floatValue());
                v2 = Float.valueOf(n2.floatValue());
            }
            if (v1 != null && v2 != null) {
                return ((Object)v1).equals(v2);
            }
        }
        throw new IncompatibleClassChangeError("Unable to compare " + o1.getClass().getName() + " with " + o2.getClass().getName());
    }

    private static boolean isRecognisedRealOrIntegerType(Number n) {
        return n instanceof Double || n instanceof Float || n instanceof Short || n instanceof Long || n instanceof Integer || n instanceof Short;
    }

    private Class<E> getEnumType() {
        if (this.enumType == null) {
            if (this.propertyWrapper == null) {
                throw new IllegalStateException("Unable to convert literal value to enum: enum type unable to be inferred at this point. Row needs to be queried from database, or value set with an actual enum.");
            }
            Class<? extends Enum<?>> type = this.propertyWrapper.getEnumType();
            if (type == null) {
                throw new IllegalStateException("Unable to convert literal value to enum: enum type unable to be inferred at this point. Row needs to be queried from database, or value set with an actual enum, on " + this.propertyWrapper.qualifiedJavaName() + ".");
            }
            this.enumType = type;
        }
        return this.enumType;
    }

    @Override
    protected String formatValueForSQLStatement(DBDatabase db) {
        Object databaseValue = super.getValue();
        if (databaseValue == null) {
            return db.getDefinition().getNull();
        }
        QueryableDatatype qdt = QueryableDatatype.getQueryableDatatypeForObject(databaseValue);
        return qdt.formatValueForSQLStatement(db);
    }

    protected Object[] convertToLiteral(E ... enumValues) {
        Object[] result = new Object[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            E enumValue = enumValues[i];
            result[i] = this.convertToLiteral(enumValue);
        }
        return result;
    }

    protected final Object convertToLiteral(E enumValue) {
        if (enumValue == null || ((DBEnumValue)enumValue).getCode() == null) {
            return null;
        }
        this.validateLiteralValue(enumValue);
        Object newLiteralValue = ((DBEnumValue)enumValue).getCode();
        return newLiteralValue;
    }
}

