/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.expressions.DateExpression;
import nz.co.gregs.dbvolution.expressions.DateResult;
import nz.co.gregs.dbvolution.operators.DBLikeCaseInsensitiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeExclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeInclusiveOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedRangeOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedValuesOperator;

public class DBDate
extends QueryableDatatype
implements DateResult {
    private static final long serialVersionUID = 1L;

    public DBDate() {
    }

    public DBDate(java.util.Date date) {
        super(date);
    }

    public DBDate(DateResult dateExpression) {
        super(dateExpression);
    }

    DBDate(Timestamp timestamp) {
        super(timestamp);
        if (timestamp == null) {
            this.isDBNull = true;
        } else {
            java.util.Date date = new java.util.Date();
            date.setTime(timestamp.getTime());
            this.literalValue = date;
        }
    }

    DBDate(String str) {
        long dateLong = java.util.Date.parse(str);
        java.util.Date dateValue = new java.util.Date();
        dateValue.setTime(dateLong);
        this.literalValue = dateValue;
    }

    @Override
    public String getWhereClause(DBDatabase db, String columnName) {
        if (this.getOperator() instanceof DBLikeCaseInsensitiveOperator) {
            throw new RuntimeException("DATE COLUMNS CAN'T USE \"LIKE\": " + columnName);
        }
        return super.getWhereClause(db, columnName);
    }

    public java.util.Date dateValue() {
        if (this.literalValue instanceof java.util.Date) {
            return (java.util.Date)this.literalValue;
        }
        return null;
    }

    @Override
    public void setValue(Object newLiteralValue) {
        if (newLiteralValue instanceof java.util.Date) {
            this.setValue((java.util.Date)newLiteralValue);
        } else if (newLiteralValue instanceof DBDate) {
            this.setValue(((QueryableDatatype)newLiteralValue).literalValue);
        } else {
            throw new ClassCastException(this.getClass().getSimpleName() + ".setValue() Called With A Non-Date: Use only Dates with this class");
        }
    }

    public void setValue(java.util.Date date) {
        super.setLiteralValue(date);
    }

    public void setValue(String dateStr) {
        long dateLong = java.util.Date.parse(dateStr);
        java.util.Date date = new java.util.Date();
        date.setTime(dateLong);
        this.setValue(date);
    }

    @Override
    public String getSQLDatatype() {
        return "TIMESTAMP";
    }

    @Override
    public String toString() {
        if (this.isDBNull || this.dateValue() == null) {
            return "";
        }
        return this.dateValue().toString();
    }

    @Override
    public String formatValueForSQLStatement(DBDatabase db) {
        return db.getDefinition().getDateFormattedForQuery(this.dateValue());
    }

    @Override
    public void setFromResultSet(DBDatabase database, ResultSet resultSet, String fullColumnName) throws SQLException {
        this.blankQuery();
        if (resultSet == null || fullColumnName == null) {
            this.setToNull();
        } else {
            Date dbValue = database.getDefinition().prefersDatesReadAsStrings() ? this.setByGetString(database, resultSet, fullColumnName) : this.setByGetDate(database, resultSet, fullColumnName);
            if (dbValue == null) {
                this.setToNull();
            } else {
                this.setValue(dbValue);
            }
        }
        this.setUnchanged();
        this.setDefined(true);
    }

    private Date setByGetString(DBDatabase database, ResultSet resultSet, String fullColumnName) {
        String string = null;
        try {
            string = resultSet.getString(fullColumnName);
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
        }
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            return new Date(database.getDefinition().getDateGetStringFormat().parse(string).getTime());
        }
        catch (ParseException ex) {
            throw new DBRuntimeException("Unable To Parse Date: " + string, ex);
        }
    }

    private Date setByGetDate(DBDatabase database, ResultSet resultSet, String fullColumnName) {
        Date dbValue = null;
        try {
            long timestamp;
            Date timestampValue;
            Date dateValue = resultSet.getDate(fullColumnName);
            dbValue = resultSet.wasNull() ? null : ((timestampValue = new Date(timestamp = resultSet.getTimestamp(fullColumnName).getTime())).after(dateValue) ? timestampValue : dateValue);
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
        }
        return dbValue;
    }

    @Override
    public DBDate copy() {
        return (DBDate)super.copy();
    }

    @Override
    public java.util.Date getValue() {
        return this.dateValue();
    }

    @Override
    public DBDate getQueryableDatatypeForExpressionValue() {
        return new DBDate();
    }

    @Override
    public boolean isAggregator() {
        return false;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return new HashSet<DBRow>();
    }

    public void permittedValues(java.util.Date ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void excludedValues(java.util.Date ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedRange(java.util.Date lowerBound, java.util.Date upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(java.util.Date lowerBound, java.util.Date upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(java.util.Date lowerBound, java.util.Date upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void excludedRange(java.util.Date lowerBound, java.util.Date upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(java.util.Date lowerBound, java.util.Date upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(java.util.Date lowerBound, java.util.Date upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void permittedValues(DateExpression ... permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void excludedValues(DateExpression ... excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedRange(DateExpression lowerBound, DateExpression upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
    }

    public void permittedRangeInclusive(DateExpression lowerBound, DateExpression upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
    }

    public void permittedRangeExclusive(DateExpression lowerBound, DateExpression upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
    }

    public void excludedRange(DateExpression lowerBound, DateExpression upperBound) {
        this.setOperator(new DBPermittedRangeOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeInclusive(DateExpression lowerBound, DateExpression upperBound) {
        this.setOperator(new DBPermittedRangeInclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    public void excludedRangeExclusive(DateExpression lowerBound, DateExpression upperBound) {
        this.setOperator(new DBPermittedRangeExclusiveOperator(lowerBound, upperBound));
        this.negateOperator();
    }

    @Override
    public boolean getIncludesNull() {
        return this.dateValue() == null;
    }
}

