/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.util.HashSet;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBByteArray;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.datatypes.DBUnknownDatatype;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.expressions.BooleanExpression;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.expressions.DateExpression;
import nz.co.gregs.dbvolution.expressions.DateResult;
import nz.co.gregs.dbvolution.expressions.LargeObjectExpression;
import nz.co.gregs.dbvolution.expressions.NumberExpression;
import nz.co.gregs.dbvolution.expressions.NumberResult;
import nz.co.gregs.dbvolution.expressions.StringExpression;
import nz.co.gregs.dbvolution.expressions.StringResult;

public class DBDataGenerator
extends QueryableDatatype {
    public static final long serialVersionUID = 1L;

    public DBDataGenerator(DBExpression dataGenerator) {
        super(dataGenerator);
    }

    public DBDataGenerator() {
    }

    @Override
    public String getSQLDatatype() {
        if (this.literalValue instanceof DateResult) {
            return new DBDate().getSQLDatatype();
        }
        if (this.literalValue instanceof NumberResult) {
            return new DBNumber().getSQLDatatype();
        }
        if (this.literalValue instanceof StringResult) {
            return new DBString().getSQLDatatype();
        }
        return new DBUnknownDatatype().getSQLDatatype();
    }

    @Override
    protected String formatValueForSQLStatement(DBDatabase db) {
        return ((DBExpression)this.literalValue).toSQLString(db);
    }

    @Override
    public void setValue(Object newLiteralValue) {
        if (newLiteralValue instanceof DBExpression) {
            this.setValue((DBExpression)newLiteralValue);
        } else if (newLiteralValue instanceof DBDataGenerator) {
            this.setValue(((DBDataGenerator)newLiteralValue).literalValue);
        } else {
            throw new ClassCastException(this.getClass().getSimpleName() + ".setValue() Called With A " + newLiteralValue.getClass().getSimpleName() + ": Use only Dates with this class");
        }
    }

    public void setValue(DBExpression newLiteralValue) {
        this.setLiteralValue(newLiteralValue);
    }

    @Override
    public QueryableDatatype getQueryableDatatypeForExpressionValue() {
        if (this.literalValue instanceof DateExpression) {
            return new DBDate();
        }
        if (this.literalValue instanceof NumberExpression) {
            return new DBNumber();
        }
        if (this.literalValue instanceof StringExpression) {
            return new DBString();
        }
        if (this.literalValue instanceof BooleanExpression) {
            return new DBBoolean();
        }
        if (this.literalValue instanceof LargeObjectExpression) {
            return new DBByteArray();
        }
        return new DBUnknownDatatype();
    }

    @Override
    public boolean isAggregator() {
        return this.getValue().isAggregator();
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        HashSet<DBRow> hashSet = new HashSet<DBRow>();
        hashSet.addAll(((DBExpression)this.literalValue).getTablesInvolved());
        return hashSet;
    }

    @Override
    public DBExpression getValue() {
        return (DBExpression)this.literalValue;
    }
}

