/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBLargeObject;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import org.apache.commons.codec.binary.Base64;

public class DBByteArray
extends DBLargeObject {
    public static final long serialVersionUID = 1L;
    private InputStream byteStream = null;

    @Override
    public String getSQLDatatype() {
        return "BLOB";
    }

    public void setValue(byte[] byteArray) {
        super.setLiteralValue(byteArray);
        this.byteStream = new BufferedInputStream(new ByteArrayInputStream(byteArray));
    }

    public void setValue(InputStream inputViaStream) {
        super.setLiteralValue(inputViaStream);
        this.byteStream = new BufferedInputStream(inputViaStream);
    }

    public void setValue(File fileToRead) throws IOException {
        this.setValue(this.setFromFileSystem(fileToRead));
    }

    public void setValue(String string) {
        this.setValue(string.getBytes());
    }

    @Override
    public void setValue(Object newLiteralValue) {
        if (newLiteralValue instanceof byte[]) {
            this.setValue((byte[])newLiteralValue);
        } else if (newLiteralValue instanceof DBByteArray) {
            DBByteArray valBytes = (DBByteArray)newLiteralValue;
            this.setValue(valBytes.getValue());
        } else if (newLiteralValue instanceof String) {
            String valBytes = (String)newLiteralValue;
            this.setValue(valBytes.getBytes());
        } else {
            throw new ClassCastException(this.getClass().getSimpleName() + ".setValue() Called With A Non-Byte[]: Use only byte arrays with this class");
        }
    }

    @Override
    public void setFromResultSet(DBDatabase database, ResultSet resultSet, String fullColumnName) throws SQLException {
        this.blankQuery();
        DBDefinition defn = database.getDefinition();
        if (resultSet == null || fullColumnName == null) {
            this.setToNull();
        } else if (defn.prefersLargeObjectsReadAsBase64CharacterStream()) {
            try {
                this.setFromCharacterReader(resultSet, fullColumnName);
            }
            catch (IOException ex) {
                throw new DBRuntimeException("Unable To Set Value: " + ex.getMessage(), ex);
            }
        } else if (defn.prefersLargeObjectsReadAsBytes()) {
            this.setFromGetBytes(resultSet, fullColumnName);
        } else if (defn.prefersLargeObjectsReadAsCLOB()) {
            this.setFromCLOB(resultSet, fullColumnName);
        } else {
            this.setFromBinaryStream(resultSet, fullColumnName);
        }
        this.setUnchanged();
        this.setDefined(true);
    }

    private void setFromBinaryStream(ResultSet resultSet, String fullColumnName) throws SQLException {
        InputStream inputStream = resultSet.getBinaryStream(fullColumnName);
        if (resultSet.wasNull()) {
            inputStream = null;
        }
        if (inputStream == null) {
            this.setToNull();
        } else {
            BufferedInputStream input = new BufferedInputStream(inputStream);
            ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
            int totalBytesRead = 0;
            try {
                byte[] resultSetBytes = new byte[100000];
                int bytesRead = ((InputStream)input).read(resultSetBytes);
                while (bytesRead > 0) {
                    totalBytesRead += bytesRead;
                    byteArrays.add(resultSetBytes);
                    resultSetBytes = new byte[100000];
                    bytesRead = ((InputStream)input).read(resultSetBytes);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(DBByteArray.class.getName()).log(Level.SEVERE, null, ex);
            }
            byte[] bytes = new byte[totalBytesRead];
            int bytesAdded = 0;
            for (byte[] someBytes : byteArrays) {
                System.arraycopy(someBytes, 0, bytes, bytesAdded, Math.min(someBytes.length, bytes.length - bytesAdded));
                bytesAdded += someBytes.length;
            }
            this.setValue(bytes);
        }
    }

    private void setFromGetBytes(ResultSet resultSet, String fullColumnName) throws SQLException {
        byte[] bytes = resultSet.getBytes(fullColumnName);
        this.setValue(bytes);
    }

    private void setFromCharacterReader(ResultSet resultSet, String fullColumnName) throws SQLException, IOException {
        Reader inputReader = null;
        try {
            inputReader = resultSet.getCharacterStream(fullColumnName);
        }
        catch (NullPointerException nullEx) {
            // empty catch block
        }
        if (inputReader != null) {
            if (resultSet.wasNull() || inputReader == null) {
                this.setToNull();
            } else {
                BufferedReader input = new BufferedReader(inputReader);
                ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
                int totalBytesRead = 0;
                try {
                    char[] resultSetBytes = new char[100000];
                    int bytesRead = input.read(resultSetBytes);
                    while (bytesRead > 0) {
                        totalBytesRead += bytesRead;
                        byteArrays.add(String.valueOf(resultSetBytes).getBytes());
                        resultSetBytes = new char[100000];
                        bytesRead = input.read(resultSetBytes);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(DBByteArray.class.getName()).log(Level.SEVERE, null, ex);
                }
                byte[] bytes = new byte[totalBytesRead];
                int bytesAdded = 0;
                for (byte[] someBytes : byteArrays) {
                    System.arraycopy(someBytes, 0, bytes, bytesAdded, Math.min(someBytes.length, bytes.length - bytesAdded));
                    bytesAdded += someBytes.length;
                }
                byte[] decodeBuffer = Base64.decodeBase64((byte[])bytes);
                this.setValue(decodeBuffer);
            }
        }
    }

    private void setFromCLOB(ResultSet resultSet, String fullColumnName) throws SQLException {
        Clob clob = resultSet.getClob(fullColumnName);
        if (resultSet.wasNull() || clob == null) {
            this.setToNull();
        } else {
            BufferedReader input = new BufferedReader(clob.getCharacterStream());
            ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
            int totalBytesRead = 0;
            try {
                char[] resultSetBytes = new char[100000];
                int bytesRead = input.read(resultSetBytes);
                while (bytesRead > 0) {
                    totalBytesRead += bytesRead;
                    byteArrays.add(String.valueOf(resultSetBytes).getBytes());
                    resultSetBytes = new char[100000];
                    bytesRead = input.read(resultSetBytes);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(DBByteArray.class.getName()).log(Level.SEVERE, null, ex);
            }
            byte[] bytes = new byte[totalBytesRead];
            int bytesAdded = 0;
            for (byte[] someBytes : byteArrays) {
                System.arraycopy(someBytes, 0, bytes, bytesAdded, Math.min(someBytes.length, bytes.length - bytesAdded));
                bytesAdded += someBytes.length;
            }
            this.setValue(bytes);
        }
    }

    @Override
    public String formatValueForSQLStatement(DBDatabase db) {
        throw new UnsupportedOperationException("Binary datatypes like " + this.getClass().getSimpleName() + " do not have a simple SQL representation. Do not call getSQLValue(), use the getInputStream() method instead.");
    }

    public byte[] setFromFileSystem(String originalFile) throws FileNotFoundException, IOException {
        File file = new File(originalFile);
        return this.setFromFileSystem(file);
    }

    public byte[] setFromFileSystem(DBString originalFile) throws FileNotFoundException, IOException {
        File file = new File(originalFile.stringValue());
        return this.setFromFileSystem(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] setFromFileSystem(File originalFile) throws FileNotFoundException, IOException {
        System.out.println("FILE: " + originalFile.getAbsolutePath());
        byte[] bytes = new byte[(int)originalFile.length()];
        InputStream input = null;
        try {
            int totalBytesRead = 0;
            input = new BufferedInputStream(new FileInputStream(originalFile));
            while (totalBytesRead < bytes.length) {
                int bytesRemaining = bytes.length - totalBytesRead;
                int bytesRead = input.read(bytes, totalBytesRead, bytesRemaining);
                if (bytesRead <= 0) continue;
                totalBytesRead += bytesRead;
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        this.setValue(bytes);
        return bytes;
    }

    public void writeToFileSystem(String originalFile) throws FileNotFoundException, IOException {
        File file = new File(originalFile);
        this.writeToFileSystem(file);
    }

    public void writeToFileSystem(DBString originalFile) throws FileNotFoundException, IOException {
        this.writeToFileSystem(originalFile.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFileSystem(File originalFile) throws FileNotFoundException, IOException {
        if (this.literalValue != null && originalFile != null) {
            System.out.println("FILE: " + originalFile.getAbsolutePath());
            if (!originalFile.exists()) {
                originalFile.createNewFile();
            }
            OutputStream output = null;
            try {
                output = new BufferedOutputStream(new FileOutputStream(originalFile));
                output.write(this.getBytes());
                output.flush();
                output.close();
                output = null;
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        if (this.byteStream == null) {
            this.setValue(this.getBytes());
        }
        return this.byteStream;
    }

    public byte[] getBytes() {
        return (byte[])this.literalValue;
    }

    @Override
    public String stringValue() {
        byte[] value = this.getValue();
        if (this.isNull()) {
            return super.stringValue();
        }
        return new String(value);
    }

    @Override
    public int getSize() {
        return this.getBytes().length;
    }

    public byte[] getValue() {
        return this.getBytes();
    }

    @Override
    public DBByteArray getQueryableDatatypeForExpressionValue() {
        return new DBByteArray();
    }

    @Override
    public boolean isAggregator() {
        return false;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return new HashSet<DBRow>();
    }
}

