/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.datatypes;

import java.util.HashSet;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.expressions.BooleanExpression;
import nz.co.gregs.dbvolution.expressions.BooleanResult;
import nz.co.gregs.dbvolution.operators.DBBooleanPermittedValuesOperator;
import nz.co.gregs.dbvolution.operators.DBPermittedValuesOperator;

public class DBBoolean
extends QueryableDatatype
implements BooleanResult {
    private static final long serialVersionUID = 1L;

    public DBBoolean() {
    }

    public DBBoolean(Boolean bool) {
        super(bool);
    }

    public DBBoolean(BooleanResult bool) {
        super(bool);
    }

    @Override
    public String getSQLDatatype() {
        return "BIT(1)";
    }

    @Override
    public void setValue(Object newLiteralValue) {
        if (newLiteralValue instanceof Boolean) {
            this.setValue((Boolean)newLiteralValue);
        } else if (newLiteralValue instanceof DBBoolean) {
            this.setValue(((DBBoolean)newLiteralValue).getValue());
        } else {
            throw new ClassCastException(this.getClass().getSimpleName() + ".setValue() Called With A Non-Boolean: Use only Booleans with this class");
        }
    }

    public void setValue(Boolean newLiteralValue) {
        super.setLiteralValue(newLiteralValue);
    }

    @Override
    public String formatValueForSQLStatement(DBDatabase db) {
        DBDefinition defn = db.getDefinition();
        if (this.literalValue instanceof Boolean) {
            Boolean boolValue = (Boolean)this.literalValue;
            return defn.beginNumberValue() + (boolValue != false ? 1 : 0) + defn.endNumberValue();
        }
        return defn.getNull();
    }

    public Boolean booleanValue() {
        if (this.literalValue instanceof Boolean) {
            return (Boolean)this.literalValue;
        }
        return null;
    }

    @Override
    public DBBoolean copy() {
        return (DBBoolean)((BooleanResult)((Object)super.copy()));
    }

    @Override
    public Boolean getValue() {
        return this.booleanValue();
    }

    @Override
    public DBBoolean getQueryableDatatypeForExpressionValue() {
        return new DBBoolean();
    }

    @Override
    public boolean isAggregator() {
        return false;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        return new HashSet<DBRow>();
    }

    public void permittedValues(Boolean permitted) {
        this.setOperator(new DBBooleanPermittedValuesOperator(permitted));
    }

    public void excludedValues(Boolean excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    public void permittedValues(BooleanExpression permitted) {
        this.setOperator(new DBPermittedValuesOperator(permitted));
    }

    public void excludedValues(BooleanExpression excluded) {
        this.setOperator(new DBPermittedValuesOperator(excluded));
        this.negateOperator();
    }

    @Override
    public boolean getIncludesNull() {
        return false;
    }
}

