/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBInteger;
import nz.co.gregs.dbvolution.datatypes.DBLargeObject;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.generation.DBTableField;
import nz.co.gregs.dbvolution.query.QueryOptions;

public class SQLiteDefinition
extends DBDefinition {
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public String getDateFormattedForQuery(Date date) {
        return " DATETIME('" + DATETIME_FORMAT.format(date) + "') ";
    }

    @Override
    public boolean supportsGeneratedKeys(QueryOptions options) {
        return false;
    }

    @Override
    public String formatTableName(DBRow table) {
        return super.formatTableName(table).toUpperCase();
    }

    @Override
    public String getDropTableStart() {
        return super.getDropTableStart() + " IF EXISTS ";
    }

    @Override
    public boolean prefersTrailingPrimaryKeyDefinition() {
        return false;
    }

    @Override
    public String getColumnAutoIncrementSuffix() {
        return " PRIMARY KEY AUTOINCREMENT ";
    }

    @Override
    protected String getSQLTypeOfDBDatatype(QueryableDatatype qdt) {
        if (qdt instanceof DBLargeObject) {
            return " TEXT ";
        }
        if (qdt instanceof DBDate) {
            return " DATETIME ";
        }
        return super.getSQLTypeOfDBDatatype(qdt);
    }

    @Override
    public void sanityCheckDBTableField(DBTableField dbTableField) {
        if (dbTableField.isPrimaryKey && dbTableField.columnType.equals(DBInteger.class)) {
            dbTableField.isAutoIncrement = true;
        }
    }

    @Override
    public boolean prefersLargeObjectsReadAsBase64CharacterStream() {
        return true;
    }

    @Override
    public boolean prefersLargeObjectsSetAsBase64String() {
        return true;
    }

    @Override
    public String doSubstringTransform(String originalString, String start, String length) {
        return " SUBSTR(" + originalString + ", " + start + "," + length + ") ";
    }

    @Override
    public String getCurrentDateFunctionName() {
        return " DATETIME('now') ";
    }

    @Override
    public String getStringLengthFunctionName() {
        return "LENGTH";
    }

    @Override
    public String getTruncFunctionName() {
        return "TRUNC";
    }

    @Override
    public String getPositionFunction(String originalString, String stringToFind) {
        return "LOCATION_OF(" + originalString + ", " + stringToFind + ")";
    }

    @Override
    public String getCurrentUserFunctionName() {
        return "CURRENT_USER()";
    }

    @Override
    public String getStandardDeviationFunctionName() {
        return "STDEV";
    }

    @Override
    public String getMonthFunction(String dateExpression) {
        return " (CAST(strftime('%m', " + dateExpression + ") as INTEGER))";
    }

    @Override
    public String getYearFunction(String dateExpression) {
        return " (CAST(strftime('%Y', " + dateExpression + ") as INTEGER))";
    }

    @Override
    public String getDayFunction(String dateExpression) {
        return " (CAST(strftime('%d', " + dateExpression + ") as INTEGER))";
    }

    @Override
    public String getHourFunction(String dateExpression) {
        return " (CAST(strftime('%H', " + dateExpression + ") as INTEGER))";
    }

    @Override
    public String getMinuteFunction(String dateExpression) {
        return " (CAST(strftime('%M', " + dateExpression + ") as INTEGER))";
    }

    @Override
    public String getSecondFunction(String dateExpression) {
        return " (CAST(strftime('%S', " + dateExpression + ") as INTEGER))";
    }

    @Override
    public String getGreatestOfFunctionName() {
        return " MAX ";
    }

    @Override
    public String getLeastOfFunctionName() {
        return " MIN ";
    }

    @Override
    public boolean prefersDatesReadAsStrings() {
        return true;
    }

    @Override
    public DateFormat getDateGetStringFormat() {
        return DATETIME_FORMAT;
    }

    @Override
    public boolean supportsRetrievingLastInsertedRowViaSQL() {
        return true;
    }

    @Override
    public String getRetrieveLastInsertedRowSQL() {
        return "select last_insert_rowid();";
    }
}

