/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBByteArray;
import nz.co.gregs.dbvolution.datatypes.DBLargeObject;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;

public class PostgresDBDefinition
extends DBDefinition {
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public String getDateFormattedForQuery(Date date) {
        return "'" + DATETIME_FORMAT.format(date) + "'";
    }

    @Override
    public String getSQLTypeOfDBDatatype(QueryableDatatype qdt) {
        if (qdt instanceof DBByteArray) {
            return " BYTEA ";
        }
        if (qdt instanceof DBLargeObject) {
            return " BYTEA ";
        }
        return super.getSQLTypeOfDBDatatype(qdt);
    }

    @Override
    public Object getOrderByDirectionClause(Boolean sortOrder) {
        if (sortOrder == null) {
            return "";
        }
        if (sortOrder.booleanValue()) {
            return " ASC NULLS FIRST ";
        }
        return " DESC NULLS LAST ";
    }

    @Override
    public String doTruncTransform(String firstString, String secondString) {
        return this.getTruncFunctionName() + "((" + firstString + ")::numeric, " + secondString + ")";
    }

    @Override
    public String convertBitsToInteger(String columnName) {
        return columnName + "::integer";
    }

    @Override
    public String getColumnAutoIncrementSuffix() {
        return "";
    }

    @Override
    protected boolean hasSpecialAutoIncrementType() {
        return true;
    }

    @Override
    protected String getSpecialAutoIncrementType() {
        return " SERIAL ";
    }
}

