/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.text.SimpleDateFormat;
import java.util.Date;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.query.QueryOptions;
import nz.co.gregs.dbvolution.query.RowDefinition;

public class OracleDBDefinition
extends DBDefinition {
    String dateFormatStr = "yyyy-M-d HH:mm:ss Z";
    String oracleDateFormatStr = "YYYY-MM-DD HH24:MI:SS TZHTZM";
    SimpleDateFormat javaToStringFormatter = new SimpleDateFormat(this.dateFormatStr);

    @Override
    public String getDateFormattedForQuery(Date date) {
        if (date == null) {
            return this.getNull();
        }
        return " TO_TIMESTAMP_TZ('" + this.javaToStringFormatter.format(date) + "','" + this.oracleDateFormatStr + "') ";
    }

    @Override
    public String formatTableName(DBRow table) {
        String sqlObjectName = table.getTableName();
        return OracleDBDefinition.formatNameForOracle(sqlObjectName);
    }

    @Override
    public String getPrimaryKeySequenceName(String table, String column) {
        return OracleDBDefinition.formatNameForOracle(super.getPrimaryKeySequenceName(table, column));
    }

    @Override
    public String getPrimaryKeyTriggerName(String table, String column) {
        return OracleDBDefinition.formatNameForOracle(super.getPrimaryKeyTriggerName(table, column));
    }

    private static String formatNameForOracle(String sqlObjectName) {
        return ("O" + sqlObjectName.hashCode()).replaceAll("[_-]", "O");
    }

    @Override
    public String getTableAlias(RowDefinition tabRow) {
        return OracleDBDefinition.formatNameForOracle(super.getTableAlias(tabRow));
    }

    @Override
    public String beginTableAlias() {
        return " ";
    }

    @Override
    public String formatColumnName(String columnName) {
        return "" + columnName + "";
    }

    @Override
    public String getSQLTypeOfDBDatatype(QueryableDatatype qdt) {
        if (qdt instanceof DBBoolean) {
            return " NUMBER(1)";
        }
        if (qdt instanceof DBString) {
            return " VARCHAR2(1000) ";
        }
        if (qdt instanceof DBDate) {
            return " TIMESTAMP ";
        }
        return qdt.getSQLDatatype();
    }

    @Override
    public Object endSQLStatement() {
        return "";
    }

    @Override
    public String endInsertLine() {
        return "";
    }

    @Override
    public String endDeleteLine() {
        return "";
    }

    @Override
    public Object getLimitRowsSubClauseAfterWhereClause(QueryOptions options) {
        return "";
    }

    @Override
    public String getCurrentUserFunctionName() {
        return "USER";
    }

    @Override
    public String getPositionFunction(String originalString, String stringToFind) {
        return "INSTR(" + originalString + "," + stringToFind + ")";
    }

    @Override
    public String getIfNullFunctionName() {
        return "ISNULL";
    }

    @Override
    public boolean supportsPaging(QueryOptions options) {
        return false;
    }

    @Override
    public String getColumnAutoIncrementSuffix() {
        return "";
    }

    @Override
    public String getStringLengthFunctionName() {
        return "LENGTH";
    }

    @Override
    public String doSubstringTransform(String originalString, String start, String length) {
        return " SUBSTR(" + originalString + ", " + start + (length.trim().isEmpty() ? "" : ", " + length) + ") ";
    }

    @Override
    public boolean supportsRadiansFunction() {
        return false;
    }

    @Override
    public boolean supportsDegreesFunction() {
        return false;
    }
}

