/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.OracleDBDefinition;
import nz.co.gregs.dbvolution.query.QueryOptions;

public class Oracle11DBDefinition
extends OracleDBDefinition {
    @Override
    public Object getLimitRowsSubClauseDuringSelectClause(QueryOptions options) {
        return "/*+ FIRST_ROWS(" + options.getRowLimit() + ") */";
    }

    @Override
    public Object getLimitRowsSubClauseAfterWhereClause(QueryOptions options) {
        return "";
    }

    @Override
    public boolean supportsPaging(QueryOptions options) {
        return false;
    }

    @Override
    public String getColumnAutoIncrementSuffix() {
        return "";
    }

    @Override
    public boolean usesTriggerBasedIdentities() {
        return true;
    }

    @Override
    public List<String> getTriggerBasedIdentitySQL(DBDatabase DB, String table, String column) {
        ArrayList<String> result = new ArrayList<String>();
        String sequenceName = this.getPrimaryKeySequenceName(table, column);
        result.add("CREATE SEQUENCE " + sequenceName);
        String triggerName = this.getPrimaryKeyTriggerName(table, column);
        result.add("CREATE OR REPLACE TRIGGER " + DB.getUsername() + "." + triggerName + " \n" + "    BEFORE INSERT ON " + DB.getUsername() + "." + table + " \n" + "    FOR EACH ROW\n" + "    WHEN (new." + column + " IS NULL)\n" + "    BEGIN\n" + "      SELECT " + sequenceName + ".NEXTVAL\n" + "      INTO   :new." + column + "\n" + "      FROM   dual;\n" + "    END;\n");
        return result;
    }

    @Override
    public String getStringLengthFunctionName() {
        return "LENGTH";
    }

    @Override
    public String doSubstringTransform(String originalString, String start, String length) {
        return " SUBSTR(" + originalString + ", " + start + (length.trim().isEmpty() ? "" : ", " + length) + ") ";
    }
}

