/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBBoolean;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;

public class NuoDBDefinition
extends DBDefinition {
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    @Override
    public String getDateFormattedForQuery(Date date) {
        return " DATE_FROM_STR('" + DATETIME_FORMAT.format(date) + "', 'dd/MM/yyyy HH:mm:ss') ";
    }

    @Override
    protected String getSQLTypeOfDBDatatype(QueryableDatatype qdt) {
        if (qdt instanceof DBBoolean) {
            return " boolean ";
        }
        if (qdt instanceof DBDate) {
            return " TIMESTAMP(0) ";
        }
        return qdt.getSQLDatatype();
    }

    @Override
    public String doTruncTransform(String firstString, String secondString) {
        return "" + firstString + "-MOD(" + firstString + ",1*(" + firstString + "/ABS(" + firstString + ")))";
    }

    @Override
    public boolean supportsExpFunction() {
        return false;
    }

    @Override
    public String getCurrentUserFunctionName() {
        return "USER()";
    }

    @Override
    public boolean supportsStandardDeviationFunction() {
        return false;
    }

    @Override
    public boolean supportsLeftTrimFunction() {
        return false;
    }

    @Override
    @Deprecated
    public String doLeftTrimFunction(String toSQLString) {
        return " ((" + toSQLString + ") not like '% ') and LTRIM(" + toSQLString + ")";
    }
}

