/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.DBByteArray;
import nz.co.gregs.dbvolution.datatypes.DBDate;
import nz.co.gregs.dbvolution.datatypes.DBLargeObject;
import nz.co.gregs.dbvolution.datatypes.DBString;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;

public class MariaDBDefinition
extends DBDefinition {
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("dd,MM,yyyy HH:mm:ss");

    @Override
    public String getDateFormattedForQuery(Date date) {
        return " STR_TO_DATE('" + DATETIME_FORMAT.format(date) + "', '%d,%m,%Y %H:%i:%s') ";
    }

    @Override
    public String getEqualsComparator() {
        return " = ";
    }

    @Override
    public String getNotEqualsComparator() {
        return " <> ";
    }

    @Override
    public String getSQLTypeOfDBDatatype(QueryableDatatype qdt) {
        if (qdt instanceof DBString) {
            return " VARCHAR(1000) CHARACTER SET utf8 COLLATE utf8_bin ";
        }
        if (qdt instanceof DBDate) {
            return " DATETIME ";
        }
        if (qdt instanceof DBByteArray) {
            return " LONGBLOB ";
        }
        if (qdt instanceof DBLargeObject) {
            return " LONGBLOB ";
        }
        return qdt.getSQLDatatype();
    }

    @Override
    public String doConcatTransform(String firstString, String secondString) {
        return " CONCAT(" + firstString + ", " + secondString + ") ";
    }

    @Override
    public String getTruncFunctionName() {
        return "truncate";
    }

    @Override
    public String doStringEqualsTransform(String firstString, String secondString) {
        return "(" + firstString + " = binary " + secondString + ")";
    }

    @Override
    public String getColumnAutoIncrementSuffix() {
        return " AUTO_INCREMENT ";
    }
}

