/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.query.QueryOptions;

public class MSSQLServerDBDefinition
extends DBDefinition {
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public String getDateFormattedForQuery(Date date) {
        return "'" + DATETIME_FORMAT.format(date) + "'";
    }

    @Override
    public String formatTableName(DBRow table) {
        return "[" + table.getTableName() + "]";
    }

    @Override
    public Object endSQLStatement() {
        return "";
    }

    @Override
    public Object getLimitRowsSubClauseDuringSelectClause(QueryOptions options) {
        return " TOP(" + options.getRowLimit() + ") ";
    }

    @Override
    public Object getLimitRowsSubClauseAfterWhereClause(QueryOptions options) {
        return "";
    }

    @Override
    public String doTrimFunction(String enclosedValue) {
        return " LTRIM(RTRIM(" + enclosedValue + ")) ";
    }

    @Override
    public String doConcatTransform(String firstString, String secondString) {
        return firstString + "+" + secondString;
    }

    @Override
    public String getIfNullFunctionName() {
        return "ISNULL";
    }

    @Override
    public String getStandardDeviationFunctionName() {
        return "STDEV";
    }

    @Override
    public boolean supportsPaging(QueryOptions options) {
        return false;
    }

    @Override
    public String getColumnAutoIncrementSuffix() {
        return " IDENTITY ";
    }
}

