/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.text.SimpleDateFormat;
import java.util.Date;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.query.QueryOptions;

public class InformixDBDefinition
extends DBDefinition {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public String informixDateFormat = "%Y-%m-%d %H:%M:%S";

    @Override
    public boolean prefersIndexBasedGroupByClause() {
        return true;
    }

    @Override
    public boolean prefersIndexBasedOrderByClause() {
        return true;
    }

    @Override
    public String getDateFormattedForQuery(Date date) {
        return "TO_DATE('" + this.dateFormat.format(date) + "','" + this.informixDateFormat + "')";
    }

    @Override
    public String formatTableAndColumnName(DBRow table, String columnName) {
        return "" + this.formatTableName(table) + "." + this.formatColumnName(columnName) + "";
    }

    @Override
    public Object getLimitRowsSubClauseDuringSelectClause(QueryOptions options) {
        int rowLimit = options.getRowLimit();
        Integer pageNumber = options.getPageIndex();
        if (rowLimit < 1) {
            return "";
        }
        if (this.supportsPaging(options)) {
            long offset = pageNumber * rowLimit;
            if (offset > 0L) {
                return " SKIP " + offset + " FIRST " + rowLimit + " ";
            }
            return " FIRST " + rowLimit + " ";
        }
        return " FIRST " + rowLimit + " ";
    }

    @Override
    public Object getLimitRowsSubClauseAfterWhereClause(QueryOptions options) {
        return "";
    }

    @Override
    public String getCurrentDateFunctionName() {
        return " current ";
    }

    @Override
    public String getDayFunction(String dateExpression) {
        return "DAY(" + dateExpression + ")";
    }

    @Override
    public String getMonthFunction(String dateExpression) {
        return "MONTH(" + dateExpression + ")";
    }

    @Override
    public String getYearFunction(String dateExpression) {
        return "YEAR(" + dateExpression + ")";
    }

    @Override
    public boolean supportsPaging(QueryOptions options) {
        return false;
    }

    @Override
    public boolean supportsGeneratedKeys(QueryOptions options) {
        return false;
    }
}

