/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.text.SimpleDateFormat;
import java.util.Date;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;

public class H2DBDefinition
extends DBDefinition {
    String dateFormatStr = "yyyy-M-d hh:mm:ss";
    String h2DateFormatStr = "yyyy-M-d HH:mm:ss";
    SimpleDateFormat strToDateFormat = new SimpleDateFormat(this.dateFormatStr);

    @Override
    public String getDateFormattedForQuery(Date date) {
        if (date == null) {
            return this.getNull();
        }
        return " PARSEDATETIME('" + this.strToDateFormat.format(date) + "','" + this.h2DateFormatStr + "') ";
    }

    @Override
    public String formatTableName(DBRow table) {
        return table.getTableName().toUpperCase();
    }

    @Override
    public String formatColumnName(String columnName) {
        return columnName.toUpperCase();
    }
}

