/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases.definitions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.DBInteger;
import nz.co.gregs.dbvolution.datatypes.DBNumber;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.AutoIncrementFieldClassAndDatatypeMismatch;
import nz.co.gregs.dbvolution.generation.DBTableField;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.query.QueryOptions;
import nz.co.gregs.dbvolution.query.RowDefinition;

public abstract class DBDefinition {
    public abstract String getDateFormattedForQuery(Date var1);

    public String formatColumnName(String columnName) {
        return columnName;
    }

    public String beginStringValue() {
        return "'";
    }

    public String endStringValue() {
        return "'";
    }

    public String beginNumberValue() {
        return "";
    }

    public String endNumberValue() {
        return "";
    }

    public String formatTableAndColumnName(DBRow table, String columnName) {
        return this.formatTableName(table) + "." + this.formatColumnName(columnName);
    }

    public String formatTableAliasAndColumnName(RowDefinition table, String columnName) {
        return this.getTableAlias(table) + "." + this.formatColumnName(columnName);
    }

    public String formatTableAliasAndColumnNameForSelectClause(DBRow table, String columnName) {
        String tableAliasAndColumn = this.formatTableAliasAndColumnName(table, columnName);
        return tableAliasAndColumn + " " + this.formatForColumnAlias(tableAliasAndColumn);
    }

    public String formatTableName(DBRow table) {
        return table.getTableName();
    }

    public String formatColumnNameForDBQueryResultSet(RowDefinition table, String columnName) {
        String actualName = this.formatTableAliasAndColumnName(table, columnName);
        return this.formatForColumnAlias(actualName);
    }

    public String formatForColumnAlias(String actualName) {
        String formattedName = actualName.replaceAll("\\.", "__");
        return ("DB" + formattedName.hashCode()).replaceAll("-", "_");
    }

    public String safeString(String toString) {
        return toString.replaceAll("'", "''");
    }

    public String beginWhereClauseLine() {
        return this.beginAndLine();
    }

    public String beginConditionClauseLine(QueryOptions options) {
        if (options.isMatchAllConditions()) {
            return this.beginAndLine();
        }
        return this.beginOrLine();
    }

    public String beginJoinClauseLine(QueryOptions options) {
        if (options.isMatchAllRelationships()) {
            return this.beginAndLine();
        }
        return this.beginOrLine();
    }

    public boolean prefersIndexBasedGroupByClause() {
        return false;
    }

    public String beginAndLine() {
        return " AND ";
    }

    public String beginOrLine() {
        return " OR ";
    }

    public String getDropTableStart() {
        return "DROP TABLE ";
    }

    public String getCreateTablePrimaryKeyClauseStart() {
        return ",PRIMARY KEY (";
    }

    public String getCreateTablePrimaryKeyClauseMiddle() {
        return ", ";
    }

    public String getCreateTablePrimaryKeyClauseEnd() {
        return ")";
    }

    public String getCreateTableStart() {
        return "CREATE TABLE ";
    }

    public String getCreateTableColumnsStart() {
        return "(";
    }

    public String getCreateTableColumnsSeparator() {
        return ", ";
    }

    public String getCreateTableColumnsNameAndTypeSeparator() {
        return " ";
    }

    public Object getCreateTableColumnsEnd() {
        return ")";
    }

    public String toLowerCase(String sql) {
        return " lower(" + sql + ")";
    }

    public String beginInsertLine() {
        return "INSERT INTO ";
    }

    public String endInsertLine() {
        return ";";
    }

    public String beginInsertColumnList() {
        return "(";
    }

    public String endInsertColumnList() {
        return ") ";
    }

    public String beginDeleteLine() {
        return "DELETE FROM ";
    }

    public String endDeleteLine() {
        return ";";
    }

    public String getEqualsComparator() {
        return " = ";
    }

    public String getNotEqualsComparator() {
        return " <> ";
    }

    public String beginWhereClause() {
        return " WHERE ";
    }

    public String beginUpdateLine() {
        return "UPDATE ";
    }

    public String beginSetClause() {
        return " SET ";
    }

    public String getStartingSetSubClauseSeparator() {
        return "";
    }

    public String getSubsequentSetSubClauseSeparator() {
        return ",";
    }

    public String getStartingOrderByClauseSeparator() {
        return "";
    }

    public String getSubsequentOrderByClauseSeparator() {
        return ",";
    }

    public String getWhereClauseBeginningCondition() {
        return this.getTrueOperation();
    }

    public String getWhereClauseBeginningCondition(QueryOptions options) {
        if (options.isMatchAllConditions()) {
            return this.getTrueOperation();
        }
        return this.getFalseOperation();
    }

    public String getFalseOperation() {
        return " 1=0 ";
    }

    public String getTrueOperation() {
        return " 1=1 ";
    }

    public String getNull() {
        return " NULL ";
    }

    public String beginSelectStatement() {
        return " SELECT ";
    }

    public String beginFromClause() {
        return " FROM ";
    }

    public Object endSQLStatement() {
        return ";";
    }

    public String getStartingSelectSubClauseSeparator() {
        return "";
    }

    public String getSubsequentSelectSubClauseSeparator() {
        return ",";
    }

    public String countStarClause() {
        return " COUNT(*) ";
    }

    public Object getLimitRowsSubClauseDuringSelectClause(QueryOptions options) {
        return "";
    }

    public String beginOrderByClause() {
        return " ORDER BY ";
    }

    public String endOrderByClause() {
        return " ";
    }

    public Object getOrderByDirectionClause(Boolean sortOrder) {
        if (sortOrder == null) {
            return "";
        }
        if (sortOrder.booleanValue()) {
            return " ASC ";
        }
        return " DESC ";
    }

    public String getStartingJoinOperationSeparator() {
        return "";
    }

    public String getSubsequentJoinOperationSeparator(QueryOptions options) {
        return this.beginConditionClauseLine(options);
    }

    public String beginInnerJoin() {
        return " INNER JOIN ";
    }

    public String beginLeftOuterJoin() {
        return " LEFT OUTER JOIN ";
    }

    public String beginFullOuterJoin() {
        return " FULL OUTER JOIN ";
    }

    public String beginOnClause() {
        return " ON( ";
    }

    public String endOnClause() {
        return " ) ";
    }

    public final String getSQLTypeOfDBDatatype(PropertyWrapper field) {
        return this.getSQLTypeOfDBDatatype((QueryableDatatype)field.getQueryableDatatype());
    }

    protected String getSQLTypeOfDBDatatype(QueryableDatatype qdt) {
        return qdt.getSQLDatatype();
    }

    public Object getLimitRowsSubClauseAfterWhereClause(QueryOptions options) {
        int rowLimit = options.getRowLimit();
        Integer pageNumber = options.getPageIndex();
        if (rowLimit < 1) {
            return "";
        }
        long offset = pageNumber * rowLimit;
        return "LIMIT " + rowLimit + " OFFSET " + offset;
    }

    public String getPreparedVariableSymbol() {
        return " ? ";
    }

    public boolean isColumnNamesCaseSensitive() {
        return false;
    }

    public String startMultilineComment() {
        return "/*";
    }

    public String endMultilineComment() {
        return "*/";
    }

    public String beginValueClause() {
        return " VALUES ( ";
    }

    public Object endValueClause() {
        return ")";
    }

    public String getValuesClauseValueSeparator() {
        return ",";
    }

    public String getValuesClauseColumnSeparator() {
        return ",";
    }

    public String beginTableAlias() {
        return " AS ";
    }

    public String endTableAlias() {
        return " ";
    }

    public String getTableAlias(RowDefinition tabRow) {
        return ("_" + tabRow.getClass().getSimpleName().hashCode()).replaceAll("-", "_");
    }

    public String getCurrentDateFunctionName() {
        return " CURRENT_DATE ";
    }

    public String getCurrentTimestampFunction() {
        return " CURRENT_TIMESTAMP ";
    }

    public String getCurrentTimeFunction() {
        return " CURRENT_TIMESTAMP ";
    }

    @Deprecated
    public String getCurrentUserFunction() {
        return " CURRENT_USER ";
    }

    public String getDropDatabase(String databaseName) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("DROP DATABASE is not supported by this DBDatabase implementation");
    }

    public String doLeftTrimTransform(String enclosedValue) {
        return " LTRIM(" + enclosedValue + ") ";
    }

    public String doLowercaseTransform(String enclosedValue) {
        return " LOWER(" + enclosedValue + ") ";
    }

    public String doRightTrimTransform(String enclosedValue) {
        return " RTRIM(" + enclosedValue + " )";
    }

    public String doStringLengthTransform(String enclosedValue) {
        return " CHAR_LENGTH( " + enclosedValue + " ) ";
    }

    public String doTrimFunction(String enclosedValue) {
        return " TRIM(" + enclosedValue + ") ";
    }

    public String doUppercaseTransform(String enclosedValue) {
        return " UPPER(" + enclosedValue + ") ";
    }

    public String doConcatTransform(String firstString, String secondString) {
        return firstString + "||" + secondString;
    }

    public String getNextSequenceValueFunctionName() {
        return " NEXTVAL";
    }

    public String getConcatOperator() {
        return "||";
    }

    public String getReplaceFunctionName() {
        return "REPLACE";
    }

    public String getLeftTrimFunctionName() {
        return "LTRIM";
    }

    public String getRightTrimFunctionName() {
        return "RTRIM";
    }

    public String getLowercaseFunctionName() {
        return "LOWER";
    }

    public String getUppercaseFunctionName() {
        return "UPPER";
    }

    public String getStringLengthFunctionName() {
        return "CHAR_LENGTH";
    }

    public String getCurrentUserFunctionName() {
        return "CURRENT_USER";
    }

    public String getYearFunction(String dateExpression) {
        return "EXTRACT(YEAR FROM " + dateExpression + ")";
    }

    public String getMonthFunction(String dateExpression) {
        return "EXTRACT(MONTH FROM " + dateExpression + ")";
    }

    public String getDayFunction(String dateExpression) {
        return "EXTRACT(DAY FROM " + dateExpression + ")";
    }

    public String getHourFunction(String dateExpression) {
        return "EXTRACT(HOUR FROM " + dateExpression + ")";
    }

    public String getMinuteFunction(String dateExpression) {
        return "EXTRACT(MINUTE FROM " + dateExpression + ")";
    }

    public String getSecondFunction(String dateExpression) {
        return "EXTRACT(SECOND FROM " + dateExpression + ")";
    }

    public String getPositionFunction(String originalString, String stringToFind) {
        return "POSITION(" + stringToFind + " IN " + originalString + ")";
    }

    public String formatExpressionAlias(Object key) {
        return ("DB" + key.hashCode()).replaceAll("-", "_");
    }

    public String getIfNullFunctionName() {
        return "COALESCE";
    }

    public String getNegationFunctionName() {
        return "NOT";
    }

    public String getSubsequentGroupBySubClauseSeparator() {
        return ", ";
    }

    public String beginGroupByClause() {
        return " GROUP BY ";
    }

    public String getAverageFunctionName() {
        return "AVG";
    }

    public String getCountFunctionName() {
        return "COUNT";
    }

    public String getMaxFunctionName() {
        return "MAX";
    }

    public String getMinFunctionName() {
        return "MIN";
    }

    public String getSumFunctionName() {
        return "SUM";
    }

    public String getStandardDeviationFunctionName() {
        return "stddev";
    }

    public boolean prefersIndexBasedOrderByClause() {
        return false;
    }

    public boolean supportsPaging(QueryOptions options) {
        return true;
    }

    public boolean supportsGeneratedKeys(QueryOptions options) {
        return true;
    }

    public String getTruncFunctionName() {
        return "trunc";
    }

    public String doTruncTransform(String firstString, String secondString) {
        return this.getTruncFunctionName() + "(" + firstString + ", " + secondString + ")";
    }

    public String doStringEqualsTransform(String firstString, String secondString) {
        return firstString + " = " + secondString;
    }

    public boolean prefersConditionsInWHEREClause() {
        return true;
    }

    public String beginReturningClause(DBRow row) {
        return "";
    }

    public String convertBitsToInteger(String columnName) {
        return columnName;
    }

    public String getColumnAutoIncrementSuffix() {
        return " GENERATED BY DEFAULT AS IDENTITY ";
    }

    public boolean usesTriggerBasedIdentities() {
        return false;
    }

    public List<String> getTriggerBasedIdentitySQL(DBDatabase db, String table, String column) {
        return new ArrayList<String>();
    }

    public Object getSQLTypeAndModifiersOfDBDatatype(PropertyWrapper field) {
        if (field.isAutoIncrement()) {
            if (this.propertyWrapperConformsToAutoIncrementType(field)) {
                if (this.hasSpecialAutoIncrementType()) {
                    return this.getSpecialAutoIncrementType();
                }
                return this.getSQLTypeOfDBDatatype(field) + this.getColumnAutoIncrementSuffix();
            }
            throw new AutoIncrementFieldClassAndDatatypeMismatch(field);
        }
        return this.getSQLTypeOfDBDatatype(field);
    }

    public String getPrimaryKeySequenceName(String table, String column) {
        return table + "_" + column + "dsq";
    }

    public String getPrimaryKeyTriggerName(String table, String column) {
        return table + "_" + column + "dtg";
    }

    protected boolean hasSpecialAutoIncrementType() {
        return false;
    }

    protected boolean propertyWrapperConformsToAutoIncrementType(PropertyWrapper field) {
        Object qdt = field.getQueryableDatatype();
        return qdt instanceof DBNumber || qdt instanceof DBInteger;
    }

    protected String getSpecialAutoIncrementType() {
        return "";
    }

    public boolean prefersTrailingPrimaryKeyDefinition() {
        return true;
    }

    public boolean prefersLargeObjectsReadAsBase64CharacterStream() {
        return false;
    }

    public boolean prefersLargeObjectsReadAsBytes() {
        return false;
    }

    public boolean prefersLargeObjectsReadAsCLOB() {
        return false;
    }

    public String doSubstringTransform(String originalString, String start, String length) {
        return " SUBSTRING(" + originalString + " FROM " + start + (length.trim().isEmpty() ? "" : " FOR " + length) + ") ";
    }

    public boolean prefersLargeObjectsSetAsCharacterStream() {
        return false;
    }

    public boolean prefersLargeObjectsSetAsBase64String() {
        return false;
    }

    public String getGreatestOfFunctionName() {
        return " GREATEST ";
    }

    public String getLeastOfFunctionName() {
        return " LEAST ";
    }

    public boolean prefersDatesReadAsStrings() {
        return false;
    }

    public DateFormat getDateGetStringFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public void sanityCheckDBTableField(DBTableField dbTableField) {
    }

    public boolean supportsRetrievingLastInsertedRowViaSQL() {
        return false;
    }

    public String getRetrieveLastInsertedRowSQL() {
        return "";
    }

    public String getEmptyString() {
        return this.beginStringValue() + this.endStringValue();
    }

    public boolean supportsDegreesFunction() {
        return true;
    }

    public boolean supportsRadiansFunction() {
        return true;
    }

    public String doRadiansTransform(String degreesSQL) {
        return " (" + degreesSQL + ") * 0.0174532925 ";
    }

    public String doDegreesTransform(String radiansSQL) {
        return " " + radiansSQL + " * 57.2957795 ";
    }

    public String getExpFunctionName() {
        return "EXP";
    }

    public boolean supportsExpFunction() {
        return true;
    }

    public boolean supportsStandardDeviationFunction() {
        return true;
    }

    public boolean supportsLeftTrimFunction() {
        return true;
    }

    public String doLeftTrimFunction(String toSQLString) {
        return "LTRIM(" + toSQLString + ")";
    }
}

