/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.SQLiteDefinition;
import org.sqlite.Function;
import org.sqlite.SQLiteConfig;

public class SQLiteDB
extends DBDatabase {
    private static final String SQLITE_DRIVER_NAME = "org.sqlite.JDBC";

    public SQLiteDB(DataSource ds) {
        super(new SQLiteDefinition(), ds);
    }

    public SQLiteDB(String jdbcURL, String username, String password) {
        super(new SQLiteDefinition(), SQLITE_DRIVER_NAME, jdbcURL, username, password);
    }

    @Override
    protected boolean supportsFullOuterJoinNatively() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoin() {
        return false;
    }

    @Override
    protected Connection getConnectionFromDriverManager() throws SQLException {
        SQLiteConfig config = new SQLiteConfig();
        config.enableCaseSensitiveLike(true);
        Connection connection = DriverManager.getConnection(this.getJdbcURL(), this.getUsername(), this.getPassword());
        config.apply(connection);
        Function.create((Connection)connection, (String)"TRUNC", (Function)new Trunc());
        Function.create((Connection)connection, (String)"LOCATION_OF", (Function)new LocationOf());
        Function.create((Connection)connection, (String)"CURRENT_USER", (Function)new CurrentUser(this.getUsername()));
        Function.create((Connection)connection, (String)"STDEV", (Function)new StandardDeviation());
        return connection;
    }

    @Override
    public DBDatabase clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class StandardDeviation
    extends Function.Aggregate {
        private final List<Long> longs = new ArrayList<Long>();

        private StandardDeviation() {
        }

        protected void xStep() throws SQLException {
            Long longValue = this.value_long(0);
            this.longs.add(longValue);
        }

        protected void xFinal() throws SQLException {
            double sum = 0.0;
            for (Long long1 : this.longs) {
                sum += (double)long1.longValue();
            }
            Double mean = sum / (double)this.longs.size();
            ArrayList<Double> squaredDistances = new ArrayList<Double>();
            for (Long long1 : this.longs) {
                double dist = mean - (double)long1.longValue();
                squaredDistances.add(dist * dist);
            }
            for (Double dist : squaredDistances) {
                sum += dist.doubleValue();
            }
            double variance = sum / (double)squaredDistances.size();
            this.result(Math.sqrt(variance));
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    private static class CurrentUser
    extends Function {
        private final String currentUser;

        public CurrentUser(String currentUser) {
            this.currentUser = currentUser;
        }

        protected void xFunc() throws SQLException {
            this.result(this.currentUser);
        }
    }

    private static class LocationOf
    extends Function {
        private LocationOf() {
        }

        protected void xFunc() throws SQLException {
            String original = this.value_text(0);
            String find = this.value_text(1);
            this.result(original.indexOf(find) + 1);
        }
    }

    private static class Trunc
    extends Function {
        private Trunc() {
        }

        protected void xFunc() throws SQLException {
            Double original = this.value_double(0);
            this.result(original.longValue());
        }
    }
}

