/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.databases.OracleDB;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.databases.definitions.Oracle11DBDefinition;

public class Oracle11DB
extends OracleDB {
    public Oracle11DB(DataSource dataSource) {
        super(new Oracle11DBDefinition(), dataSource);
    }

    public Oracle11DB(DBDefinition definition, String driverName, String jdbcURL, String username, String password) {
        super(definition, driverName, jdbcURL, username, password);
    }

    public Oracle11DB(String driverName, String jdbcURL, String username, String password) {
        super(new Oracle11DBDefinition(), driverName, jdbcURL, username, password);
    }

    public Oracle11DB(String jdbcURL, String username, String password) {
        super(new Oracle11DBDefinition(), "oracle.jdbc.driver.OracleDriver", jdbcURL, username, password);
    }

    public Oracle11DB(String host, int port, String serviceName, String username, String password) {
        super(new Oracle11DBDefinition(), "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@//" + host + ":" + port + "/" + serviceName, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <TR extends DBRow> void dropAnyAssociatedDatabaseObjects(TR tableRow) throws SQLException {
        if (tableRow.getPrimaryKey() != null) {
            DBDefinition definition = this.getDefinition();
            DBStatement dbStatement = this.getDBStatement();
            String formattedTableName = definition.formatTableName(tableRow);
            String formattedColumnName = definition.formatColumnName(tableRow.getPrimaryKeyColumnName());
            try {
                dbStatement.execute("DROP SEQUENCE " + definition.getPrimaryKeySequenceName(formattedTableName, formattedColumnName));
            }
            finally {
                dbStatement.close();
            }
            DBStatement dbStatement2 = this.getDBStatement();
            try {
                dbStatement2.execute("DROP TRIGGER " + definition.getPrimaryKeyTriggerName(formattedTableName, formattedColumnName));
            }
            finally {
                dbStatement2.close();
            }
        }
    }

    @Override
    public DBDatabase clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    protected Connection getConnectionFromDriverManager() throws SQLException {
        return super.getConnectionFromDriverManager();
    }
}

