/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases;

import java.util.List;
import javax.sql.DataSource;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.NuoDBDefinition;

public class NuoDB
extends DBDatabase {
    private static final int NUODB_DEFAULT_PORT = 48004;
    private static final String NUODB_DRIVER = "com.nuodb.jdbc.Driver";
    private static final String NUODB_URL_PREFIX = "jdbc:com.nuodb://";

    @Override
    public DBDatabase clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public NuoDB(DataSource ds) {
        super(new NuoDBDefinition(), ds);
    }

    public NuoDB(List<String> brokers, String databaseName, String schema, String username, String password) {
        String hosts = "";
        String sep = "";
        for (String server : brokers) {
            int port = 48004;
            hosts = hosts + sep + server + ":" + port;
            sep = ",";
        }
        this.setDriverName(NUODB_DRIVER);
        this.setDefinition(new NuoDBDefinition());
        this.setJdbcURL(NUODB_URL_PREFIX + hosts + "/" + databaseName + "?schema=" + schema);
        this.setUsername(username);
        this.setPassword(password);
        this.setDatabaseName(databaseName);
    }

    public NuoDB(List<String> brokers, List<Long> ports, String databaseName, String schema, String username, String password) {
        String hosts = "";
        String sep = "";
        if (brokers.size() == ports.size()) {
            for (int i = 0; i < brokers.size(); ++i) {
                String server = brokers.get(i);
                Long port = ports.get(i);
                hosts = hosts + sep + server + ":" + port;
                sep = ",";
            }
        }
        this.setDriverName(NUODB_DRIVER);
        this.setDefinition(new NuoDBDefinition());
        this.setJdbcURL(NUODB_URL_PREFIX + hosts + "/" + databaseName + "?schema=" + schema);
        this.setUsername(username);
        this.setPassword(password);
        this.setDatabaseName(databaseName);
    }

    @Override
    protected boolean supportsFullOuterJoinNatively() {
        return false;
    }
}

