/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases;

import java.util.List;
import javax.sql.DataSource;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.databases.definitions.MariaDBDefinition;

public class MariaClusterDB
extends DBDatabase {
    private static final String MARIADBDRIVERNAME = "com.mariadb.jdbc.Driver";

    public MariaClusterDB(DataSource ds) {
        super(new MariaDBDefinition(), ds);
    }

    public MariaClusterDB(String jdbcURL, String username, String password) {
        super(new MariaDBDefinition(), MARIADBDRIVERNAME, jdbcURL, username, password);
    }

    public MariaClusterDB(String server, long port, String databaseName, String username, String password) {
        super(new MariaDBDefinition(), MARIADBDRIVERNAME, "jdbc:mariadb://" + server + ":" + port + "/" + databaseName, username, password);
        this.setDatabaseName(databaseName);
    }

    public MariaClusterDB(List<String> servers, List<Long> ports, String databaseName, String username, String password) {
        String hosts = "";
        String sep = "";
        if (servers.size() == ports.size()) {
            for (int i = 0; i < servers.size(); ++i) {
                String server = servers.get(i);
                Long port = ports.get(i);
                hosts = hosts + sep + server + ":" + port;
                sep = ",";
            }
        }
        this.setDriverName(MARIADBDRIVERNAME);
        this.setDefinition(new MariaDBDefinition());
        this.setJdbcURL("jdbc:mariadb://" + hosts + "/" + databaseName);
        this.setUsername(username);
        this.setPassword(password);
        this.setDatabaseName(databaseName);
    }

    @Override
    public boolean supportsFullOuterJoinNatively() {
        return false;
    }

    @Override
    public DBDatabase clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

