/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.databases;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import nz.co.gregs.dbvolution.DBDatabase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBStatement
implements Statement {
    private static final Log log = LogFactory.getLog(DBStatement.class);
    private Statement internalStatement;
    private boolean batchHasEntries;
    private final DBDatabase database;
    private final Connection connection;

    public DBStatement(DBDatabase db, Connection connection) throws SQLException {
        this.database = db;
        this.connection = connection;
        this.internalStatement = connection.createStatement();
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        String logSQL = "EXECUTING QUERY: " + string;
        this.database.printSQLIfRequested(logSQL);
        log.info((Object)logSQL);
        return this.getInternalStatement().executeQuery(string);
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        return this.getInternalStatement().executeUpdate(string);
    }

    @Override
    public void close() throws SQLException {
        try {
            this.database.unusedConnection(this.getConnection());
            this.getInternalStatement().close();
        }
        catch (SQLException e) {
            log.warn((Object)("Exception occurred during close(): " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.getInternalStatement().getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        this.getInternalStatement().setMaxFieldSize(i);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.getInternalStatement().getMaxRows();
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        this.getInternalStatement().setMaxRows(i);
    }

    @Override
    public void setEscapeProcessing(boolean bln) throws SQLException {
        this.getInternalStatement().setEscapeProcessing(bln);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.getInternalStatement().getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        this.getInternalStatement().setQueryTimeout(i);
    }

    @Override
    public void cancel() throws SQLException {
        this.getInternalStatement().cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getInternalStatement().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getInternalStatement().clearWarnings();
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.getInternalStatement().setCursorName(string);
    }

    @Override
    public boolean execute(String string) throws SQLException {
        String logSQL = "EXECUTING: " + string;
        this.database.printSQLIfRequested(logSQL);
        log.info((Object)logSQL);
        return this.getInternalStatement().execute(string);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getInternalStatement().getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.getInternalStatement().getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getInternalStatement().getMoreResults();
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        this.getInternalStatement().setFetchDirection(i);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.getInternalStatement().getFetchDirection();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        this.getInternalStatement().setFetchSize(i);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.getInternalStatement().getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.getInternalStatement().getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.getInternalStatement().getResultSetType();
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.getInternalStatement().addBatch(string);
        this.setBatchHasEntries(true);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.getInternalStatement().clearBatch();
        this.setBatchHasEntries(false);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.getInternalStatement().executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        return this.getInternalStatement().getMoreResults();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.getInternalStatement().getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String string, int i) throws SQLException {
        return this.getInternalStatement().executeUpdate(string, i);
    }

    @Override
    public int executeUpdate(String string, int[] ints) throws SQLException {
        return this.getInternalStatement().executeUpdate(string, ints);
    }

    @Override
    public int executeUpdate(String string, String[] strings) throws SQLException {
        String logSQL = "EXECUTING UPDATE: " + string;
        this.database.printSQLIfRequested(logSQL);
        log.info((Object)logSQL);
        return this.getInternalStatement().executeUpdate(string, strings);
    }

    @Override
    public boolean execute(String string, int i) throws SQLException {
        String logSQL = "EXECUTING: " + string;
        this.database.printSQLIfRequested(logSQL);
        log.info((Object)logSQL);
        return this.getInternalStatement().execute(string, i);
    }

    @Override
    public boolean execute(String string, int[] ints) throws SQLException {
        String logSQL = "EXECUTING: " + string;
        this.database.printSQLIfRequested(logSQL);
        log.info((Object)logSQL);
        return this.getInternalStatement().execute(string, ints);
    }

    @Override
    public boolean execute(String string, String[] strings) throws SQLException {
        String logSQL = "EXECUTING: " + string;
        this.database.printSQLIfRequested(logSQL);
        log.info((Object)logSQL);
        return this.getInternalStatement().execute(string, strings);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.getInternalStatement().getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getInternalStatement().isClosed();
    }

    @Override
    public void setPoolable(boolean bln) throws SQLException {
        this.getInternalStatement().setPoolable(bln);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.getInternalStatement().isPoolable();
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        return this.getInternalStatement().unwrap(type);
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return this.getInternalStatement().isWrapperFor(type);
    }

    private void setBatchHasEntries(boolean b) {
        this.batchHasEntries = b;
    }

    public boolean getBatchHasEntries() {
        return this.batchHasEntries;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Statement getInternalStatement() {
        return this.internalStatement;
    }

    protected void setInternalStatement(Statement realStatement) {
        this.internalStatement = realStatement;
    }
}

