/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.columns;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.exceptions.DBRuntimeException;
import nz.co.gregs.dbvolution.exceptions.IncorrectRowProviderInstanceSuppliedException;
import nz.co.gregs.dbvolution.expressions.DBExpression;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;
import nz.co.gregs.dbvolution.query.RowDefinition;

public class AbstractColumn
implements DBExpression {
    private final PropertyWrapper propertyWrapper;
    private final RowDefinition dbrow;
    private final Object field;

    public AbstractColumn(RowDefinition row, Object field) throws IncorrectRowProviderInstanceSuppliedException {
        this.dbrow = row;
        this.field = field;
        this.propertyWrapper = row.getPropertyWrapperOf(field);
        if (this.propertyWrapper == null) {
            throw IncorrectRowProviderInstanceSuppliedException.newMultiRowInstance(field);
        }
    }

    @Override
    public String toSQLString(DBDatabase db) {
        return db.getDefinition().formatTableAliasAndColumnName(this.getDBRow(), this.propertyWrapper.columnName());
    }

    @Override
    public AbstractColumn copy() {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(this.getDBRow().getClass(), this.getField().getClass());
            AbstractColumn newInstance = (AbstractColumn)constructor.newInstance(this.getDBRow(), this.getField());
            return newInstance;
        }
        catch (NoSuchMethodException ex) {
            throw new DBRuntimeException("Unable To Copy " + this.getClass().getSimpleName() + ": please ensure it has a public " + this.getClass().getSimpleName() + "(DBRow, Object) constructor.", ex);
        }
        catch (SecurityException ex) {
            throw new DBRuntimeException("Unable To Copy " + this.getClass().getSimpleName() + ": please ensure it has a public " + this.getClass().getSimpleName() + "(DBRow, Object) constructor.", ex);
        }
        catch (InstantiationException ex) {
            throw new DBRuntimeException("Unable To Copy " + this.getClass().getSimpleName() + ": please ensure it has a public " + this.getClass().getSimpleName() + "(DBRow, Object) constructor.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new DBRuntimeException("Unable To Copy " + this.getClass().getSimpleName() + ": please ensure it has a public " + this.getClass().getSimpleName() + "(DBRow, Object) constructor.", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new DBRuntimeException("Unable To Copy " + this.getClass().getSimpleName() + ": please ensure it has a public " + this.getClass().getSimpleName() + "(DBRow, Object) constructor.", ex);
        }
        catch (InvocationTargetException ex) {
            throw new DBRuntimeException("Unable To Copy " + this.getClass().getSimpleName() + ": please ensure it has a public " + this.getClass().getSimpleName() + "(DBRow, Object) constructor.", ex);
        }
    }

    public PropertyWrapper getPropertyWrapper() {
        return this.propertyWrapper;
    }

    public DBExpression asValue() {
        return this;
    }

    @Override
    public QueryableDatatype getQueryableDatatypeForExpressionValue() {
        return QueryableDatatype.getQueryableDatatypeForObject(this.getField());
    }

    @Override
    public boolean isAggregator() {
        return false;
    }

    @Override
    public Set<DBRow> getTablesInvolved() {
        HashSet<DBRow> hashSet = new HashSet<DBRow>();
        if (DBRow.class.isAssignableFrom(this.getDBRow().getClass())) {
            hashSet.add((DBRow)this.getDBRow());
        }
        return hashSet;
    }

    protected RowDefinition getDBRow() {
        return this.dbrow;
    }

    protected Object getField() {
        return this.field;
    }
}

