/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBUpdateSimpleTypes;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;

public class DBUpdateToPreviousValues
extends DBUpdateSimpleTypes {
    DBUpdateToPreviousValues(DBRow row) {
        super(row);
    }

    @Override
    protected String getSetClause(DBDatabase db, DBRow row) {
        DBDefinition defn = db.getDefinition();
        StringBuilder sql = new StringBuilder();
        List<PropertyWrapper> fields = row.getPropertyWrappers();
        String separator = defn.getStartingSetSubClauseSeparator();
        for (PropertyWrapper field : fields) {
            Object qdt;
            if (!field.isColumn() || !((QueryableDatatype)(qdt = field.getQueryableDatatype())).hasChanged()) continue;
            String previousSQLValue = ((QueryableDatatype)qdt).getPreviousSQLValue(db);
            if (previousSQLValue == null) {
                previousSQLValue = defn.getNull();
            }
            String columnName = field.columnName();
            sql.append(separator).append(defn.formatColumnName(columnName)).append(defn.getEqualsComparator()).append(previousSQLValue);
            separator = defn.getSubsequentSetSubClauseSeparator();
        }
        return sql.toString();
    }

    @Override
    protected String getWhereClause(DBDatabase db, DBRow row) {
        DBDefinition defn = db.getDefinition();
        Object primaryKey = row.getPrimaryKey();
        String pkCurrentValue = ((QueryableDatatype)primaryKey).toSQLString(db);
        return defn.formatColumnName(row.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + pkCurrentValue;
    }
}

