/*
 * Decompiled with CFR 0.152.
 */
package nz.co.gregs.dbvolution.actions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import nz.co.gregs.dbvolution.DBDatabase;
import nz.co.gregs.dbvolution.DBRow;
import nz.co.gregs.dbvolution.actions.DBAction;
import nz.co.gregs.dbvolution.actions.DBActionList;
import nz.co.gregs.dbvolution.actions.DBUpdate;
import nz.co.gregs.dbvolution.actions.DBUpdateToPreviousValues;
import nz.co.gregs.dbvolution.databases.DBStatement;
import nz.co.gregs.dbvolution.databases.definitions.DBDefinition;
import nz.co.gregs.dbvolution.datatypes.QueryableDatatype;
import nz.co.gregs.dbvolution.internal.properties.PropertyWrapper;

public class DBUpdateSimpleTypes
extends DBUpdate {
    DBUpdateSimpleTypes(DBRow row) {
        super(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DBActionList execute(DBDatabase db) throws SQLException {
        DBRow row = this.getRow();
        DBActionList actions = new DBActionList(new DBUpdateSimpleTypes(row));
        DBStatement statement = db.getDBStatement();
        try {
            for (String sql : this.getSQLStatements(db)) {
                statement.execute(sql);
            }
        }
        finally {
            statement.close();
        }
        return actions;
    }

    @Override
    public List<String> getSQLStatements(DBDatabase db) {
        DBRow row = this.getRow();
        ArrayList<String> sqls = new ArrayList<String>();
        DBDefinition defn = db.getDefinition();
        String sql = defn.beginUpdateLine() + defn.formatTableName(row) + defn.beginSetClause() + this.getSetClause(db, row) + defn.beginWhereClause() + this.getWhereClause(db, row) + defn.endDeleteLine();
        sqls.add(sql);
        return sqls;
    }

    protected String getSetClause(DBDatabase db, DBRow row) {
        DBDefinition defn = db.getDefinition();
        StringBuilder sql = new StringBuilder();
        List<PropertyWrapper> fields = row.getPropertyWrappers();
        String separator = defn.getStartingSetSubClauseSeparator();
        for (PropertyWrapper field : fields) {
            Object qdt;
            if (!field.isColumn() || !((QueryableDatatype)(qdt = field.getQueryableDatatype())).hasChanged()) continue;
            String columnName = field.columnName();
            sql.append(separator).append(defn.formatColumnName(columnName)).append(defn.getEqualsComparator()).append(((QueryableDatatype)qdt).toSQLString(db));
            separator = defn.getSubsequentSetSubClauseSeparator();
        }
        return sql.toString();
    }

    @Override
    protected DBActionList getRevertDBActionList() {
        DBActionList dbActionList = new DBActionList(new DBAction[0]);
        dbActionList.add(new DBUpdateToPreviousValues(this.getRow()));
        return dbActionList;
    }

    protected String getWhereClause(DBDatabase db, DBRow row) {
        DBDefinition defn = db.getDefinition();
        Object primaryKey = row.getPrimaryKey();
        String pkOriginalValue = ((QueryableDatatype)primaryKey).hasChanged() ? ((QueryableDatatype)primaryKey).getPreviousSQLValue(db) : ((QueryableDatatype)primaryKey).toSQLString(db);
        return defn.formatColumnName(row.getPrimaryKeyColumnName()) + defn.getEqualsComparator() + pkOriginalValue;
    }

    @Override
    protected DBActionList getActions() {
        return new DBActionList(new DBUpdateSimpleTypes(this.getRow()));
    }
}

